/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.StringMapping;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.mapping.oracle.OracleBlobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.oracle.OracleClobRDBMSMapping;

public class OracleStringMapping
extends StringMapping
implements MappingCallbacks {
    public void insertPostProcessing(ObjectProvider op) {
        String value = (String)op.provideField(this.mmd.getAbsoluteFieldNumber());
        op.isLoaded(this.mmd.getAbsoluteFieldNumber());
        if (value == null) {
            value = "";
        } else if (value.length() == 0) {
            value = this.storeMgr.getBooleanProperty("datanucleus.rdbms.persistEmptyStringAsNull") ? "" : ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getSurrogateForEmptyStrings();
        }
        if (this.mmd.getColumnMetaData()[0].getJdbcType().toUpperCase().equals("BLOB")) {
            OracleBlobRDBMSMapping.updateBlobColumn(op, this.getDatastoreContainer(), this.getDatastoreMapping(0), value.getBytes());
        } else if (this.mmd.getColumnMetaData()[0].getJdbcType().toUpperCase().equals("CLOB")) {
            OracleClobRDBMSMapping.updateClobColumn(op, this.getDatastoreContainer(), this.getDatastoreMapping(0), value);
        } else {
            throw new NucleusException("AssertionError: Only JDBC types BLOB and CLOB are allowed!");
        }
    }

    public void postInsert(ObjectProvider op) {
    }

    public void postFetch(ObjectProvider op) {
    }

    public void postUpdate(ObjectProvider op) {
        this.insertPostProcessing(op);
    }

    public void preDelete(ObjectProvider op) {
    }
}

