/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Date;
import javax.time.calendar.LocalDate;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.JavaxTimeLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;
import org.datanucleus.store.types.converters.LocalDateStringConverter;

public class LocalDateLiteral
extends JavaxTimeLiteral {
    private final LocalDate value;

    public LocalDateLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, mapping, parameterName);
        if (value == null) {
            this.value = null;
        } else if (value instanceof LocalDate) {
            this.value = (LocalDate)value;
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        if (mapping.getJavaTypeForDatastoreMapping(0).equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String str = new LocalDateStringConverter().toDatastoreType((LocalDate)value);
            this.delegate = new StringLiteral(stmt, mapping, (Object)(this.value != null ? str : null), parameterName);
        } else if (this.value == null) {
            this.delegate = new TemporalLiteral(stmt, mapping, null, parameterName);
        } else {
            LocalDate localDate = (LocalDate)value;
            Date date = new Date();
            date.setYear(localDate.getYear());
            date.setMonth(localDate.getMonthOfYear().ordinal());
            date.setDate(localDate.getDayOfMonth());
            this.delegate = new TemporalLiteral(stmt, mapping, date, parameterName);
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }
}

