/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sql.OPAQUE;
import oracle.xdb.XMLType;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.CharRDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;

public class XMLTypeRDBMSMapping
extends CharRDBMSMapping {
    protected XMLTypeRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public XMLTypeRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(mapping, storeMgr, field);
    }

    protected void initialize() {
        this.initTypeInfo();
    }

    public SQLTypeInfo getTypeInfo() {
        return this.storeMgr.getSQLTypeInfoForJDBCType(2007);
    }

    public String getString(Object rs, int param) {
        String value = null;
        try {
            OPAQUE o = (OPAQUE)((ResultSet)rs).getObject(param);
            if (o != null) {
                value = XMLType.createXML((OPAQUE)o).getStringVal();
            }
            if (this.getDatabaseAdapter().supportsOption("NullEqualsEmptyString") && value != null && value.equals(this.getDatabaseAdapter().getSurrogateForEmptyStrings())) {
                value = "";
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setString(Object ps, int param, String value) {
        try {
            if (value == null) {
                if (this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setString(param, this.column.getDefaultValue().toString().trim());
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType(), "SYS.XMLTYPE");
                }
            } else {
                ((PreparedStatement)ps).setString(param, value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }
}

