/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class BooleanRDBMSMapping
extends RDBMSMapping {
    protected BooleanRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public BooleanRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public boolean isBooleanBased() {
        return true;
    }

    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(16, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(16);
    }

    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setBoolean(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"boolean", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public boolean getBoolean(Object rs, int param) {
        boolean value;
        try {
            value = ((ResultSet)rs).getBoolean(param);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Boolean", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setString(Object ps, int param, String value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
            } else {
                ((PreparedStatement)ps).setBoolean(param, value.equals("Y"));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public String getString(Object rs, int param) {
        String value;
        try {
            value = ((ResultSet)rs).getBoolean(param) ? "Y" : "N";
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"String", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        block5: {
            try {
                if (value == null) {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                    break block5;
                }
                if (value instanceof String) {
                    ((PreparedStatement)ps).setBoolean(param, value.equals("Y"));
                    break block5;
                }
                if (value instanceof Boolean) {
                    ((PreparedStatement)ps).setBoolean(param, (Boolean)value);
                    break block5;
                }
                throw new NucleusUserException(LOCALISER_RDBMS.msg("055004", value, (Object)this.column));
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
    }

    public Object getObject(Object rs, int param) {
        Object value;
        try {
            boolean b = ((ResultSet)rs).getBoolean(param);
            value = ((ResultSet)rs).wasNull() ? null : (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_STRING) ? (b ? "Y" : "N") : (b ? Boolean.TRUE : Boolean.FALSE));
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

