/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.store.mapped.ColumnCreator;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreElementContainer;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.ElementContainerTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class CollectionTable
extends ElementContainerTable
implements DatastoreElementContainer {
    public CollectionTable(DatastoreIdentifier tableName, AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr) {
        super(tableName, mmd, storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        PrimaryKeyMetaData pkmd;
        super.initialize(clr);
        PrimaryKeyMetaData primaryKeyMetaData = pkmd = this.mmd.getJoinMetaData() != null ? this.mmd.getJoinMetaData().getPrimaryKeyMetaData() : null;
        boolean pkColsSpecified = pkmd != null ? pkmd.getColumnMetaData() != null : false;
        boolean pkRequired = this.requiresPrimaryKey();
        boolean elementPC = this.mmd.hasCollection() && this.mmd.getCollection().elementIsPersistent();
        Class elementClass = clr.classForName(this.getElementType());
        if (this.isSerialisedElement() || this.isEmbeddedElementPC() || this.isEmbeddedElement() && !elementPC || ClassUtils.isReferenceType((Class)elementClass)) {
            this.elementMapping = this.storeMgr.getMappingManager().getMapping((DatastoreContainerObject)this, this.mmd, clr, 3);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.elementMapping);
            }
        } else {
            ColumnMetaData[] elemColmd = null;
            AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
            ElementMetaData elemmd = this.mmd.getElementMetaData();
            if (elemmd != null && elemmd.getColumnMetaData() != null && elemmd.getColumnMetaData().length > 0) {
                elemColmd = elemmd.getColumnMetaData();
            } else if (relatedMmds != null && relatedMmds[0].getJoinMetaData() != null && relatedMmds[0].getJoinMetaData().getColumnMetaData() != null && relatedMmds[0].getJoinMetaData().getColumnMetaData().length > 0) {
                elemColmd = relatedMmds[0].getJoinMetaData().getColumnMetaData();
            }
            this.elementMapping = ColumnCreator.createColumnsForJoinTables((Class)elementClass, (AbstractMemberMetaData)this.mmd, (ColumnMetaData[])elemColmd, (MappedStoreManager)this.storeMgr, (DatastoreContainerObject)this, (boolean)false, (boolean)false, (int)3, (ClassLoaderResolver)clr);
            if (Boolean.TRUE.equals(this.mmd.getContainer().allowNulls())) {
                for (int i = 0; i < this.elementMapping.getNumberOfDatastoreMappings(); ++i) {
                    Column elementCol = (Column)this.elementMapping.getDatastoreMapping(i).getDatastoreField();
                    elementCol.setNullable();
                }
            }
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.elementMapping);
            }
        }
        boolean orderRequired = false;
        if (this.mmd.getOrderMetaData() != null) {
            if (this.mmd.getOrderMetaData().isIndexedList()) {
                orderRequired = true;
            }
        } else if (List.class.isAssignableFrom(this.mmd.getType())) {
            orderRequired = true;
        } else if (this.requiresPrimaryKey() && !pkColsSpecified) {
            if (this.isEmbeddedElementPC()) {
                if (this.mmd.getCollection().getElementClassMetaData(clr, this.storeMgr.getMetaDataManager()).getIdentityType() != IdentityType.APPLICATION) {
                    orderRequired = true;
                }
            } else if (this.isSerialisedElement()) {
                orderRequired = true;
            } else if (this.elementMapping instanceof ReferenceMapping) {
                ReferenceMapping refMapping = (ReferenceMapping)this.elementMapping;
                if (refMapping.getJavaTypeMapping().length > 1) {
                    orderRequired = true;
                }
            } else if (!(this.elementMapping instanceof PersistableMapping)) {
                Column elementCol = (Column)this.elementMapping.getDatastoreMapping(0).getDatastoreField();
                if (!((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).isValidPrimaryKeyType(elementCol.getJdbcType())) {
                    orderRequired = true;
                }
            }
        }
        if (orderRequired) {
            DatastoreIdentifier id;
            ColumnMetaData orderColmd = null;
            if (this.mmd.getOrderMetaData() != null && this.mmd.getOrderMetaData().getColumnMetaData() != null && this.mmd.getOrderMetaData().getColumnMetaData().length > 0) {
                orderColmd = this.mmd.getOrderMetaData().getColumnMetaData()[0];
                if (orderColmd.getName() == null) {
                    orderColmd = new ColumnMetaData(orderColmd);
                    if (this.mmd.hasExtension("adapter-column-name")) {
                        orderColmd.setName(this.mmd.getValueForExtension("adapter-column-name"));
                    } else {
                        id = this.storeMgr.getIdentifierFactory().newIndexFieldIdentifier(this.mmd);
                        orderColmd.setName(id.getIdentifierName());
                    }
                }
            } else if (this.mmd.hasExtension("adapter-column-name")) {
                orderColmd = new ColumnMetaData();
                orderColmd.setName(this.mmd.getValueForExtension("adapter-column-name"));
            } else {
                id = this.storeMgr.getIdentifierFactory().newIndexFieldIdentifier(this.mmd);
                orderColmd = new ColumnMetaData();
                orderColmd.setName(id.getIdentifierName());
            }
            this.orderMapping = this.storeMgr.getMappingManager().getMapping(Integer.TYPE);
            ColumnCreator.createIndexColumn((JavaTypeMapping)this.orderMapping, (MappedStoreManager)this.storeMgr, (ClassLoaderResolver)clr, (DatastoreContainerObject)this, (ColumnMetaData)orderColmd, (pkRequired && !pkColsSpecified ? 1 : 0) != 0);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.orderMapping);
            }
        }
        if (pkRequired) {
            if (pkColsSpecified) {
                this.applyUserPrimaryKeySpecification(pkmd);
            } else if (orderRequired) {
                this.orderMapping.getDatastoreMapping(0).getDatastoreField().setAsPrimaryKey();
            } else {
                for (int i = 0; i < this.elementMapping.getNumberOfDatastoreMappings(); ++i) {
                    this.elementMapping.getDatastoreMapping(i).getDatastoreField().setAsPrimaryKey();
                }
            }
        }
        this.state = 2;
    }

    public String getElementType() {
        return this.mmd.getCollection().getElementType();
    }

    public boolean isSerialisedElement() {
        return this.mmd.getCollection() != null && this.mmd.getCollection().isSerializedElement();
    }

    public boolean isEmbeddedElement() {
        if (this.mmd.getCollection() != null && this.mmd.getCollection().isSerializedElement()) {
            return false;
        }
        return this.mmd.getCollection() != null && this.mmd.getCollection().isEmbeddedElement();
    }

    public boolean isSerialisedElementPC() {
        return this.mmd.getCollection() != null && this.mmd.getCollection().isSerializedElement() && this.mmd.getCollection().elementIsPersistent();
    }

    public boolean isEmbeddedElementPC() {
        if (this.mmd.getCollection() != null && this.mmd.getCollection().isSerializedElement()) {
            return false;
        }
        return this.mmd.getElementMetaData() != null && this.mmd.getElementMetaData().getEmbeddedMetaData() != null;
    }

    protected boolean requiresPrimaryKey() {
        if (this.mmd.getOrderMetaData() != null && !this.mmd.getOrderMetaData().isIndexedList()) {
            return false;
        }
        return super.requiresPrimaryKey();
    }
}

