/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.util.Localiser;

public abstract class BaseContainerStore {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected MappedStoreManager storeMgr;
    protected DatastoreAdapter dba;
    protected JavaTypeMapping ownerMapping;
    protected AbstractMemberMetaData ownerMemberMetaData;
    protected int relationType;
    protected boolean allowNulls = false;

    protected BaseContainerStore(StoreManager storeMgr) {
        this.storeMgr = (MappedStoreManager)storeMgr;
        this.dba = this.storeMgr.getDatastoreAdapter();
    }

    protected void setOwner(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        this.ownerMemberMetaData = mmd;
        if (Boolean.TRUE.equals(this.ownerMemberMetaData.getContainer().allowNulls())) {
            this.allowNulls = true;
        }
        this.relationType = this.ownerMemberMetaData.getRelationType(clr);
    }

    public MappedStoreManager getStoreManager() {
        return this.storeMgr;
    }

    public JavaTypeMapping getOwnerMapping() {
        return this.ownerMapping;
    }

    protected boolean isEmbeddedMapping(JavaTypeMapping mapping) {
        return !InterfaceMapping.class.isAssignableFrom(mapping.getClass()) && !OIDMapping.class.isAssignableFrom(mapping.getClass());
    }

    public ObjectProvider getStateManagerForEmbeddedPCObject(ObjectProvider sm, Object obj, AbstractMemberMetaData ownerMmd, short pcType) {
        ExecutionContext ec = sm.getExecutionContext();
        ObjectProvider objSM = ec.findObjectProvider(obj);
        if (objSM == null) {
            objSM = ObjectProviderFactory.newForEmbedded((ExecutionContext)ec, (Object)obj, (boolean)false, (ObjectProvider)sm, (int)ownerMmd.getAbsoluteFieldNumber());
        }
        objSM.setPcObjectType(pcType);
        return objSM;
    }

    protected boolean allowsBatching() {
        return this.storeMgr.allowsBatching();
    }

    public int getRelationType() {
        return this.relationType;
    }

    public AbstractMemberMetaData getOwnerMemberMetaData() {
        return this.ownerMemberMetaData;
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.dba;
    }
}

