/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class LongVarcharRDBMSMapping
extends RDBMSMapping {
    protected LongVarcharRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public LongVarcharRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    public boolean isStringBased() {
        return true;
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public SQLTypeInfo getTypeInfo() {
        return this.storeMgr.getSQLTypeInfoForJDBCType(-1);
    }

    public void setString(Object ps, int param, String value) {
        try {
            if (value == null) {
                if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setString(param, this.column.getDefaultValue().toString().trim());
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                }
            } else {
                ((PreparedStatement)ps).setString(param, value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public String getString(Object rs, int param) {
        String value;
        try {
            value = ((ResultSet)rs).getString(param);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"String", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
            } else {
                ((PreparedStatement)ps).setString(param, (String)value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public Object getObject(Object rs, int param) {
        String value;
        try {
            String s = ((ResultSet)rs).getString(param);
            value = ((ResultSet)rs).wasNull() ? null : s;
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

