/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.exceptions.NullValueException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class CharRDBMSMapping
extends RDBMSMapping {
    private SimpleDateFormat javaUtilDateFormat;

    protected CharRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public CharRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    protected void initialize() {
        if (this.column != null) {
            Object[] validValues;
            SingleFieldMapping m;
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && this.column.getColumnMetaData().getLength() == null && (m = (SingleFieldMapping)this.getJavaTypeMapping()).getDefaultLength(0) > 0) {
                this.column.getColumnMetaData().setLength(Integer.valueOf(m.getDefaultLength(0)));
            }
            this.column.getColumnMetaData().setJdbcType("CHAR");
            this.column.checkString();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                String constraints = this.getDatabaseAdapter().getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
            if (this.getJavaTypeMapping().getJavaType() == Boolean.class) {
                this.column.getColumnMetaData().setLength(Integer.valueOf(1));
                StringBuffer constraints = new StringBuffer("CHECK (" + this.column.getIdentifier() + " IN ('Y','N')");
                if (this.column.isNullable()) {
                    constraints.append(" OR " + this.column.getIdentifier() + " IS NULL");
                }
                constraints.append(')');
                this.column.setConstraints(constraints.toString());
            }
            int maxlength = this.getTypeInfo().getPrecision();
            if ((this.column.getColumnMetaData().getLength() <= 0 || this.column.getColumnMetaData().getLength() > maxlength) && this.getTypeInfo().isAllowsPrecisionSpec()) {
                throw new NucleusUserException("String max length of " + this.column.getColumnMetaData().getLength() + " is outside the acceptable range [0, " + maxlength + "] for column \"" + this.column.getIdentifier() + "\"");
            }
        }
        this.initTypeInfo();
    }

    public boolean isStringBased() {
        return true;
    }

    public SQLTypeInfo getTypeInfo() {
        return this.storeMgr.getSQLTypeInfoForJDBCType(1);
    }

    public void setChar(Object ps, int param, char value) {
        try {
            if (value == '\u0000' && !this.getDatabaseAdapter().supportsOption("PersistOfUnassignedChar")) {
                value = (char)32;
                NucleusLogger.DATASTORE.warn((Object)LOCALISER_RDBMS.msg("055008"));
            }
            ((PreparedStatement)ps).setString(param, Character.valueOf(value).toString());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"char", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public char getChar(Object rs, int param) {
        char value;
        try {
            value = ((ResultSet)rs).getString(param).charAt(0);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"char", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setString(Object ps, int param, String value) {
        try {
            if (value == null) {
                if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setString(param, this.column.getDefaultValue().toString().trim());
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                }
            } else if (value.length() == 0) {
                if (this.storeMgr.getBooleanProperty("datanucleus.rdbms.persistEmptyStringAsNull")) {
                    ((PreparedStatement)ps).setString(param, null);
                } else {
                    if (this.getDatabaseAdapter().supportsOption("NullEqualsEmptyString")) {
                        value = this.getDatabaseAdapter().getSurrogateForEmptyStrings();
                    }
                    ((PreparedStatement)ps).setString(param, value);
                }
            } else {
                Integer colLength;
                if (this.column != null && (colLength = this.column.getColumnMetaData().getLength()) != null && colLength < value.length()) {
                    String action = this.storeMgr.getStringProperty("datanucleus.rdbms.stringLengthExceededAction");
                    if (action.equals("EXCEPTION")) {
                        throw new NucleusUserException(LOCALISER_RDBMS.msg("055007", (Object)value, (Object)this.column.getIdentifier().toString(), (Object)("" + colLength))).setFatal();
                    }
                    if (action.equals("TRUNCATE")) {
                        value = value.substring(0, colLength);
                    }
                }
                ((PreparedStatement)ps).setString(param, value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public String getString(Object rs, int param) {
        try {
            String value = ((ResultSet)rs).getString(param);
            if (value == null) {
                return value;
            }
            if (this.getDatabaseAdapter().supportsOption("NullEqualsEmptyString") && value.equals(this.getDatabaseAdapter().getSurrogateForEmptyStrings())) {
                return "";
            }
            if (this.column.getJdbcType() == 1 && this.getDatabaseAdapter().supportsOption("CharColumnsPaddedWithSpaces")) {
                int numPaddingChars = 0;
                for (int i = value.length() - 1; i >= 0 && value.charAt(i) == ' '; --i) {
                    ++numPaddingChars;
                }
                if (numPaddingChars > 0) {
                    value = value.substring(0, value.length() - numPaddingChars);
                }
            }
            return value;
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setString(param, value ? "Y" : "N");
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"boolean", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public boolean getBoolean(Object rs, int param) {
        boolean value;
        block6: {
            try {
                String s = ((ResultSet)rs).getString(param);
                if (s == null) {
                    if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                        throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
                    }
                    return false;
                }
                if (s.equals("Y")) {
                    value = true;
                    break block6;
                }
                if (s.equals("N")) {
                    value = false;
                    break block6;
                }
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"boolean", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
            } else if (value instanceof Boolean) {
                ((PreparedStatement)ps).setString(param, (Boolean)value != false ? "Y" : "N");
            } else if (value instanceof Time) {
                ((PreparedStatement)ps).setString(param, ((Time)value).toString());
            } else if (value instanceof Date) {
                ((PreparedStatement)ps).setString(param, ((Date)value).toString());
            } else if (value instanceof java.util.Date) {
                ((PreparedStatement)ps).setString(param, this.getJavaUtilDateFormat().format((java.util.Date)value));
            } else if (value instanceof Timestamp) {
                Calendar cal = this.storeMgr.getCalendarForDateTimezone();
                if (cal != null) {
                    ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value, cal);
                } else {
                    ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value);
                }
            } else if (value instanceof String) {
                ((PreparedStatement)ps).setString(param, (String)value);
            } else {
                ((PreparedStatement)ps).setString(param, value.toString());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObject(Object rs, int param) {
        try {
            String s = ((ResultSet)rs).getString(param);
            if (s == null) {
                return null;
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_BOOLEAN)) {
                if (s.equals("Y")) {
                    return Boolean.TRUE;
                }
                if (!s.equals("N")) throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
                return Boolean.FALSE;
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_CHARACTER)) {
                return Character.valueOf(s.charAt(0));
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIME)) {
                return Time.valueOf(s);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_DATE)) {
                return Date.valueOf(s);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
                return this.getJavaUtilDateFormat().parse(s);
            }
            if (!this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIMESTAMP)) return s;
            Calendar cal = this.storeMgr.getCalendarForDateTimezone();
            return TypeConversionHelper.stringToTimestamp((String)s, (Calendar)cal);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        catch (ParseException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public SimpleDateFormat getJavaUtilDateFormat() {
        if (this.javaUtilDateFormat == null) {
            Calendar cal = this.storeMgr.getCalendarForDateTimezone();
            this.javaUtilDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            if (cal != null) {
                this.javaUtilDateFormat.setTimeZone(cal.getTimeZone());
            }
        }
        return this.javaUtilDateFormat;
    }
}

