/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.sql.AbstractStatementGenerator;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class RDBMSQueryUtils
extends QueryUtils {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());

    public static String getClassNameFromDiscriminatorResultSetRow(JavaTypeMapping discrimMapping, DiscriminatorMetaData dismd, ResultSet rs, ExecutionContext ec) {
        String rowClassName = null;
        if (discrimMapping != null && dismd.getStrategy() != DiscriminatorStrategy.NONE) {
            try {
                String discriminatorColName = discrimMapping.getDatastoreMapping(0).getDatastoreField().getIdentifier().getIdentifierName();
                String discriminatorValue = rs.getString(discriminatorColName);
                rowClassName = MetaDataUtils.getClassNameFromDiscriminatorValue((String)discriminatorValue, (DiscriminatorMetaData)dismd, (ExecutionContext)ec);
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return rowClassName;
    }

    public static String getResultSetTypeForQuery(Query query) {
        String propName = "datanucleus.rdbms.query.resultSetType";
        String rsTypeString = query.getObjectManager().getOMFContext().getPersistenceConfiguration().getStringProperty(propName);
        Object rsTypeExt = query.getExtension(propName);
        if (rsTypeExt != null) {
            rsTypeString = (String)rsTypeExt;
        }
        return rsTypeString;
    }

    public static String getResultSetConcurrencyForQuery(Query query) {
        String propName = "datanucleus.rdbms.query.resultSetConcurrency";
        String rsConcurrencyString = query.getObjectManager().getOMFContext().getPersistenceConfiguration().getStringProperty(propName);
        Object rsConcurrencyExt = query.getExtension(propName);
        if (rsConcurrencyExt != null) {
            rsConcurrencyString = (String)rsConcurrencyExt;
        }
        return rsConcurrencyString;
    }

    public static boolean useUpdateLockForQuery(Query query) {
        if (query.getSerializeRead() != null) {
            return query.getSerializeRead();
        }
        return query.getObjectManager().getSerializeReadForClass(query.getCandidateClassName());
    }

    public static PreparedStatement getPreparedStatementForQuery(ManagedConnection conn, String queryStmt, Query query) throws SQLException {
        ExecutionContext ec = query.getObjectManager();
        String rsTypeString = RDBMSQueryUtils.getResultSetTypeForQuery(query);
        if (!(rsTypeString == null || rsTypeString.equals("scroll-sensitive") || rsTypeString.equals("forward-only") || rsTypeString.equals("scroll-insensitive"))) {
            throw new NucleusUserException(LOCALISER.msg("052510"));
        }
        String rsConcurrencyString = RDBMSQueryUtils.getResultSetConcurrencyForQuery(query);
        if (rsConcurrencyString != null && !rsConcurrencyString.equals("read-only") && !rsConcurrencyString.equals("updateable")) {
            throw new NucleusUserException(LOCALISER.msg("052511"));
        }
        SQLController sqlControl = ((RDBMSStoreManager)ec.getStoreManager()).getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, queryStmt, rsTypeString, rsConcurrencyString);
        return ps;
    }

    public static void prepareStatementForExecution(PreparedStatement ps, Query query, boolean applyTimeout) throws SQLException {
        Integer timeout;
        OMFContext omfCtx = query.getObjectManager().getOMFContext();
        MappedStoreManager storeMgr = (MappedStoreManager)omfCtx.getStoreManager();
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        if (applyTimeout && (timeout = query.getDatastoreReadTimeoutMillis()) != null && timeout > 0) {
            ps.setQueryTimeout(timeout / 1000);
        }
        int fetchSize = 0;
        if (query.getFetchPlan().getFetchSize() > 0) {
            fetchSize = query.getFetchPlan().getFetchSize();
        }
        if (storeMgr.getDatastoreAdapter().supportsQueryFetchSize(fetchSize)) {
            ps.setFetchSize(fetchSize);
        }
        String propName = "datanucleus.rdbms.query.fetchDirection";
        String fetchDir = conf.getStringProperty(propName);
        Object fetchDirExt = query.getExtension(propName);
        if (!(fetchDirExt == null || (fetchDir = (String)fetchDirExt).equals("forward") || fetchDir.equals("reverse") || fetchDir.equals("unknown"))) {
            throw new NucleusUserException(LOCALISER.msg("052512"));
        }
        if (fetchDir.equals("reverse")) {
            ps.setFetchDirection(1001);
        } else if (fetchDir.equals("unknown")) {
            ps.setFetchDirection(1002);
        }
        long toExclNo = query.getRangeToExcl();
        if (toExclNo != 0L && toExclNo != Long.MAX_VALUE) {
            if (toExclNo > Integer.MAX_VALUE) {
                ps.setMaxRows(Integer.MAX_VALUE);
            } else {
                ps.setMaxRows((int)toExclNo);
            }
        }
    }

    public static SQLStatement getStatementForCandidates(SQLStatement parentStmt, AbstractClassMetaData cmd, StatementClassMapping clsMapping, ExecutionContext ec, Class candidateCls, boolean subclasses, String result, String candidateAlias, String candidateTableGroupName) {
        SQLStatement stmt = null;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)ec.getStoreManager();
        DatastoreIdentifier candidateAliasId = null;
        if (candidateAlias != null) {
            candidateAliasId = storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(candidateAlias);
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        ArrayList<DatastoreClass> candidateTables = new ArrayList<DatastoreClass>();
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
            HashSet subclassNames;
            DatastoreClass candidateTable = storeMgr.getDatastoreClass(cmd.getFullClassName(), clr);
            if (candidateTable != null) {
                candidateTables.add(candidateTable);
            }
            if (subclasses && (subclassNames = storeMgr.getSubClassesForClass(cmd.getFullClassName(), subclasses, clr)) != null) {
                for (String subclassName : subclassNames) {
                    DatastoreClass tbl = storeMgr.getDatastoreClass(subclassName, clr);
                    if (tbl == null) continue;
                    candidateTables.add(tbl);
                }
            }
            Iterator iter = candidateTables.iterator();
            int maxClassNameLength = cmd.getFullClassName().length();
            while (iter.hasNext()) {
                DatastoreClass cls = (DatastoreClass)iter.next();
                String className = cls.getType();
                if (className.length() <= maxClassNameLength) continue;
                maxClassNameLength = className.length();
            }
            for (DatastoreClass cls : candidateTables) {
                SQLStatement tblStmt = new SQLStatement(parentStmt, storeMgr, (DatastoreContainerObject)candidateTable, candidateAliasId, candidateTableGroupName);
                tblStmt.setClassLoaderResolver(clr);
                tblStmt.setCandidateClassName(cls.getType());
                JavaTypeMapping m = storeMgr.getMappingManager().getMapping(String.class);
                String nuctypeName = cls.getType();
                if (maxClassNameLength > nuctypeName.length()) {
                    nuctypeName = StringUtils.leftAlignedPaddedString((String)nuctypeName, (int)maxClassNameLength);
                }
                StringLiteral lit = new StringLiteral(tblStmt, m, (Object)nuctypeName, null);
                tblStmt.select(lit, "NUCLEUS_TYPE");
                if (stmt == null) {
                    stmt = tblStmt;
                    continue;
                }
                stmt.union(tblStmt);
            }
            clsMapping.setNucleusTypeColumnName("NUCLEUS_TYPE");
        } else {
            DatastoreClass table;
            ArrayList<Class> candidateClasses = new ArrayList<Class>();
            if (ClassUtils.isReferenceType((Class)candidateCls)) {
                String[] clsNames = storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(candidateCls.getName(), clr);
                for (int i = 0; i < clsNames.length; ++i) {
                    Class cls = clr.classForName(clsNames[i]);
                    table = storeMgr.getDatastoreClass(clsNames[i], clr);
                    candidateClasses.add(cls);
                    candidateTables.add(table);
                    AbstractClassMetaData implCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(cls, clr);
                    if (implCmd.getIdentityType() != cmd.getIdentityType()) {
                        throw new NucleusUserException("You are querying an interface (" + cmd.getFullClassName() + ") " + "yet one of its implementations (" + implCmd.getFullClassName() + ") " + " uses a different identity type!");
                    }
                    if (cmd.getIdentityType() != IdentityType.APPLICATION || cmd.getPKMemberPositions().length == implCmd.getPKMemberPositions().length) continue;
                    throw new NucleusUserException("You are querying an interface (" + cmd.getFullClassName() + ") " + "yet one of its implementations (" + implCmd.getFullClassName() + ") " + " has a different number of PK members!");
                }
            } else {
                DatastoreClass candidateTable = storeMgr.getDatastoreClass(cmd.getFullClassName(), clr);
                if (candidateTable != null) {
                    candidateClasses.add(candidateCls);
                    candidateTables.add(candidateTable);
                } else {
                    AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(cmd, clr);
                    if (cmds != null && cmds.length > 0) {
                        for (int i = 0; i < cmds.length; ++i) {
                            table = storeMgr.getDatastoreClass(cmds[i].getFullClassName(), clr);
                            Class cls = clr.classForName(cmds[i].getFullClassName());
                            candidateClasses.add(cls);
                            candidateTables.add(table);
                        }
                    } else {
                        throw new UnsupportedOperationException("No tables for query of " + cmd.getFullClassName());
                    }
                }
            }
            for (int i = 0; i < candidateTables.size(); ++i) {
                DatastoreClass tbl = (DatastoreClass)candidateTables.get(i);
                Class cls = (Class)candidateClasses.get(i);
                AbstractStatementGenerator stmtGen = null;
                if (tbl.getDiscriminatorMapping(true) != null || QueryUtils.resultHasOnlyAggregates((String)result)) {
                    stmtGen = new DiscriminatorStatementGenerator(storeMgr, clr, cls, subclasses, candidateAliasId, candidateTableGroupName);
                } else {
                    stmtGen = new UnionStatementGenerator(storeMgr, clr, cls, subclasses, candidateAliasId, candidateTableGroupName);
                    if (result == null) {
                        stmtGen.setOption("selectNucleusType");
                        clsMapping.setNucleusTypeColumnName("NUCLEUS_TYPE");
                    }
                }
                stmtGen.setParentStatement(parentStmt);
                SQLStatement tblStmt = stmtGen.getStatement();
                if (stmt == null) {
                    stmt = tblStmt;
                    continue;
                }
                stmt.union(tblStmt);
            }
        }
        return stmt;
    }
}

