/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.mapped.scostore.FKArrayStoreSpecialization;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractArrayStoreSpecialization;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class RDBMSFKArrayStoreSpecialization
extends RDBMSAbstractArrayStoreSpecialization
implements FKArrayStoreSpecialization {
    private String updateFkStmt;
    private String clearNullifyStmt;

    RDBMSFKArrayStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, RDBMSStoreManager storeMgr) {
        super(localiser, clr, storeMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUpdateElementFk(ObjectProvider ownerSM, Object element, Object owner, int index, ElementContainerStore ecs) {
        boolean retval;
        String updateFkStmt = this.getUpdateFkStmt(ecs);
        ExecutionContext ec = ownerSM.getExecutionContext();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (ecs.getElementInfo().length > 1) {
                        DatastoreClass table = this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                        if (table != null) {
                            ps.setString(jdbcPosition++, table.toString());
                        } else {
                            NucleusLogger.PERSISTENCE.info((Object)(">> FKArrayStore.updateElementFK : need to set table in statement but dont know table where to store " + element));
                        }
                    }
                    if (owner == null) {
                        JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
                        ownerMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)ownerMapping), null);
                        jdbcPosition += ownerMapping.getNumberOfDatastoreMappings();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, (BaseContainerStore)ecs);
                    }
                    jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, ecs.getOrderMapping());
                    if (ecs.getRelationDiscriminatorMapping() != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, ecs);
                    }
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, ecs.getElementMapping());
                    sqlControl.executeStatementUpdate(mconn, updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056027", (Object)updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(ObjectProvider ownerSM, ElementContainerStore ecs) {
        String clearNullifyStmt = this.getClearNullifyStmt(ecs);
        try {
            ExecutionContext ec = ownerSM.getExecutionContext();
            ManagedConnection mconn = ecs.getStoreManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearNullifyStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, (BaseContainerStore)ecs);
                    if (ecs.getRelationDiscriminatorMapping() != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, ecs);
                    }
                    sqlControl.executeStatementUpdate(mconn, clearNullifyStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056013", (Object)clearNullifyStmt), (Throwable)e);
        }
    }

    private String getUpdateFkStmt(ElementContainerStore ecs) {
        if (this.updateFkStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
            JavaTypeMapping orderMapping = ecs.getOrderMapping();
            JavaTypeMapping elementMapping = ecs.getElementMapping();
            JavaTypeMapping relationDiscriminatorMapping = ecs.getRelationDiscriminatorMapping();
            ElementContainerStore.ElementInfo[] elementInfo = ecs.getElementInfo();
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(elementInfo[0].getDatastoreClass().toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < orderMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(orderMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)orderMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < elementMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(elementMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)elementMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            this.updateFkStmt = stmt.toString();
        }
        return this.updateFkStmt;
    }

    protected String getClearNullifyStmt(ElementContainerStore ecs) {
        if (this.clearNullifyStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
            JavaTypeMapping orderMapping = ecs.getOrderMapping();
            JavaTypeMapping relationDiscriminatorMapping = ecs.getRelationDiscriminatorMapping();
            ElementContainerStore.ElementInfo[] elementInfo = ecs.getElementInfo();
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(elementInfo[0].getDatastoreClass().toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(", ");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString() + " = NULL");
            }
            for (i = 0; i < orderMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(", ");
                stmt.append(orderMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString() + " = NULL");
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(", ");
                    stmt.append(relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString() + " = NULL");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.clearNullifyStmt = stmt.toString();
        }
        return this.clearNullifyStmt;
    }
}

