/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.ColumnCreator;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.TableUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public abstract class ElementContainerTable
extends JoinTable {
    protected JavaTypeMapping elementMapping;
    protected JavaTypeMapping orderMapping;
    protected JavaTypeMapping relationDiscriminatorMapping;
    protected String relationDiscriminatorValue;

    public ElementContainerTable(DatastoreIdentifier tableName, AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr) {
        super(tableName, mmd, storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        boolean pkRequired = this.requiresPrimaryKey();
        AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
        ColumnMetaData[] columnMetaData = null;
        if (this.mmd.getJoinMetaData() != null && this.mmd.getJoinMetaData().getColumnMetaData() != null && this.mmd.getJoinMetaData().getColumnMetaData().length > 0) {
            columnMetaData = this.mmd.getJoinMetaData().getColumnMetaData();
        } else if (relatedMmds != null && relatedMmds[0].getElementMetaData() != null && relatedMmds[0].getElementMetaData().getColumnMetaData() != null && relatedMmds[0].getElementMetaData().getColumnMetaData().length > 0) {
            columnMetaData = relatedMmds[0].getElementMetaData().getColumnMetaData();
        }
        this.ownerMapping = ColumnCreator.createColumnsForJoinTables((Class)clr.classForName(this.ownerType), (AbstractMemberMetaData)this.mmd, (ColumnMetaData[])columnMetaData, (MappedStoreManager)this.storeMgr, (DatastoreContainerObject)this, (boolean)pkRequired, (boolean)false, (int)1, (ClassLoaderResolver)clr);
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            this.debugMapping(this.ownerMapping);
        }
        if (this.mmd.hasExtension("relation-discriminator-column") || this.mmd.hasExtension("relation-discriminator-value")) {
            String colName = this.mmd.getValueForExtension("relation-discriminator-column");
            if (colName == null) {
                colName = "RELATION_DISCRIM";
            }
            ColumnMetaData colmd = new ColumnMetaData();
            colmd.setName(colName);
            boolean relationDiscriminatorPk = false;
            if (this.mmd.hasExtension("relation-discriminator-pk") && this.mmd.getValueForExtension("relation-discriminator-pk").equalsIgnoreCase("true")) {
                relationDiscriminatorPk = true;
            }
            if (!relationDiscriminatorPk) {
                colmd.setAllowsNull(Boolean.TRUE);
            }
            this.relationDiscriminatorMapping = this.storeMgr.getMappingManager().getMapping(String.class);
            ColumnCreator.createIndexColumn((JavaTypeMapping)this.relationDiscriminatorMapping, (MappedStoreManager)this.storeMgr, (ClassLoaderResolver)clr, (DatastoreContainerObject)this, (ColumnMetaData)colmd, (boolean)relationDiscriminatorPk);
            this.relationDiscriminatorValue = this.mmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = this.mmd.getFullFieldName();
            }
        }
    }

    public abstract String getElementType();

    protected void applyUserPrimaryKeySpecification(PrimaryKeyMetaData pkmd) {
        ColumnMetaData[] pkCols = pkmd.getColumnMetaData();
        for (int i = 0; i < pkCols.length; ++i) {
            int j;
            String colName = pkCols[i].getName();
            boolean found = false;
            for (j = 0; j < this.ownerMapping.getNumberOfDatastoreMappings(); ++j) {
                if (!this.ownerMapping.getDatastoreMapping(j).getDatastoreField().getIdentifier().getIdentifierName().equals(colName)) continue;
                this.ownerMapping.getDatastoreMapping(j).getDatastoreField().setAsPrimaryKey();
                found = true;
            }
            if (!found) {
                for (j = 0; j < this.elementMapping.getNumberOfDatastoreMappings(); ++j) {
                    if (!this.elementMapping.getDatastoreMapping(j).getDatastoreField().getIdentifier().getIdentifierName().equals(colName)) continue;
                    this.elementMapping.getDatastoreMapping(j).getDatastoreField().setAsPrimaryKey();
                    found = true;
                }
            }
            if (found) continue;
            throw new NucleusUserException(LOCALISER.msg("057040", (Object)this.toString(), (Object)colName));
        }
    }

    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        return null;
    }

    public JavaTypeMapping getElementMapping() {
        this.assertIsInitialized();
        return this.elementMapping;
    }

    public JavaTypeMapping getOrderMapping() {
        this.assertIsInitialized();
        return this.orderMapping;
    }

    public JavaTypeMapping getRelationDiscriminatorMapping() {
        this.assertIsInitialized();
        return this.relationDiscriminatorMapping;
    }

    public String getRelationDiscriminatorValue() {
        this.assertIsInitialized();
        return this.relationDiscriminatorValue;
    }

    protected ForeignKey getForeignKeyToOwner(DatastoreClass ownerTable, boolean autoMode) {
        ForeignKey fk = null;
        if (ownerTable != null) {
            ForeignKeyMetaData fkmd = null;
            if (this.mmd.getJoinMetaData() != null) {
                fkmd = this.mmd.getJoinMetaData().getForeignKeyMetaData();
            }
            if (fkmd != null || autoMode) {
                fk = new ForeignKey(this.ownerMapping, this.dba, ownerTable, true);
                fk.setForMetaData(fkmd);
            }
        }
        return fk;
    }

    protected ForeignKey getForeignKeyToElement(DatastoreClass elementTable, boolean autoMode, JavaTypeMapping m) {
        ForeignKey fk = null;
        if (elementTable != null) {
            ForeignKeyMetaData fkmd = this.mmd.getForeignKeyMetaData();
            if (fkmd == null && this.mmd.getElementMetaData() != null) {
                fkmd = this.mmd.getElementMetaData().getForeignKeyMetaData();
            }
            if (fkmd != null || autoMode) {
                fk = new ForeignKey(m, this.dba, elementTable, true);
                fk.setForMetaData(fkmd);
            }
        }
        return fk;
    }

    protected List getExpectedForeignKeys(ClassLoaderResolver clr) {
        this.assertIsInitialized();
        boolean autoMode = false;
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.constraintCreateMode").equals("DataNucleus")) {
            autoMode = true;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        try {
            ForeignKey fk;
            DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(this.ownerType, clr);
            if (referencedTable != null && (fk = this.getForeignKeyToOwner(referencedTable, autoMode)) != null) {
                foreignKeys.add(fk);
            }
            if (!(this.elementMapping instanceof SerialisedPCMapping)) {
                if (this.elementMapping instanceof EmbeddedElementPCMapping) {
                    EmbeddedElementPCMapping embMapping = (EmbeddedElementPCMapping)this.elementMapping;
                    for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                        ForeignKey fk2;
                        JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                        AbstractMemberMetaData embFmd = embFieldMapping.getMemberMetaData();
                        if (ClassUtils.isReferenceType((Class)embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                            Collection fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                            foreignKeys.addAll(fks);
                            continue;
                        }
                        if (this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreMappings() <= 0 || !(embFieldMapping instanceof PersistableMapping) || (fk2 = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
                        foreignKeys.add(fk2);
                    }
                } else if (this.elementMapping instanceof ReferenceMapping) {
                    JavaTypeMapping[] implJavaTypeMappings = ((ReferenceMapping)this.elementMapping).getJavaTypeMapping();
                    for (int i = 0; i < implJavaTypeMappings.length; ++i) {
                        ForeignKey fk3;
                        JavaTypeMapping implMapping = implJavaTypeMappings[i];
                        if (this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(implMapping.getType(), clr) == null || implMapping.getNumberOfDatastoreMappings() <= 0 || (referencedTable = this.storeMgr.getDatastoreClass(implMapping.getType(), clr)) == null || (fk3 = this.getForeignKeyToElement(referencedTable, autoMode, implMapping)) == null) continue;
                        foreignKeys.add(fk3);
                    }
                } else {
                    referencedTable = this.storeMgr.getDatastoreClass(this.getElementType(), clr);
                    if (referencedTable != null && (fk = this.getForeignKeyToElement(referencedTable, autoMode, this.elementMapping)) != null) {
                        foreignKeys.add(fk);
                    }
                }
            }
        }
        catch (NoTableManagedException e) {
            // empty catch block
        }
        return foreignKeys;
    }

    protected Set getExpectedIndices(ClassLoaderResolver clr) {
        Set indices = super.getExpectedIndices(clr);
        if (this.elementMapping instanceof EmbeddedElementPCMapping) {
            EmbeddedElementPCMapping embMapping = (EmbeddedElementPCMapping)this.elementMapping;
            for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                Index index;
                JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                IndexMetaData imd = embFieldMapping.getMemberMetaData().getIndexMetaData();
                if (imd == null || (index = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    protected List getExpectedCandidateKeys() {
        UniqueMetaData unimd;
        ColumnMetaData[] colmds;
        List candidateKeys = super.getExpectedCandidateKeys();
        if (this.elementMapping instanceof EmbeddedElementPCMapping) {
            EmbeddedElementPCMapping embMapping = (EmbeddedElementPCMapping)this.elementMapping;
            for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                CandidateKey ck;
                JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                UniqueMetaData umd = embFieldMapping.getMemberMetaData().getUniqueMetaData();
                if (umd == null || (ck = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                candidateKeys.add(ck);
            }
        }
        if (this.mmd.getJoinMetaData() != null && this.mmd.getJoinMetaData().getUniqueMetaData() != null && (colmds = (unimd = this.mmd.getJoinMetaData().getUniqueMetaData()).getColumnMetaData()) != null) {
            CandidateKey uniKey = new CandidateKey(this);
            IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
            for (int i = 0; i < colmds.length; ++i) {
                DatastoreField col = this.getDatastoreField(idFactory.newDatastoreFieldIdentifier(colmds[i].getName()));
                if (col == null) {
                    throw new NucleusUserException("Unique key on join-table " + this + " has column " + colmds[i].getName() + " that is not found");
                }
                uniKey.addDatastoreField(col);
            }
            candidateKeys.add(uniKey);
        }
        return candidateKeys;
    }
}

