/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Date;
import java.util.List;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class TemporalExpression
extends SQLExpression {
    public TemporalExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public TemporalExpression(JavaTypeMapping mapping, String functionName, List args) {
        super(mapping, functionName, args, null);
    }

    public TemporalExpression(JavaTypeMapping mapping, String functionName, List args, List types) {
        super(mapping, functionName, args, types);
    }

    public BooleanExpression eq(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof NullLiteral) {
            return expr.ne(this);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        return super.ne(expr);
    }

    public BooleanExpression lt(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression le(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        return super.le(expr);
    }

    public BooleanExpression gt(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression ge(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        return super.ge(expr);
    }

    public BooleanExpression in(SQLExpression expr) {
        return new BooleanExpression(this, Expression.OP_IN, expr);
    }

    public SQLExpression invoke(String methodName, List args) {
        return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, Date.class.getName(), methodName, this, args);
    }
}

