/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.rdbms.sql;

import org.datanucleus.store.mapped.DatastoreContainerObject;

/**
 * SQLTable namer that generates names like T0, T1, T2, etc.
 * T0 is the primary table of the statement.
 * Doesn't make any use of table-groups, just incrementing the number for each new table.
 */
public class SQLTableTNamer implements SQLTableNamer
{
    /* (non-Javadoc)
     * @see org.datanucleus.store.rdbms.sql.SQLTableNamer#getAliasForTable(org.datanucleus.store.rdbms.sql.SQLStatement, org.datanucleus.store.mapped.DatastoreContainerObject)
     */
    public String getAliasForTable(SQLStatement stmt, DatastoreContainerObject table, String groupName)
    {
        if (stmt.getPrimaryTable() == null)
        {
            if (stmt.parent != null)
            {
                return "T0_SUB";
            }
            else
            {
                return "T0";
            }
        }
        else
        {
            if (stmt.parent != null)
            {
                return "T" + (stmt.getNumberOfTables() < 0 ? "1" : (stmt.getNumberOfTables()+1) + "_SUB");
            }
            else
            {
                return "T" + (stmt.getNumberOfTables() < 0 ? "1" : (stmt.getNumberOfTables()+1));
            }
        }
    }
}