/**********************************************************************
Copyright (c) 2003 Mike Martin and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
2003 Andy Jefferson - coding standards
2004 Andy Jefferson - split out AbstractRDBMSExtent
    ...
**********************************************************************/
package org.datanucleus.store.rdbms.query.legacy;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.exceptions.IncompatibleQueryElementTypeException;
import org.datanucleus.store.mapped.expression.ExpressionHelper;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.util.Localiser;

/**
 * An Extent of all persistent objects backed by a view.
 * @deprecated
 */
public class ClassViewExtent extends AbstractRDBMSExtent implements Queryable
{
    /** Localised messages */
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance(
        "org.datanucleus.store.rdbms.Localisation", RDBMSStoreManager.class.getClassLoader());

    private final DatastoreClass view;

    private final int fieldCount;
    private final int[] prefetchFieldNumbers;
	private final StatementMappingIndex[] stmtMappings;

    /**
     * Constructor.
     * @param om Persistence Manager
     * @param view The view
     * @param cls Candidate class
     * @param subclasses Whether to include subclasses
     * @param cmd MetaData for the candidate class
     */
    public ClassViewExtent(ObjectManager om, DatastoreClass view, Class cls, boolean subclasses, 
            AbstractClassMetaData cmd)
    {
        super(om, cls, subclasses, cmd);

        this.view = view;

        // Set up list of fields required for the candidate class
        fieldCount = cmd.getNoOfManagedMembers();
        int[] fn = new int[fieldCount];
		stmtMappings = new StatementMappingIndex[fieldCount];
        int prefetchFieldCount = 0;

        for (int i=0; i<fieldCount; ++i)
        {
            JavaTypeMapping m = view.getMemberMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(i));
            if (m != null)
            {
                if (!m.includeInFetchStatement() || m instanceof AbstractContainerMapping)
                {
                    throw new NucleusException(LOCALISER_RDBMS.msg("053001", 
                        m, candidateClass.getName())).setFatal();
                }
                
				stmtMappings[i] = new StatementMappingIndex(m);
                fn[prefetchFieldCount++] = i;
            }
        }

        if (prefetchFieldCount == 0)
        {
            throw new NucleusUserException(LOCALISER_RDBMS.msg("053000", candidateClass.getName())).setFatal();
        }

        prefetchFieldNumbers = new int[prefetchFieldCount];
        System.arraycopy(fn, 0, prefetchFieldNumbers, 0, prefetchFieldCount);
    }

    /**
     * Create a new query to search for the candidate classes etc.
     * @return The new QueryStatement.
     */
    public QueryExpression newQueryStatement()
    {
        return ((MappedStoreManager)storeMgr).getDatastoreAdapter().newQueryStatement(view, null, 
            om.getClassLoaderResolver());
    }

    /**
     * Create a query to search for the candidateClass and subclasses if true
     * @param candidateClass The class to use
     * @param candidateAlias Alias for the candidate
     * @return The new QueryStatement
     */
    public QueryExpression newQueryStatement(Class candidateClass, DatastoreIdentifier candidateAlias)
    {
        String extentType = view.getType();
        if (!extentType.equals(candidateClass.getName()))
        {
            throw new IncompatibleQueryElementTypeException(extentType, candidateClass.getName());
        }

        return ((MappedStoreManager)storeMgr).getDatastoreAdapter().newQueryStatement(view, null,
            om.getClassLoaderResolver());
    }

    /**
     * Create a new factory for objects from the ResultSet.
     * @param stmt The Query Statement
     * @param ignoreCache Whether to ignore dirty objects
     * @param resultClass Whether to create objects of a particular class
     * @param useFetchPlan whether to use the fetch plan to retrieve fields in the same query
     * @return The result object factory
     */
    public ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, 
            Class resultClass, boolean useFetchPlan)
    {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        for (int i = 0; i < stmtMappings.length; ++i)
        {
            ExpressionHelper.selectMapping(stmtMappings[i], stmt, null, clr);
        }

        return new TransientIDROF(getCandidateClass(), prefetchFieldNumbers, stmtMappings);
    }

    /**
     * Returns <tt>true</tt> if this collection contains no elements.<p>
     * @return <tt>true</tt> if this collection contains no elements.
     */
    public boolean isEmpty()
    {
        // we don't know if we are empty until it calls the datastore
        return false;
    }
}