/**********************************************************************
Copyright (c) 2006 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 


Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.rdbms.mapping.oracle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

import org.datanucleus.StateManager;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;

/**
 * Mapping for a serialised PersistenceCapable object for Oracle.
 */
public class OracleSerialisedPCMapping extends SerialisedPCMapping implements MappingCallbacks
{
    /**
     * @see org.datanucleus.store.mapped.mapping.MappingCallbacks#postFetch(org.datanucleus.StateManager)
     */
    public void postFetch(StateManager sm)
    {
    }

    /**
     * Retrieve the empty BLOB created by the insert statement and write out the
     * current BLOB field value to the Oracle BLOB object
     * @param ownerSM the current StateManager
     */
    public void postInsert(StateManager ownerSM)
    {
        Object value = ownerSM.provideField(mmd.getAbsoluteFieldNumber());
        StateManager sm = null;
        if (value != null)
        {
            sm = ownerSM.getObjectManager().findStateManager(value);
            if (sm == null || sm.getObjectManager().getApiAdapter().getPersistenceManager(value) == null)
            {
                // Assign a StateManager to the serialised object since none present
                sm = StateManagerFactory.newStateManagerForEmbedded(ownerSM.getObjectManager(), value, false);
                sm.addEmbeddedOwner(ownerSM, mmd.getAbsoluteFieldNumber());
            }
        }

        if (sm != null)
        {
            sm.setStoringPC();
        }

        // Generate the contents for the BLOB
        byte[] bytes = new byte[0];
        if (value != null)
        {
            try
            {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(value);
                bytes = baos.toByteArray();
            }
            catch (IOException e1)
            {
                // Do Nothing
            }
        }

        // Update the BLOB
        OracleBlobRDBMSMapping.updateBlobColumn(ownerSM, getDatastoreContainer(), getDatastoreMapping(0), bytes);

        if (sm != null)
        {
            sm.unsetStoringPC();
        }
    }

    /**
     * @see org.datanucleus.store.mapped.mapping.MappingCallbacks#postUpdate(org.datanucleus.StateManager)
     */
    public void postUpdate(StateManager sm)
    {
        postInsert(sm);
    }

    /**
     * @see org.datanucleus.store.mapped.mapping.MappingCallbacks#preDelete(org.datanucleus.StateManager)
     */
    public void preDelete(StateManager sm)
    {
    }
}