/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreData;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSStoreHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameForIdKeyUsingUnion(ObjectManager om, Object id, List schemaDataOptions) {
        if (schemaDataOptions == null || id == null || schemaDataOptions.size() == 0) {
            return null;
        }
        int metadata_id_len = 0;
        for (RDBMSStoreData schemaDataOption : schemaDataOptions) {
            metadata_id_len = Math.max(schemaDataOption.getName().length(), metadata_id_len);
        }
        String className = null;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)om.getStoreManager();
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        SQLStatement sqlStmtMain = null;
        Iterator optionsIter = schemaDataOptions.iterator();
        String baseClassName = null;
        while (optionsIter.hasNext()) {
            RDBMSStoreData schemaDataOption = (RDBMSStoreData)((Object)optionsIter.next());
            ClassMetaData cmd = (ClassMetaData)schemaDataOption.getMetaData();
            if (baseClassName == null) {
                baseClassName = cmd.getFullClassName();
            }
            DatastoreContainerObject table = schemaDataOption.getDatastoreContainerObject();
            SQLStatement sqlStmt = new SQLStatement(storeMgr, table, null, null);
            JavaTypeMapping typeMapping = storeMgr.getMappingManager().getMapping(String.class);
            String classname = StringUtils.leftAlignedPaddedString((String)schemaDataOption.getName(), (int)metadata_id_len);
            sqlStmt.select(exprFactory.newLiteral(sqlStmt, typeMapping, classname), "NUCLEUS_TYPE");
            for (String subclass : storeMgr.getSubClassesForClass(schemaDataOption.getName(), false, clr)) {
                DatastoreClass subclassTable = storeMgr.getDatastoreClass(subclass, clr);
                if (subclassTable == null || subclassTable.getIdentifier().equals(sqlStmt.getPrimaryTable().getTable().getIdentifier())) continue;
                SQLTable subSqlTbl = sqlStmt.leftOuterJoin(sqlStmt.getPrimaryTable(), sqlStmt.getPrimaryTable().getTable().getIDMapping(), (DatastoreContainerObject)subclassTable, null, subclassTable.getIDMapping(), null, sqlStmt.getPrimaryTable().getGroupName());
                SQLExpression subIdExpr = exprFactory.newExpression(sqlStmt, subSqlTbl, subclassTable.getIDMapping());
                SQLExpression nullExpr = exprFactory.newLiteral(sqlStmt, null, null);
                sqlStmt.whereAnd(subIdExpr.eq(nullExpr), true);
            }
            JavaTypeMapping idMapping = sqlStmt.getPrimaryTable().getTable().getIDMapping();
            Class pc_class = clr.classForName(schemaDataOption.getName());
            StateManager sm = StateManagerFactory.newStateManagerForHollow((ObjectManager)om, (Class)pc_class, (Object)id);
            SQLExpression fieldExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), idMapping);
            SQLExpression fieldVal = exprFactory.newLiteral(sqlStmt, idMapping, sm.getObject());
            sqlStmt.whereAnd(fieldExpr.eq(fieldVal), true);
            JavaTypeMapping discrimMapping = table.getDiscriminatorMapping(false);
            if (discrimMapping != null) {
                DiscriminatorMetaData discrimMetaData = cmd.getInheritanceMetaData().getDiscriminatorMetaData();
                String value = null;
                if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                    value = schemaDataOption.getName();
                } else if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                    value = discrimMetaData.getValue();
                }
                SQLExpression discrimExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), discrimMapping);
                SQLExpression discrimVal = exprFactory.newLiteral(sqlStmt, discrimMapping, value);
                sqlStmt.whereAnd(discrimExpr.eq(discrimVal), false);
            }
            if (sqlStmtMain == null) {
                sqlStmtMain = sqlStmt;
                continue;
            }
            sqlStmtMain.union(sqlStmt);
        }
        try {
            ManagedConnection mconn = storeMgr.getConnection(om);
            SQLController sqlControl = storeMgr.getSQLController();
            if (om.getSerializeReadForClass(baseClassName)) {
                sqlStmtMain.addExtension("lock-for-update", true);
            }
            try {
                PreparedStatement ps = SQLStatementHelper.getPreparedStatementForSQLStatement(sqlStmtMain, om, mconn, null, null);
                String statement = sqlStmtMain.getSelectStatement().toSQL();
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                    try {
                        if (rs != null) {
                            while (rs.next()) {
                                try {
                                    className = rs.getString("NUCLEUS_TYPE").trim();
                                }
                                catch (SQLException sqle) {}
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException sqe) {
            NucleusLogger.DATASTORE.error((Object)sqe);
            throw new NucleusDataStoreException(sqe.toString());
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameForIdKeyUsingDiscriminator(ObjectManager om, Object id, List schemaDataOptions) {
        Class primaryClass;
        if (schemaDataOptions == null || schemaDataOptions.size() == 0 || id == null) {
            return null;
        }
        String className = null;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)om.getStoreManager();
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class objectClass = primaryClass = clr.classForName(((RDBMSStoreData)((Object)schemaDataOptions.get(0))).getName());
        if (Modifier.isAbstract(primaryClass.getModifiers())) {
            for (RDBMSStoreData data : schemaDataOptions) {
                Class dataClass = clr.classForName(data.getName());
                if (Modifier.isAbstract(dataClass.getModifiers())) continue;
                objectClass = dataClass;
                break;
            }
        }
        if (Modifier.isAbstract(objectClass.getModifiers())) {
            throw new NucleusException("Class " + objectClass.getName() + " is abstract, and a non abstract was expected.").setFatal();
        }
        DatastoreClass primaryTable = storeMgr.getDatastoreClass(primaryClass.getName(), clr);
        StoreData[] storeData = storeMgr.getStoreDataForDatastoreContainerObject(primaryTable.getIdentifier());
        boolean haveAllCandidates = true;
        for (int i = 0; i < storeData.length; ++i) {
            if (!(storeData[i] instanceof MappedStoreData)) continue;
            ClassTable tbl = (ClassTable)((MappedStoreData)storeData[i]).getDatastoreContainerObject();
            String[] managedClasses = tbl.getManagedClasses();
            for (int j = 0; j < managedClasses.length; ++j) {
                boolean managedClassFound = false;
                for (StoreData optionData : schemaDataOptions) {
                    if (!optionData.getName().equals(managedClasses[j])) continue;
                    managedClassFound = true;
                    break;
                }
                if (managedClassFound) continue;
                haveAllCandidates = false;
                break;
            }
            if (!haveAllCandidates) break;
        }
        DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(storeMgr, primaryClass, true, null, null);
        if (haveAllCandidates) {
            stmtGen.unsetOption("restrictDiscriminator");
        } else {
            stmtGen.setOption("restrictDiscriminator");
        }
        SQLStatement sqlStmt = stmtGen.getStatement();
        sqlStmt.select(sqlStmt.getPrimaryTable(), primaryTable.getDiscriminatorMapping(true), null);
        StateManager sm = StateManagerFactory.newStateManagerForHollow((ObjectManager)om, (Class)objectClass, (Object)id);
        JavaTypeMapping idMapping = primaryTable.getIDMapping();
        SQLExpression sqlFldExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), idMapping);
        SQLExpression sqlFldVal = exprFactory.newLiteral(sqlStmt, idMapping, sm.getObject());
        sqlStmt.whereAnd(sqlFldExpr.eq(sqlFldVal), true);
        try {
            ManagedConnection mconn = storeMgr.getConnection(om);
            SQLController sqlControl = storeMgr.getSQLController();
            if (om.getSerializeReadForClass(primaryClass.getName())) {
                sqlStmt.addExtension("lock-for-update", true);
            }
            try {
                PreparedStatement ps = SQLStatementHelper.getPreparedStatementForSQLStatement(sqlStmt, om, mconn, null, null);
                String statement = sqlStmt.getSelectStatement().toSQL();
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                    try {
                        if (rs != null) {
                            while (rs.next()) {
                                JavaTypeMapping discrimMapping = primaryTable.getDiscriminatorMapping(true);
                                DiscriminatorMetaData dismd = discrimMapping.getDatastoreContainer().getDiscriminatorMetaData();
                                className = RDBMSQueryUtils.getClassNameFromDiscriminatorResultSetRow(discrimMapping, dismd, rs, om);
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException sqe) {
            NucleusLogger.DATASTORE.error((Object)sqe);
            throw new NucleusDataStoreException(sqe.toString());
        }
        return className;
    }
}

