/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigInteger;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class ByteLiteral
extends NumericExpression
implements SQLLiteral {
    private final BigInteger value;

    public ByteLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.parameterName = parameterName;
        if (value == null) {
            this.value = null;
        } else if (value instanceof BigInteger) {
            this.value = (BigInteger)value;
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        if (parameterName != null) {
            this.st.appendParameter(parameterName, mapping, this.value);
        } else {
            this.setStatement();
        }
    }

    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((ByteLiteral)expr).value) == 0, null);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((ByteLiteral)expr).value) != 0, null);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        return super.ne(expr);
    }

    public BooleanExpression lt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof ByteLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((ByteLiteral)expr).value) < 0, null);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression le(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((ByteLiteral)expr).value) <= 0, null);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        return super.le(expr);
    }

    public BooleanExpression gt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof ByteLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((ByteLiteral)expr).value) > 0, null);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression ge(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((ByteLiteral)expr).value) >= 0, null);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        return super.ge(expr);
    }

    public SQLExpression add(SQLExpression expr) {
        if (expr instanceof ByteLiteral) {
            return new ByteLiteral(this.stmt, this.mapping, this.value.add(((ByteLiteral)expr).value), null);
        }
        return super.add(expr);
    }

    public SQLExpression sub(SQLExpression expr) {
        if (expr instanceof ByteLiteral) {
            return new ByteLiteral(this.stmt, this.mapping, this.value.subtract(((ByteLiteral)expr).value), null);
        }
        return super.sub(expr);
    }

    public SQLExpression mul(SQLExpression expr) {
        if (expr instanceof ByteLiteral) {
            return new ByteLiteral(this.stmt, this.mapping, this.value.multiply(((ByteLiteral)expr).value), null);
        }
        return super.mul(expr);
    }

    public SQLExpression div(SQLExpression expr) {
        if (expr instanceof ByteLiteral) {
            return new ByteLiteral(this.stmt, this.mapping, this.value.divide(((ByteLiteral)expr).value), null);
        }
        return super.div(expr);
    }

    public SQLExpression mod(SQLExpression expr) {
        if (expr instanceof ByteLiteral) {
            return new ByteLiteral(this.stmt, this.mapping, this.value.mod(((ByteLiteral)expr).value), null);
        }
        return super.mod(expr);
    }

    public SQLExpression neg() {
        return new ByteLiteral(this.stmt, this.mapping, this.value.negate(), null);
    }

    public Object getValue() {
        return this.value;
    }

    public void setNotParameter() {
        if (this.parameterName == null) {
            return;
        }
        this.parameterName = null;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        this.st.append(String.valueOf(this.value));
    }
}

