/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.AbstractClassTable;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FetchRequest
extends Request {
    private String statementUnlocked;
    private String statementLocked;
    private int[] memberNumbersToFetch = null;
    private StatementClassMapping mappingDefinition;
    private final MappingCallbacks[] callbacks;
    private int numberOfFieldsToFetch = 0;
    private final String fieldsToFetch;
    private boolean fetchingSurrogateVersion = false;
    private String versionFieldName = null;

    public FetchRequest(DatastoreClass classTable, AbstractMemberMetaData[] mmds, Class cls, ClassLoaderResolver clr) {
        super(classTable);
        DatastoreClass candidateTable;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)classTable.getStoreManager();
        boolean found = false;
        for (candidateTable = classTable; candidateTable != null; candidateTable = candidateTable.getSuperDatastoreClass()) {
            for (int i = 0; i < mmds.length; ++i) {
                JavaTypeMapping m = candidateTable.getMemberMappingInDatastoreClass(mmds[i]);
                if (m == null) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (candidateTable == null) {
            candidateTable = classTable;
        }
        this.table = candidateTable;
        this.key = ((AbstractClassTable)this.table).getPrimaryKey();
        AbstractClassMetaData cmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(cls, clr);
        for (DatastoreClass currentTable = this.table; currentTable != null; currentTable = currentTable.getSuperDatastoreClass()) {
            VersionMetaData currentVermd = currentTable.getVersionMetaData();
            if (currentVermd == null) continue;
            if (currentVermd.getFieldName() == null) {
                this.fetchingSurrogateVersion = true;
                continue;
            }
            this.versionFieldName = currentVermd.getFieldName();
        }
        SQLStatement sqlStatement = new SQLStatement(storeMgr, (DatastoreContainerObject)this.table, null, null);
        this.mappingDefinition = new StatementClassMapping();
        HashSet fetchCallbacks = new HashSet();
        this.numberOfFieldsToFetch = this.processMembersOfClass(sqlStatement, cls, mmds, this.table, sqlStatement.getPrimaryTable(), this.mappingDefinition, fetchCallbacks, clr);
        this.callbacks = fetchCallbacks.toArray(new MappingCallbacks[fetchCallbacks.size()]);
        this.memberNumbersToFetch = this.mappingDefinition.getMemberNumbers();
        int inputParamNum = 1;
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            JavaTypeMapping datastoreIdMapping = this.table.getDataStoreObjectIdMapping();
            SQLExpression expr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), datastoreIdMapping);
            SQLExpression val = exprFactory.newLiteralParameter(sqlStatement, datastoreIdMapping, null, "ID");
            sqlStatement.whereAnd(expr.eq(val), true);
            StatementMappingIndex datastoreIdx = this.mappingDefinition.getMappingForMemberPosition(StatementClassMapping.MEMBER_DATASTORE_ID);
            if (datastoreIdx == null) {
                datastoreIdx = new StatementMappingIndex(datastoreIdMapping);
                this.mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_DATASTORE_ID, datastoreIdx);
            }
            datastoreIdx.addParameterOccurrence(new int[]{inputParamNum});
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNums = cmd.getPKMemberPositions();
            for (int i = 0; i < pkNums.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[i]);
                JavaTypeMapping pkMapping = this.table.getMemberMapping(mmd);
                SQLExpression expr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), pkMapping);
                SQLExpression val = exprFactory.newLiteralParameter(sqlStatement, pkMapping, null, "PK" + i);
                sqlStatement.whereAnd(expr.eq(val), true);
                StatementMappingIndex pkIdx = this.mappingDefinition.getMappingForMemberPosition(pkNums[i]);
                if (pkIdx == null) {
                    pkIdx = new StatementMappingIndex(pkMapping);
                    this.mappingDefinition.addMappingForMember(pkNums[i], pkIdx);
                }
                int[] inputParams = new int[pkMapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < pkMapping.getNumberOfDatastoreFields(); ++j) {
                    inputParams[j] = inputParamNum++;
                }
                pkIdx.addParameterOccurrence(inputParams);
            }
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < mmds.length; ++i) {
            if (mmds[i].isPrimaryKey()) continue;
            if (str.length() > 0) {
                str.append(',');
            }
            str.append(mmds[i].getName());
        }
        if (this.fetchingSurrogateVersion) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("[VERSION]");
        }
        if (!this.fetchingSurrogateVersion && this.numberOfFieldsToFetch == 0) {
            this.fieldsToFetch = null;
            sqlStatement = null;
            this.mappingDefinition = null;
        } else {
            this.fieldsToFetch = str.toString();
            this.statementUnlocked = sqlStatement.getSelectStatement().toSQL();
            sqlStatement.addExtension("lock-for-update", Boolean.TRUE);
            this.statementLocked = sqlStatement.getSelectStatement().toSQL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (this.fieldsToFetch != null && NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("052218", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.fieldsToFetch, (Object)this.table));
        }
        if (!(this.isFetchingVersionOnly() && this.isVersionLoaded(sm) || this.statementLocked == null)) {
            ObjectManager om = sm.getObjectManager();
            RDBMSStoreManager storeMgr = (RDBMSStoreManager)om.getStoreManager();
            boolean locked = om.getSerializeReadForClass(sm.getClassMetaData().getFullClassName());
            String statement = locked ? this.statementLocked : this.statementUnlocked;
            StatementClassMapping mappingDef = this.mappingDefinition;
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForQuery(mconn, statement);
                    AbstractClassMetaData cmd = sm.getClassMetaData();
                    try {
                        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                            StatementMappingIndex datastoreIdx = mappingDef.getMappingForMemberPosition(StatementClassMapping.MEMBER_DATASTORE_ID);
                            for (int i = 0; i < datastoreIdx.getNumberOfParameterOccurrences(); ++i) {
                                this.table.getDataStoreObjectIdMapping().setObject(om, (Object)ps, datastoreIdx.getParameterPositionsForOccurrence(i), sm.getInternalObjectId());
                            }
                        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                            sm.provideFields(cmd.getPKMemberPositions(), storeMgr.getFieldManagerForStatementGeneration(sm, ps, mappingDef, false));
                        }
                        ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                        try {
                            if (!rs.next()) {
                                if (NucleusLogger.DATASTORE_RETRIEVE.isInfoEnabled()) {
                                    NucleusLogger.DATASTORE_RETRIEVE.info((Object)LOCALISER.msg("050018", sm.getInternalObjectId()));
                                }
                                throw new NucleusObjectNotFoundException("No such database row", sm.getInternalObjectId());
                            }
                            sm.replaceFields(this.memberNumbersToFetch, storeMgr.getFieldManagerForResultProcessing(sm, rs, mappingDef));
                            if (sm.getTransactionalVersion(sm.getObject()) == null) {
                                Object datastoreVersion = null;
                                if (this.fetchingSurrogateVersion) {
                                    StatementMappingIndex verIdx = mappingDef.getMappingForMemberPosition(StatementClassMapping.MEMBER_VERSION);
                                    datastoreVersion = this.table.getVersionMapping(true).getObject(om, (Object)rs, verIdx.getColumnPositions());
                                } else if (this.versionFieldName != null) {
                                    datastoreVersion = sm.provideField(cmd.getAbsolutePositionOfMember(this.versionFieldName));
                                }
                                sm.setVersion(datastoreVersion);
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException sqle) {
                String msg = LOCALISER.msg("052219", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)statement, (Object)sqle.getMessage());
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)msg);
                ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
                exceptions.add(sqle);
                while ((sqle = sqle.getNextException()) != null) {
                    exceptions.add(sqle);
                }
                throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
            }
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            this.callbacks[i].postFetch(sm);
        }
    }

    private boolean isVersionLoaded(StateManager sm) {
        return sm.getObject() != null && sm.getObjectManager().getApiAdapter().getVersion(sm) != null;
    }

    private boolean isFetchingVersionOnly() {
        return (this.fetchingSurrogateVersion || this.versionFieldName != null) && this.numberOfFieldsToFetch == 0;
    }

    protected int processMembersOfClass(SQLStatement sqlStatement, Class cls, AbstractMemberMetaData[] mmds, DatastoreClass table, SQLTable sqlTbl, StatementClassMapping mappingDef, Collection fetchCallbacks, ClassLoaderResolver clr) {
        if (mmds == null || mmds.length == 0) {
            return 0;
        }
        int number = 0;
        for (int i = 0; i < mmds.length; ++i) {
            AbstractMemberMetaData mmd = mmds[i];
            JavaTypeMapping mapping = table.getMemberMapping(mmd);
            if (mapping == null) continue;
            if (!mmd.isPrimaryKey() && mapping.includeInFetchStatement()) {
                int depth = 0;
                if (mapping instanceof PersistableMapping) {
                    String[] subclasses;
                    DatastoreClass relTable;
                    depth = 1;
                    if (Modifier.isAbstract(mmd.getType().getModifiers()) && (relTable = table.getStoreManager().getDatastoreClass(mmd.getTypeName(), clr)) != null && relTable.getDiscriminatorMapping(false) == null && (subclasses = table.getStoreManager().getMetaDataManager().getSubclassesForClass(mmd.getTypeName(), false)) != null && subclasses.length > 0) {
                        depth = 0;
                    }
                }
                SQLStatementHelper.selectMemberOfSourceInStatement(sqlStatement, mappingDef, null, sqlTbl, mmd, clr, depth);
                ++number;
            }
            if (!(mapping instanceof MappingCallbacks)) continue;
            fetchCallbacks.add(mapping);
        }
        JavaTypeMapping verMapping = table.getVersionMapping(true);
        if (verMapping != null) {
            StatementMappingIndex verMapIdx = new StatementMappingIndex(verMapping);
            SQLTable verSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStatement, sqlTbl, verMapping);
            int[] cols = sqlStatement.select(verSqlTbl, verMapping, null);
            verMapIdx.setColumnPositions(cols);
            mappingDef.addMappingForMember(StatementClassMapping.MEMBER_VERSION, verMapIdx);
        }
        return number;
    }
}

