/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOUserException;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.query.AbstractQueryResultIterator;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public final class ForwardQueryResult
extends AbstractRDBMSQueryResult {
    protected boolean moreResultSetRows;
    protected List resultObjs = new ArrayList();
    protected List resultIds = null;
    private Collection candidates;

    public ForwardQueryResult(Query query, ResultObjectFactory rof, ResultSet rs, Collection candidates) throws SQLException {
        super(query, rof, rs);
        if (query.useResultsCaching()) {
            this.resultIds = new ArrayList();
        }
        if (candidates != null) {
            this.candidates = new ArrayList(candidates);
        }
        int fetchSize = query.getFetchPlan().getFetchSize();
        this.moreResultSetRows = rs.next();
        if (!this.moreResultSetRows) {
            this.closeResults();
        } else if (!query.getObjectManager().getTransaction().isActive() || fetchSize == -1) {
            this.advanceToEndOfResultSet();
        } else if (fetchSize > 0) {
            Iterator it = this.iterator();
            for (int i = 0; i < fetchSize; ++i) {
                if (!it.hasNext()) continue;
                it.next();
            }
        }
    }

    private void advanceToEndOfResultSet() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            it.next();
        }
    }

    protected Object nextResultSetElement() {
        if (this.rof == null) {
            return null;
        }
        ObjectManager om = this.query.getObjectManager();
        Object nextElement = this.rof.getObject(om, (Object)this.rs);
        JDBCUtils.logWarnings(this.rs);
        this.resultObjs.add(nextElement);
        if (this.resultIds != null) {
            this.resultIds.add(om.getApiAdapter().getIdForObject(nextElement));
        }
        try {
            this.moreResultSetRows = this.rs.next();
            if (!this.moreResultSetRows) {
                this.closeResults();
                if (this.resultIds != null) {
                    this.cacheQueryResults();
                    this.resultIds = null;
                }
            }
        }
        catch (SQLException e) {
            if (om.getOMFContext().getApi().equalsIgnoreCase("JDO")) {
                throw new JDODataStoreException(LOCALISER.msg("052601", (Object)e));
            }
            throw new NucleusDataStoreException(LOCALISER.msg("052601", (Object)e));
        }
        return nextElement;
    }

    protected void cacheQueryResults() {
        this.query.getQueryManager().addDatastoreQueryResult(this.query, this.query.getInputParameters(), this.resultIds);
    }

    public synchronized void close() {
        this.moreResultSetRows = false;
        this.resultObjs.clear();
        if (this.resultIds != null) {
            this.resultIds.clear();
        }
        super.close();
    }

    protected void closingConnection() {
        if (this.loadResultsAtCommit && this.isOpen() && this.moreResultSetRows) {
            NucleusLogger.QUERY.info((Object)LOCALISER.msg("052606", (Object)this.query.toString()));
            try {
                this.advanceToEndOfResultSet();
            }
            catch (NucleusUserException jpue) {
                NucleusLogger.QUERY.warn((Object)("Exception thrown while loading remaining rows of query : " + jpue.getMessage()));
            }
            catch (JDOUserException ue) {
                NucleusLogger.QUERY.warn((Object)("Exception thrown while loading remaining rows of query : " + ue.getMessage()));
            }
        }
    }

    public Iterator iterator() {
        return new QueryResultIterator();
    }

    public ListIterator listIterator() {
        return new QueryResultIterator();
    }

    public synchronized boolean contains(Object o) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.contains(o);
    }

    public synchronized boolean containsAll(Collection c) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.containsAll(c);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ForwardQueryResult)) {
            return false;
        }
        ForwardQueryResult other = (ForwardQueryResult)((Object)o);
        if (this.rs != null) {
            return other.rs == this.rs;
        }
        if (this.query != null) {
            return other.query == this.query;
        }
        return StringUtils.toJVMIDString((Object)((Object)other)).equals(StringUtils.toJVMIDString((Object)((Object)this)));
    }

    public synchronized Object get(int index) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.get(index);
    }

    public synchronized boolean isEmpty() {
        this.assertIsOpen();
        return this.resultObjs.isEmpty() && !this.moreResultSetRows;
    }

    protected int getSizeUsingMethod() {
        if (this.resultSizeMethod.equalsIgnoreCase("LAST")) {
            this.advanceToEndOfResultSet();
            return this.resultObjs.size();
        }
        if (this.resultSizeMethod.equalsIgnoreCase("COUNT") && this.query.getCompilation() == null) {
            return this.getSizeUsingCount();
        }
        return super.getSizeUsingMethod();
    }

    public synchronized Object[] toArray() {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.toArray(a);
    }

    private class QueryResultIterator
    extends AbstractQueryResultIterator {
        private int nextRowNum = 0;
        Object nextElement = null;

        private QueryResultIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            ForwardQueryResult forwardQueryResult = ForwardQueryResult.this;
            synchronized (forwardQueryResult) {
                if (!ForwardQueryResult.this.isOpen()) {
                    return false;
                }
                if (this.nextRowNum < ForwardQueryResult.this.resultObjs.size()) {
                    return true;
                }
                if (ForwardQueryResult.this.candidates != null && this.nextElement != null && !ForwardQueryResult.this.moreResultSetRows) {
                    return ForwardQueryResult.this.candidates.contains(this.nextElement);
                }
                return ForwardQueryResult.this.moreResultSetRows;
            }
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object next() {
            ForwardQueryResult forwardQueryResult = ForwardQueryResult.this;
            synchronized (forwardQueryResult) {
                if (!ForwardQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(LOCALISER.msg("052600"));
                }
                if (ForwardQueryResult.this.candidates != null && this.nextElement != null && ForwardQueryResult.this.candidates.remove(this.nextElement)) {
                    ForwardQueryResult.this.resultObjs.add(this.nextElement);
                    return this.nextElement;
                }
                if (this.nextRowNum < ForwardQueryResult.this.resultObjs.size()) {
                    this.nextElement = ForwardQueryResult.this.resultObjs.get(this.nextRowNum);
                    ++this.nextRowNum;
                    return this.nextElement;
                }
                if (ForwardQueryResult.this.moreResultSetRows) {
                    this.nextElement = ForwardQueryResult.this.nextResultSetElement();
                    ++this.nextRowNum;
                    if (ForwardQueryResult.this.candidates != null) {
                        ForwardQueryResult.this.candidates.remove(this.nextElement);
                    }
                    return this.nextElement;
                }
                throw new NoSuchElementException(LOCALISER.msg("052602"));
            }
        }

        public int nextIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object previous() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int previousIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }
}

