/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.CollectionExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionLiteral
extends CollectionExpression
implements SQLLiteral {
    private final Collection value;
    private List<SQLExpression> elementExpressions;

    public CollectionLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, boolean parameter) {
        super(stmt, null, mapping);
        this.isParameter = parameter;
        if (value == null) {
            this.value = null;
        } else if (this.isParameter) {
            this.value = value instanceof Collection ? (Collection)value : null;
            this.st.appendParameter(mapping, value);
        } else if (value instanceof Collection) {
            this.value = (Collection)value;
            this.setStatement();
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public List<SQLExpression> getElementExpressions() {
        return this.elementExpressions;
    }

    @Override
    public void setNotParameter() {
        if (!this.isParameter) {
            return;
        }
        this.isParameter = false;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        if (this.value != null && this.value.size() > 0) {
            RDBMSManager storeMgr = this.stmt.getRDBMSManager();
            this.elementExpressions = new ArrayList<SQLExpression>();
            this.st.append("(");
            boolean hadPrev = false;
            for (Object current : this.value) {
                if (current == null) continue;
                JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(current.getClass(), false);
                SQLExpression expr = storeMgr.getSQLExpressionFactory().newLiteral(this.stmt, m, current);
                this.st.append(hadPrev ? "," : "");
                this.st.append(expr);
                this.elementExpressions.add(expr);
                hadPrev = true;
            }
            this.st.append(")");
        }
    }
}

