/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.sco.simple.Map;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.MapLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.JoinTable;

public class MapSizeMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args != null && args.size() > 0) {
            throw new NucleusException(LOCALISER.msg("060015", (Object)"size", (Object)"MapExpression"));
        }
        if (expr instanceof MapLiteral) {
            Map map = (Map)((MapLiteral)expr).getValue();
            return this.exprFactory.newLiteral(this.stmt, this.exprFactory.getMappingForType(Integer.TYPE, false), new Integer(map.size()));
        }
        AbstractMemberMetaData ownerMmd = expr.getJavaTypeMapping().getMemberMetaData();
        RDBMSManager storeMgr = this.stmt.getRDBMSManager();
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        JavaTypeMapping ownerMapping = null;
        DatastoreContainerObject mapTbl = null;
        if (ownerMmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            mapTbl = storeMgr.getDatastoreContainerObject(ownerMmd);
            ownerMapping = ((JoinTable)mapTbl).getOwnerMapping();
        } else if (ownerMmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            AbstractClassMetaData valueCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(ownerMmd.getMap().getValueType(), clr);
            mapTbl = storeMgr.getDatastoreClass(ownerMmd.getMap().getValueType(), clr);
            ownerMapping = ownerMmd.getMappedBy() != null ? mapTbl.getMemberMapping(valueCmd.getMetaDataForMember(ownerMmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(ownerMmd, 5);
        } else if (ownerMmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(ownerMmd.getMap().getKeyType(), clr);
            mapTbl = storeMgr.getDatastoreClass(ownerMmd.getMap().getKeyType(), clr);
            ownerMapping = ownerMmd.getMappedBy() != null ? mapTbl.getMemberMapping(keyCmd.getMetaDataForMember(ownerMmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(ownerMmd, 5);
        } else {
            throw new NucleusException("Invalid map for " + expr + " in size() call");
        }
        SQLStatement subStmt = new SQLStatement(this.stmt, storeMgr, mapTbl, null, null);
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithDatastoreMapping(String.class, false, false, clr);
        SQLExpression countExpr = this.exprFactory.newLiteral(subStmt, mapping, "COUNT(*)");
        ((StringLiteral)countExpr).generateStatementWithoutQuotes();
        subStmt.select(countExpr, null);
        SQLExpression elementOwnerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, expr.getSQLTable(), expr.getSQLTable().getTable().getIDMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        return new NumericSubqueryExpression(this.stmt, subStmt);
    }
}

