/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class StringStartsWithMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args == null || args.size() == 0 || args.size() > 2) {
            throw new NucleusException(LOCALISER.msg("060003", (Object)"startsWith", (Object)"StringExpression", (Object)0, (Object)"StringExpression/CharacterExpression/Parameter"));
        }
        SQLExpression substrExpr = (SQLExpression)args.get(0);
        if (!(substrExpr instanceof StringExpression || substrExpr instanceof CharacterExpression || substrExpr instanceof ParameterLiteral)) {
            throw new NucleusException(LOCALISER.msg("060003", (Object)"startsWith", (Object)"StringExpression", (Object)0, (Object)"StringExpression/CharacterExpression/Parameter"));
        }
        if (args.size() > 1) {
            StringLiteral likeSubstrExpr = new StringLiteral(expr.getSQLStatement(), expr.getJavaTypeMapping(), Character.valueOf('%'));
            return new BooleanExpression(expr, Expression.OP_LIKE, ExpressionUtils.getEscapedPatternExpression(substrExpr).add(likeSubstrExpr));
        }
        StringLiteral likeSubstrExpr = new StringLiteral(expr.getSQLStatement(), expr.getJavaTypeMapping(), Character.valueOf('%'));
        return new BooleanExpression(expr, Expression.OP_LIKE, ExpressionUtils.getEscapedPatternExpression(substrExpr).add(likeSubstrExpr));
    }
}

