/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.util.RegularExpressionConverter;

public class StringMatchesMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args == null || args.size() != 1) {
            throw new NucleusException("Incorrect arguments for String.matches(StringExpression)");
        }
        if (!(args.get(0) instanceof StringExpression) && !(args.get(0) instanceof ParameterLiteral)) {
            throw new NucleusException("Incorrect arguments for String.matches(StringExpression)");
        }
        StringExpression argExpr = (StringExpression)args.get(0);
        if (expr instanceof StringLiteral) {
            if (argExpr instanceof StringLiteral) {
                String primary = (String)((StringLiteral)expr).getValue();
                String pattern = (String)((StringLiteral)argExpr).getValue();
                return new BooleanLiteral(expr.getSQLStatement(), this.exprFactory.getMappingForType(Boolean.TYPE, false), primary.matches(pattern));
            }
            return new BooleanExpression(expr, Expression.OP_LIKE, argExpr);
        }
        if (expr instanceof StringExpression) {
            if (argExpr instanceof StringLiteral) {
                String pattern = (String)((StringLiteral)argExpr).getValue();
                boolean caseSensitive = false;
                if (pattern.startsWith("(?i)")) {
                    caseSensitive = true;
                    pattern = pattern.substring(4);
                }
                DatabaseAdapter dba = expr.getSQLStatement().getDatabaseAdapter();
                RegularExpressionConverter converter = new RegularExpressionConverter(dba.getPatternExpressionZeroMoreCharacters().charAt(0), dba.getPatternExpressionAnyCharacter().charAt(0), dba.getEscapeCharacter().charAt(0));
                if (caseSensitive) {
                    SQLExpression patternExpr = this.exprFactory.newLiteral(expr.getSQLStatement(), argExpr.getJavaTypeMapping(), converter.convert(pattern).toLowerCase());
                    return new BooleanExpression(expr.invoke("toLowerCase", null), Expression.OP_LIKE, patternExpr);
                }
                SQLExpression patternExpr = this.exprFactory.newLiteral(expr.getSQLStatement(), argExpr.getJavaTypeMapping(), converter.convert(pattern));
                return new BooleanExpression(expr, Expression.OP_LIKE, patternExpr);
            }
            return new BooleanExpression(expr, Expression.OP_LIKE, argExpr);
        }
        throw new NucleusException(LOCALISER.msg("060001", (Object)"matches", (Object)expr));
    }
}

