/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigDecimal;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.util.StringUtils;

public class FloatingPointLiteral
extends NumericExpression
implements SQLLiteral {
    private final BigDecimal value;

    public FloatingPointLiteral(SQLStatement stmt, JavaTypeMapping mapping) {
        super(stmt, null, mapping);
        this.isParameter = true;
        this.value = null;
        this.st.appendParameter(mapping, this.value);
    }

    public FloatingPointLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        super(stmt, null, mapping);
        if (value instanceof Float) {
            this.value = new BigDecimal(((Float)value).toString());
        } else if (value instanceof Double) {
            this.value = new BigDecimal(((Double)value).toString());
        } else if (value instanceof BigDecimal) {
            this.value = (BigDecimal)value;
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        this.st.append(StringUtils.exponentialFormatBigDecimal((BigDecimal)this.value));
    }

    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) == 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, Expression.OP_EQ, literal);
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) != 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, Expression.OP_NOTEQ, literal);
        }
        return super.ne(expr);
    }

    public BooleanExpression lt(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) < 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, Expression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression le(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) <= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, Expression.OP_LTEQ, expr);
        }
        return super.le(expr);
    }

    public BooleanExpression gt(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) > 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, Expression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression ge(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((FloatingPointLiteral)expr).value) >= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, Expression.OP_GTEQ, expr);
        }
        return super.ge(expr);
    }

    public SQLExpression add(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new NumericExpression(this, Expression.OP_ADD, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.stmt, this.mapping, this.value.add(((FloatingPointLiteral)expr).value));
        }
        return super.add(expr);
    }

    public SQLExpression sub(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new NumericExpression(this, Expression.OP_SUB, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.stmt, this.mapping, this.value.subtract(((FloatingPointLiteral)expr).value));
        }
        return super.sub(expr);
    }

    public SQLExpression mul(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new NumericExpression(this, Expression.OP_MUL, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.stmt, this.mapping, this.value.multiply(((FloatingPointLiteral)expr).value));
        }
        return super.mul(expr);
    }

    public SQLExpression div(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new NumericExpression(this, Expression.OP_DIV, expr);
        }
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.stmt, this.mapping, this.value.divide(((FloatingPointLiteral)expr).value, 1));
        }
        return super.mul(expr);
    }

    public SQLExpression neg() {
        return new FloatingPointLiteral(this.stmt, this.mapping, this.value.negate());
    }

    public Object getValue() {
        return this.value;
    }
}

