/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementMappingForClass;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class LocateRequest2
extends Request {
    private String statementUnlocked;
    private String statementLocked;
    private StatementMappingForClass mappingDefinition;

    public LocateRequest2(DatastoreClass table) {
        super(table);
        RDBMSManager storeMgr = (RDBMSManager)table.getStoreManager();
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        SQLStatement sqlStatement = new SQLStatement(storeMgr, (DatastoreContainerObject)table, null, null);
        this.mappingDefinition = new StatementMappingForClass(null);
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        JavaTypeMapping m = storeMgr.getMappingManager().getMapping(Integer.class);
        sqlStatement.select(exprFactory.newLiteral(sqlStatement, m, 1), null);
        AbstractClassMetaData cmd = storeMgr.getMetaDataManager().getMetaDataForClass(table.getType(), clr);
        int inputParamNum = 1;
        if (table.getIdentityType() == IdentityType.DATASTORE) {
            JavaTypeMapping datastoreIdMapping = table.getDataStoreObjectIdMapping();
            SQLExpression expr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), datastoreIdMapping);
            SQLExpression val = exprFactory.newLiteralParameter(sqlStatement, datastoreIdMapping);
            sqlStatement.whereAnd(expr.eq(val), true);
            StatementMappingIndex datastoreIdx = this.mappingDefinition.getMappingForMemberPosition(StatementMappingForClass.MEMBER_DATASTORE_ID);
            if (datastoreIdx == null) {
                datastoreIdx = new StatementMappingIndex(datastoreIdMapping);
                this.mappingDefinition.addMappingForMember(StatementMappingForClass.MEMBER_DATASTORE_ID, datastoreIdx);
            }
            datastoreIdx.addParameterOccurrence(new int[]{inputParamNum});
        } else if (table.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNums = cmd.getPKMemberPositions();
            for (int i = 0; i < pkNums.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[i]);
                JavaTypeMapping pkMapping = table.getMemberMapping(mmd);
                SQLExpression expr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), pkMapping);
                SQLExpression val = exprFactory.newLiteralParameter(sqlStatement, pkMapping);
                sqlStatement.whereAnd(expr.eq(val), true);
                StatementMappingIndex pkIdx = this.mappingDefinition.getMappingForMemberPosition(pkNums[i]);
                if (pkIdx == null) {
                    pkIdx = new StatementMappingIndex(pkMapping);
                    this.mappingDefinition.addMappingForMember(pkNums[i], pkIdx);
                }
                int[] inputParams = new int[pkMapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < pkMapping.getNumberOfDatastoreFields(); ++j) {
                    inputParams[j] = inputParamNum++;
                }
                pkIdx.addParameterOccurrence(inputParams);
            }
        }
        this.statementUnlocked = sqlStatement.getSelectStatement().toSQL();
        sqlStatement.addExtension("lock-for-update", Boolean.TRUE);
        this.statementLocked = sqlStatement.getSelectStatement().toSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (this.statementLocked != null) {
            ObjectManager om = sm.getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            Transaction tx = om.getTransaction();
            boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
            String statement = useUpdateLock ? this.statementLocked : this.statementUnlocked;
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForQuery(mconn, statement);
                    AbstractClassMetaData cmd = sm.getClassMetaData();
                    try {
                        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                            StatementMappingIndex datastoreIdx = this.mappingDefinition.getMappingForMemberPosition(StatementMappingForClass.MEMBER_DATASTORE_ID);
                            for (int i = 0; i < datastoreIdx.getNumberOfParameterOccurrences(); ++i) {
                                this.table.getDataStoreObjectIdMapping().setObject(om, (Object)ps, datastoreIdx.getParameterPositionsForOccurrence(i), sm.getInternalObjectId());
                            }
                        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                            sm.provideFields(cmd.getPKMemberPositions(), storeMgr.getFieldManagerForStatementGeneration(sm, ps, this.mappingDefinition, false));
                        }
                        ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                        try {
                            if (!rs.next()) {
                                NucleusLogger.DATASTORE_RETRIEVE.info((Object)LOCALISER.msg("050018", sm.getInternalObjectId()));
                                throw new NucleusObjectNotFoundException("No such database row", sm.getInternalObjectId());
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException sqle) {
                String msg = LOCALISER.msg("052220", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)statement, (Object)sqle.getMessage());
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)msg);
                ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
                exceptions.add(sqle);
                while ((sqle = sqle.getNextException()) != null) {
                    exceptions.add(sqle);
                }
                throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
            }
        }
    }
}

