/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.scostore.AbstractMapStore;
import org.datanucleus.store.mapped.scostore.AbstractMapStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.JoinMapStore;
import org.datanucleus.store.mapped.scostore.MapEntrySetStore;
import org.datanucleus.store.mapped.scostore.MapKeySetStore;
import org.datanucleus.store.mapped.scostore.MapValueSetStore;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractMapStoreSpecialization;
import org.datanucleus.store.rdbms.scostore.RDBMSMapEntrySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapKeySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapValueSetStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.scostore.MapStore;

public class RDBMSJoinMapStore
extends JoinMapStore {
    private String putStmt;
    private String updateStmt;
    private String removeStmt;
    private String clearStmt;

    public RDBMSJoinMapStore(MapTable mapTable, ClassLoaderResolver clr, RDBMSManager storeMgr) {
        super((DatastoreContainerObject)mapTable, clr, mapTable.getOwnerMapping(), mapTable.getKeyMapping(), mapTable.getValueMapping(), mapTable.getOrderMapping(), mapTable.getKeyType(), mapTable.isEmbeddedKey(), mapTable.isSerialisedKey(), mapTable.getValueType(), mapTable.isEmbeddedValue(), mapTable.isSerialisedValue(), mapTable.getOwnerMemberMetaData(), (AbstractMapStoreSpecialization)new RDBMSAbstractMapStoreSpecialization(LOCALISER, clr, storeMgr));
        this.getSpecialization().initialise((AbstractMapStore)this);
        this.putStmt = this.getPutStmt();
        this.updateStmt = this.getUpdateStmt();
        this.removeStmt = this.getRemoveStmt();
        this.clearStmt = this.getClearStmt();
    }

    private RDBMSManager getStoreMgr() {
        return (RDBMSManager)this.storeMgr;
    }

    private RDBMSAbstractMapStoreSpecialization getSpecialization() {
        return (RDBMSAbstractMapStoreSpecialization)this.specialization;
    }

    private String getPutStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("INSERT INTO ");
        stmt.append(this.mapTable.toString());
        stmt.append(" (");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(this.adapterMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        stmt.append(") VALUES (");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((RDBMSMapping)this.adapterMapping.getDataStoreMapping(i)).getInsertionInputParameter());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        stmt.append(") ");
        return stmt.toString();
    }

    private String getUpdateStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    private String getRemoveStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    private String getClearStmt() {
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (int i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearInternal(StateManager ownerSM) {
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, (BaseContainerStore)this);
                    sqlControl.executeStatementUpdate(mconn, this.clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)this.clearStmt), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInternal(StateManager sm, Object key) {
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.removeStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)this);
                    jdbcPosition = this.getSpecialization().populateKeyInStatement(om, ps, key, jdbcPosition, this.keyMapping);
                    sqlControl.executeStatementUpdate(mconn, this.removeStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056012", (Object)this.removeStmt), (Throwable)e);
        }
    }

    protected MapKeySetStore newMapKeySetStore() {
        return new RDBMSMapKeySetStore((MapTable)this.mapTable, this.clr, this.getStoreMgr());
    }

    protected MapValueSetStore newMapValueSetStore() {
        return new RDBMSMapValueSetStore((MapTable)this.mapTable, (MapStore)this, this.clr, this.getStoreMgr());
    }

    protected MapEntrySetStore newMapEntrySetStore() {
        return new RDBMSMapEntrySetStore((MapTable)this.mapTable, (MapStore)this, this.clr, this.getStoreMgr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpdate(StateManager ownerSM, ManagedConnection conn, boolean batched, Object key, Object value, boolean executeNow) throws MappedDatastoreException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.getStoreMgr().getSQLController();
        try {
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.updateStmt, false);
            try {
                int jdbcPosition = 1;
                jdbcPosition = this.valueMapping != null ? this.getSpecialization().populateValueInStatement(om, ps, value, jdbcPosition, this.valueMapping) : this.getSpecialization().populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, (JoinTable)this.mapTable, (AbstractMapStore)this);
                jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, (BaseContainerStore)this);
                jdbcPosition = this.getSpecialization().populateKeyInStatement(om, ps, key, jdbcPosition, this.keyMapping);
                if (batched) {
                    ps.addBatch();
                } else {
                    sqlControl.executeStatementUpdate(conn, this.updateStmt, ps, true);
                }
            }
            finally {
                sqlControl.closeStatement(conn, ps);
            }
        }
        catch (SQLException e) {
            throw new MappedDatastoreException(this.getUpdateStmt(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalPut(StateManager ownerSM, ManagedConnection conn, boolean batched, Object key, Object value, boolean executeNow) throws MappedDatastoreException {
        int[] nArray;
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.getStoreMgr().getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.putStmt, false);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.valueMapping != null ? this.getSpecialization().populateValueInStatement(om, ps, value, jdbcPosition, this.valueMapping) : this.getSpecialization().populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, (JoinTable)this.mapTable, (AbstractMapStore)this);
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, (BaseContainerStore)this);
            if (this.adapterMapping != null) {
                long nextIDAdapter = this.getNextIDForAdapterColumn(ownerSM);
                this.adapterMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)this.adapterMapping), (Object)new Long(nextIDAdapter));
                jdbcPosition += this.adapterMapping.getNumberOfDatastoreFields();
            }
            jdbcPosition = this.getSpecialization().populateKeyInStatement(om, ps, key, jdbcPosition, this.keyMapping);
            nArray = sqlControl.executeStatementUpdate(conn, this.putStmt, ps, true);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException e) {
                throw new MappedDatastoreException(this.getPutStmt(), (Throwable)e);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextIDForAdapterColumn(StateManager sm) {
        int nextID;
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                String stmt = this.getMaxAdapterColumnIdStmt();
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)this);
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        nextID = !rs.next() ? 1 : rs.getInt(1) + 1;
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056020", (Object)this.getMaxAdapterColumnIdStmt()), (Throwable)e);
        }
        return nextID;
    }

    private String getMaxAdapterColumnIdStmt() {
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT MAX(" + this.adapterMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier().toString() + ")");
        stmt.append(" FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (int i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }
}

