/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementMappingForClass;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.mapped.scostore.AbstractMapStore;
import org.datanucleus.store.mapped.scostore.AbstractMapStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSElementContainerStoreSpecialization;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.util.Localiser;

class RDBMSAbstractMapStoreSpecialization
extends RDBMSElementContainerStoreSpecialization
implements AbstractMapStoreSpecialization {
    private String containsValueStmt;

    RDBMSAbstractMapStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, RDBMSManager storeMgr) {
        super(localiser, clr, storeMgr);
    }

    public void initialise(AbstractMapStore mapStore) {
        this.containsValueStmt = this.getContainsValueStmt(mapStore.getOwnerMapping(), mapStore.getValueMapping(), mapStore.getMapTable());
    }

    private String getContainsValueStmt(JavaTypeMapping ownerMapping, JavaTypeMapping valueMapping, DatastoreContainerObject mapTable) {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ");
        for (i = 0; i < ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        stmt.append(" FROM ");
        stmt.append(mapTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < valueMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedValue(StateManager sm, Object value, int fieldNumber, Object newValue, JavaTypeMapping fieldMapping, AbstractMapStore mapStore) {
        boolean modified;
        String stmt = this.getUpdateEmbeddedValueStmt(fieldMapping, mapStore.getOwnerMapping(), mapStore.getValueMapping(), mapStore.getMapTable());
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                try {
                    int jdbcPosition = 1;
                    fieldMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)fieldMapping), newValue);
                    jdbcPosition += fieldMapping.getNumberOfDatastoreFields();
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)mapStore);
                    jdbcPosition = this.populateEmbeddedValueFieldsInStatement(sm, value, ps, jdbcPosition, (JoinTable)mapStore.getMapTable(), mapStore);
                    sqlControl.executeStatementUpdate(mconn, stmt, ps, true);
                    modified = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new NucleusDataStoreException(this.localiser.msg("056011", (Object)stmt), (Throwable)e);
        }
        return modified;
    }

    protected String getUpdateEmbeddedKeyStmt(JavaTypeMapping fieldMapping, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, DatastoreContainerObject mapTable) {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(fieldMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)fieldMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        EmbeddedKeyPCMapping embeddedMapping = (EmbeddedKeyPCMapping)keyMapping;
        for (int i2 = 0; i2 < embeddedMapping.getNumberOfJavaTypeMappings(); ++i2) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i2);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                stmt.append(" AND ");
                stmt.append(m.getDataStoreMapping(j).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    protected String getUpdateEmbeddedValueStmt(JavaTypeMapping fieldMapping, JavaTypeMapping ownerMapping, JavaTypeMapping valueMapping, DatastoreContainerObject mapTable) {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(fieldMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)fieldMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        EmbeddedValuePCMapping embeddedMapping = (EmbeddedValuePCMapping)valueMapping;
        for (int i2 = 0; i2 < embeddedMapping.getNumberOfJavaTypeMappings(); ++i2) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i2);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                stmt.append(" AND ");
                stmt.append(m.getDataStoreMapping(j).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatedEmbeddedKey(StateManager sm, Object key, int fieldNumber, Object newValue, JavaTypeMapping fieldMapping, AbstractMapStore mapStore) {
        boolean modified;
        String stmt = this.getUpdateEmbeddedKeyStmt(fieldMapping, mapStore.getOwnerMapping(), mapStore.getKeyMapping(), mapStore.getMapTable());
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                try {
                    int jdbcPosition = 1;
                    fieldMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)fieldMapping), key);
                    jdbcPosition += fieldMapping.getNumberOfDatastoreFields();
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)mapStore);
                    jdbcPosition = this.populateEmbeddedKeyFieldsInStatement(sm, key, ps, jdbcPosition, (JoinTable)mapStore.getMapTable(), mapStore);
                    sqlControl.executeStatementUpdate(mconn, stmt, ps, true);
                    modified = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new NucleusDataStoreException(this.localiser.msg("056010", (Object)stmt), (Throwable)e);
        }
        return modified;
    }

    protected int populateEmbeddedKeyFieldsInStatement(StateManager sm, Object key, PreparedStatement ps, int jdbcPosition, JoinTable joinTable, AbstractMapStore mapStore) {
        AbstractClassMetaData kmd = mapStore.getKmd();
        EmbeddedKeyPCMapping embeddedMapping = (EmbeddedKeyPCMapping)mapStore.getKeyMapping();
        StatementMappingForClass mappingDefinition = new StatementMappingForClass(null);
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = kmd.getAbsolutePositionOfMember(fieldMapping.getMemberMetaData().getName());
            if (fieldMapping == null) continue;
            StatementMappingIndex stmtMapping = new StatementMappingIndex(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            stmtMapping.addParameterOccurrence(jdbcParamPositions);
            mappingDefinition.addMappingForMember(absFieldNum, stmtMapping);
        }
        StateManager elementSM = mapStore.getStateManagerForEmbeddedPCObject(sm, key, joinTable.getOwnerMemberMetaData());
        elementSM.setPcObjectType(3);
        elementSM.provideFields(elementFieldNumbers, this.storeMgr.getFieldManagerForStatementGeneration(elementSM, ps, mappingDefinition, true));
        return jdbcPosition;
    }

    protected int populateEmbeddedValueFieldsInStatement(StateManager sm, Object value, PreparedStatement ps, int jdbcPosition, JoinTable joinTable, AbstractMapStore mapStore) {
        AbstractClassMetaData vmd = mapStore.getVmd();
        EmbeddedValuePCMapping embeddedMapping = (EmbeddedValuePCMapping)mapStore.getValueMapping();
        StatementMappingForClass mappingDefinition = new StatementMappingForClass(null);
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = vmd.getAbsolutePositionOfMember(fieldMapping.getMemberMetaData().getName());
            if (fieldMapping == null) continue;
            StatementMappingIndex stmtMapping = new StatementMappingIndex(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            stmtMapping.addParameterOccurrence(jdbcParamPositions);
            mappingDefinition.addMappingForMember(absFieldNum, stmtMapping);
        }
        StateManager elementSM = mapStore.getStateManagerForEmbeddedPCObject(sm, value, joinTable.getOwnerMemberMetaData());
        elementSM.setPcObjectType(4);
        elementSM.provideFields(elementFieldNumbers, this.storeMgr.getFieldManagerForStatementGeneration(elementSM, ps, mappingDefinition, true));
        return jdbcPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(StateManager sm, Object value, AbstractMapStore abstractMapStore) {
        boolean exists = false;
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, this.containsValueStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)abstractMapStore);
                    jdbcPosition = this.populateValueInStatement(om, ps, value, jdbcPosition, abstractMapStore.getValueMapping());
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, this.containsValueStmt, ps);
                    try {
                        if (rs.next()) {
                            exists = true;
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056019", (Object)this.containsValueStmt), (Throwable)e);
        }
        return exists;
    }

    protected PreparedStatement getStatementForQuery(QueryExpression qs, ObjectManager om, ManagedConnection conn, boolean updateLock, String resultSetType, String resultSetConcurrency) throws SQLException {
        return this.storeMgr.getStatementForQuery(qs, om, conn, updateLock, resultSetType, resultSetConcurrency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(StateManager sm, Object key, QueryExpression stmt, Transaction tx, boolean useUpdateLock, AbstractMapStore mapStore, ResultObjectFactory rof) {
        ObjectManager om = sm.getObjectManager();
        JavaTypeMapping valueMapping = mapStore.getValueMapping();
        String statement = stmt.toStatementText(useUpdateLock).toString();
        Object value = null;
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = this.storeMgr.getStatementForQuery(stmt, om, mconn, useUpdateLock, null, null);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                    try {
                        boolean found = rs.next();
                        if (!found) {
                            throw new NoSuchElementException();
                        }
                        if (mapStore.isValuesAreEmbedded() || mapStore.isValuesAreSerialised()) {
                            int[] param = new int[valueMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            if (valueMapping instanceof SerialisedPCMapping || valueMapping instanceof SerialisedReferenceMapping || valueMapping instanceof EmbeddedKeyPCMapping) {
                                int ownerFieldNumber = -1;
                                if (mapStore.getMapTable() != null) {
                                    ownerFieldNumber = ((JoinTable)mapStore.getMapTable()).getOwnerMemberMetaData().getAbsoluteFieldNumber();
                                }
                                value = valueMapping.getObject(om, (Object)rs, param, sm, ownerFieldNumber);
                            } else {
                                value = valueMapping.getObject(om, (Object)rs, param);
                            }
                        } else if (valueMapping instanceof ReferenceMapping) {
                            int[] param = new int[valueMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            value = valueMapping.getObject(om, (Object)rs, param);
                        } else {
                            value = rof.getObject(om, (Object)rs);
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056014", (Object)statement), (Throwable)e);
        }
        return value;
    }

    protected int populateKeyInStatement(ObjectManager om, PreparedStatement ps, Object key, int jdbcPosition, JavaTypeMapping keyMapping) {
        if (!((RDBMSMapping)keyMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        keyMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)keyMapping), key);
        return jdbcPosition + keyMapping.getNumberOfDatastoreFields();
    }

    protected int populateValueInStatement(ObjectManager om, PreparedStatement ps, Object value, int jdbcPosition, JavaTypeMapping valueMapping) {
        if (!((RDBMSMapping)valueMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        valueMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)valueMapping), value);
        return jdbcPosition + valueMapping.getNumberOfDatastoreFields();
    }
}

