/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.store.mapped.ColumnCreator;
import org.datanucleus.store.mapped.DatastoreElementContainer;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.table.ElementContainerTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class ArrayTable
extends ElementContainerTable
implements DatastoreElementContainer {
    public ArrayTable(DatastoreIdentifier tableName, AbstractMemberMetaData fmd, RDBMSManager storeMgr) {
        super(tableName, fmd, storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        boolean elementPC;
        PrimaryKeyMetaData pkmd;
        super.initialize(clr);
        PrimaryKeyMetaData primaryKeyMetaData = pkmd = this.fmd.getJoinMetaData() != null ? this.fmd.getJoinMetaData().getPrimaryKeyMetaData() : null;
        boolean pkColsSpecified = pkmd != null ? pkmd.getColumnMetaData() != null : false;
        boolean pkRequired = this.requiresPrimaryKey();
        boolean bl = elementPC = this.fmd.hasArray() && this.fmd.getArray().getElementClassMetaData() != null;
        if (this.isSerialisedElementPC() || this.isEmbeddedElementPC() || this.isEmbeddedElement() && !elementPC || ClassUtils.isReferenceType(this.fmd.getType().getComponentType())) {
            this.elementMapping = this.storeMgr.getMappingManager().getMapping(this, this.fmd, this.dba, clr, 4);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.elementMapping);
            }
        } else {
            ColumnMetaData[] elemColmd = null;
            ElementMetaData elemmd = this.fmd.getElementMetaData();
            if (elemmd != null && elemmd.getColumnMetaData() != null && elemmd.getColumnMetaData().length > 0) {
                elemColmd = elemmd.getColumnMetaData();
            }
            this.elementMapping = ColumnCreator.createColumnsForJoinTables(this.fmd.getType().getComponentType(), this.fmd, elemColmd, this.storeMgr, this, false, true, 4, clr);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.elementMapping);
            }
        }
        ColumnMetaData colmd = null;
        if (this.fmd.getOrderMetaData() != null && this.fmd.getOrderMetaData().getColumnMetaData() != null && this.fmd.getOrderMetaData().getColumnMetaData().length > 0) {
            colmd = this.fmd.getOrderMetaData().getColumnMetaData()[0];
        } else {
            DatastoreIdentifier id = this.storeMgr.getIdentifierFactory().newIndexFieldIdentifier(this.fmd);
            colmd = new ColumnMetaData(id.getIdentifierName());
        }
        this.orderMapping = this.storeMgr.getMappingManager().getMapping(Integer.TYPE);
        ColumnCreator.createIndexColumn(this.orderMapping, this.storeMgr, clr, this, colmd, pkRequired && !pkColsSpecified);
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            this.debugMapping(this.orderMapping);
        }
        if (pkRequired && pkColsSpecified) {
            this.applyUserPrimaryKeySpecification(pkmd);
        }
        this.state = 2;
    }

    public String getElementType() {
        return this.fmd.getType().getComponentType().getName();
    }

    public boolean isSerialisedElement() {
        return this.fmd.getArray() != null && this.fmd.getArray().isSerializedElement();
    }

    public boolean isEmbeddedElement() {
        if (this.fmd.getArray() != null && this.fmd.getArray().isSerializedElement()) {
            return false;
        }
        return this.fmd.getArray() != null && this.fmd.getArray().isEmbeddedElement();
    }

    public boolean isSerialisedElementPC() {
        return this.fmd.getArray() != null && this.fmd.getArray().isSerializedElement();
    }

    public boolean isEmbeddedElementPC() {
        if (this.fmd.getArray() != null && this.fmd.getArray().isSerializedElement()) {
            return false;
        }
        return this.fmd.getElementMetaData() != null && this.fmd.getElementMetaData().getEmbeddedMetaData() != null;
    }
}

