/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.List;
import java.util.ListIterator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.util.Localiser;

public abstract class SQLExpression {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    public static final int SQL_USE_FILTER = 0;
    public static final int SQL_USE_SELECT = 1;
    protected SQLStatement stmt;
    protected SQLTable table;
    protected JavaTypeMapping mapping;
    protected final SQLText st = new SQLText();
    protected Expression.Operator lowestOperator = null;

    protected SQLExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        this.stmt = stmt;
        this.table = table;
        this.mapping = mapping;
    }

    protected SQLExpression(Expression.MonadicOperator op, SQLExpression expr1) {
        this.st.append(op.toString());
        if (op.isHigherThan(expr1.lowestOperator)) {
            this.st.append('(').append(expr1).append(')');
        } else {
            this.st.append(expr1);
        }
        this.stmt = expr1.stmt;
        this.mapping = expr1.mapping;
        this.lowestOperator = op;
    }

    protected SQLExpression(SQLExpression expr1, Expression.DyadicOperator op, SQLExpression expr2) {
        this.stmt = expr1.stmt;
        this.mapping = expr1.mapping != null ? expr1.mapping : expr2.mapping;
        this.lowestOperator = op;
        if (op.isHigherThanLeftSide(expr1.lowestOperator)) {
            this.st.append('(').append(expr1).append(')');
        } else {
            this.st.append(expr1);
        }
        this.st.append(op.toString());
        if (op.isHigherThanRightSide(expr2.lowestOperator)) {
            this.st.append('(').append(expr2).append(')');
        } else {
            this.st.append(expr2);
        }
    }

    protected SQLExpression(String functionName, List args) {
        this.st.append(functionName).append('(');
        SQLExpression arg = null;
        ListIterator i = args.listIterator();
        Object expr = i.next();
        if (expr instanceof String) {
            this.st.append(expr.toString());
        } else {
            arg = (SQLExpression)expr;
            this.st.append(arg);
        }
        while (i.hasNext()) {
            expr = i.next();
            if (expr instanceof String) {
                this.st.append(',').append(expr.toString());
                continue;
            }
            arg = (SQLExpression)expr;
            this.st.append(',').append(arg);
        }
        this.stmt = arg.stmt;
        this.st.append(')');
    }

    protected SQLExpression(String functionName, List args, List types) {
        this.st.append(functionName).append('(');
        ListIterator i = args.listIterator();
        ListIterator iTypes = types.listIterator();
        SQLExpression arg = (SQLExpression)i.next();
        this.st.append(arg);
        this.st.append(" AS ");
        Object type = iTypes.next();
        if (type instanceof SQLExpression) {
            this.st.append((SQLExpression)type);
        } else {
            this.st.append(type.toString());
        }
        this.stmt = arg.stmt;
        while (i.hasNext()) {
            arg = (SQLExpression)i.next();
            this.st.append(',').append(arg);
            this.st.append(" AS ");
            type = iTypes.next();
            if (type instanceof SQLExpression) {
                this.st.append((SQLExpression)type);
                continue;
            }
            this.st.append(type.toString());
        }
        this.st.append(')');
    }

    public SQLStatement getSQLStatement() {
        return this.stmt;
    }

    public JavaTypeMapping getJavaTypeMapping() {
        return this.mapping;
    }

    public SQLTable getSQLTable() {
        return this.table;
    }

    public SQLText toSQL(int mode) {
        return this.st;
    }

    public SQLExpression encloseInParentheses() {
        this.st.encloseInParentheses();
        return this;
    }

    public BooleanExpression and(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "&&", expr);
    }

    public BooleanExpression eor(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "^", expr);
    }

    public BooleanExpression ior(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "||", expr);
    }

    public BooleanExpression not() {
        throw new IllegalExpressionOperationException("!", this);
    }

    public BooleanExpression eq(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "==", expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "!=", expr);
    }

    public BooleanExpression lt(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "<", expr);
    }

    public BooleanExpression le(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "<=", expr);
    }

    public BooleanExpression gt(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, ">", expr);
    }

    public BooleanExpression ge(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, ">=", expr);
    }

    public BooleanExpression instanceOf(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "instanceof", expr);
    }

    public BooleanExpression in(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "in", expr);
    }

    public SQLExpression add(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "+", expr);
    }

    public SQLExpression sub(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "-", expr);
    }

    public SQLExpression mul(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "*", expr);
    }

    public SQLExpression div(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "/", expr);
    }

    public SQLExpression mod(SQLExpression expr) {
        throw new IllegalExpressionOperationException(this, "%", expr);
    }

    public SQLExpression neg() {
        throw new IllegalExpressionOperationException("-", this);
    }

    public SQLExpression com() {
        throw new IllegalExpressionOperationException("~", this);
    }

    public SQLExpression cast(Class type) {
        throw new IllegalExpressionOperationException("cast to " + type.getName(), this);
    }

    public SQLExpression accessField(String fieldName) {
        throw new IllegalExpressionOperationException("access of field " + fieldName, this);
    }

    public SQLExpression invoke(String methodName, List args) {
        throw new IllegalExpressionOperationException("." + methodName, this);
    }
}

