/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.FetchStatement;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.SecondaryDatastoreClass;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.rdbms.RDBMSFetchStatement;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.fieldmanager.ResultSetGetter;
import org.datanucleus.store.rdbms.request.MappingStatementIndex;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.table.AbstractClassTable;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FetchRequest
extends Request {
    private final MappingCallbacks[] callbacks;
    private FetchMappingConsumer consumer;
    private MappingStatementIndex mappingStatementIndex;
    private final String fieldsToFetch;
    private final int numberOfFieldsToFetch;
    private String[] stmt;
    private boolean fetchingSurrogateVersion = false;
    private String versionFieldName = null;
    private VersionMetaData versionMetaData = null;

    public FetchRequest(DatastoreClass classTable, AbstractMemberMetaData[] fieldMetaData, Class cls, ClassLoaderResolver clr) {
        super(classTable);
        DatastoreClass candidateTable;
        AbstractClassMetaData cmd = classTable.getStoreManager().getOMFContext().getMetaDataManager().getMetaDataForClass(cls, clr);
        boolean found = false;
        for (candidateTable = classTable; candidateTable != null; candidateTable = candidateTable.getSuperDatastoreClass()) {
            for (int i = 0; i < fieldMetaData.length; ++i) {
                JavaTypeMapping m = candidateTable.getFieldMappingInDatastoreClass(fieldMetaData[i]);
                if (m == null) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (candidateTable == null) {
            candidateTable = classTable;
        }
        this.table = candidateTable;
        this.key = ((AbstractClassTable)((Object)this.table)).getPrimaryKey();
        this.mappingStatementIndex = new MappingStatementIndex();
        RDBMSFetchStatement fetchStatement = new RDBMSFetchStatement(this.table);
        this.consumer = new FetchMappingConsumer(fetchStatement, cmd, clr);
        this.table.provideDatastoreIdMappings(this.consumer);
        for (DatastoreClass currentTable = this.table; currentTable != null; currentTable = currentTable.getSuperDatastoreClass()) {
            currentTable.provideMappingsForFields(this.consumer, fieldMetaData, true);
            currentTable.provideDiscriminatorMappings(this.consumer);
            VersionMetaData currentVermd = currentTable.getVersionMetaData();
            if (currentVermd == null) continue;
            if (currentVermd.getFieldName() == null) {
                currentTable.provideVersionMappings(this.consumer);
                this.fetchingSurrogateVersion = true;
                this.versionMetaData = currentVermd;
                continue;
            }
            this.versionFieldName = currentVermd.getFieldName();
            this.versionMetaData = currentVermd;
            AbstractMemberMetaData[] mmds = new AbstractMemberMetaData[]{cmd.getMetaDataForMember(currentVermd.getFieldName())};
            currentTable.provideMappingsForFields(this.consumer, mmds, true);
        }
        this.callbacks = this.consumer.getMappingCallbacks().toArray(new MappingCallbacks[this.consumer.getMappingCallbacks().size()]);
        StringBuffer str = new StringBuffer();
        int[] fieldNumbersToFetch = this.consumer.getNumbersOfFieldsToBeFetched();
        int n = this.numberOfFieldsToFetch = fieldNumbersToFetch != null ? fieldNumbersToFetch.length : 0;
        if (fieldNumbersToFetch != null && fieldNumbersToFetch.length > 0) {
            for (int i = 0; i < fieldNumbersToFetch.length; ++i) {
                AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbersToFetch[i]);
                if (i > 0) {
                    str.append(",");
                }
                str.append(fmd.getName());
            }
        }
        if (this.fetchingSurrogateVersion) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("[VERSION]");
        }
        this.fieldsToFetch = str.length() > 0 ? str.toString() : null;
        if (str.length() > 0) {
            this.table.providePrimaryKeyMappings(this.consumer);
        } else {
            fetchStatement = null;
        }
        if (fetchStatement != null) {
            this.stmt = new String[2];
            this.stmt[0] = fetchStatement.toString(false);
            this.stmt[1] = fetchStatement.toString(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (this.fieldsToFetch != null && NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("052218", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.fieldsToFetch, (Object)this.table));
        }
        if (this.isFetchingVersionOnly() && this.isVersionLoaded(sm)) {
            Transaction tx = sm.getObjectManager().getTransaction();
            boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
            String statement = this.stmt[useUpdateLock ? 1 : 0];
            NucleusLogger.PERSISTENCE.debug((Object)("FetchRequest " + statement + " is to only fetch the version yet it is loaded so omitting the fetch "));
        } else if (this.stmt != null) {
            ObjectManager om = sm.getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            Transaction tx = om.getTransaction();
            boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
            String statement = this.stmt[useUpdateLock ? 1 : 0];
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForQuery(mconn, statement);
                    try {
                        if (sm.getInternalObjectId() instanceof OID) {
                            this.table.getDataStoreObjectIdMapping().setObject(om, ps, this.mappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                        } else {
                            sm.provideFields(this.consumer.getPrimaryKeyFieldsToBeProvided(), (FieldManager)new ParameterSetter(sm, ps, this.mappingStatementIndex.getFields(), false));
                        }
                        ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                        try {
                            if (!rs.next()) {
                                if (NucleusLogger.DATASTORE_RETRIEVE.isInfoEnabled()) {
                                    NucleusLogger.DATASTORE_RETRIEVE.info((Object)LOCALISER.msg("050018", sm.getInternalObjectId()));
                                }
                                throw new NucleusObjectNotFoundException("No such database row", sm.getInternalObjectId());
                            }
                            sm.replaceFields(this.consumer.getNumbersOfFieldsToBeFetched(), (FieldManager)new ResultSetGetter(sm, rs, this.mappingStatementIndex.getFields()));
                            if (sm.getTransactionalVersion(sm.getObject()) == null) {
                                Object datastoreVersion = null;
                                if (this.fetchingSurrogateVersion) {
                                    datastoreVersion = this.table.getVersionMapping(true).getObject(om, rs, this.mappingStatementIndex.getVersion().getExpressionIndex());
                                } else if (this.versionFieldName != null) {
                                    AbstractClassMetaData cmd = (AbstractClassMetaData)this.versionMetaData.getParent();
                                    datastoreVersion = sm.provideField(cmd.getAbsolutePositionOfMember(this.versionFieldName));
                                }
                                sm.setVersion(datastoreVersion);
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                String msg = LOCALISER.msg("052219", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)statement, (Object)e.getMessage());
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)msg);
                ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
                exceptions.add(e);
                while ((e = e.getNextException()) != null) {
                    exceptions.add(e);
                }
                throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
            }
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            this.callbacks[i].postFetch(sm);
        }
    }

    private boolean isVersionLoaded(StateManager sm) {
        return sm.getObject() != null && sm.getObjectManager().getApiAdapter().getVersion(sm) != null;
    }

    private boolean isFetchingVersionOnly() {
        return (this.fetchingSurrogateVersion || this.versionFieldName != null) && this.numberOfFieldsToFetch == 0;
    }

    private class FetchMappingConsumer
    implements MappingConsumer {
        private int paramIndex = 1;
        final FetchStatement fetchStmt;
        List fetchFields = new ArrayList();
        List pkbp = new ArrayList();
        List mappingCallbacks = new ArrayList();
        boolean initialized = false;
        final ClassLoaderResolver clr;
        final MappedStoreManager storeMgr;
        final AbstractClassMetaData cmd;

        public FetchMappingConsumer(FetchStatement fetchStmt, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
            this.fetchStmt = fetchStmt;
            this.cmd = cmd;
            this.clr = clr;
            this.storeMgr = FetchRequest.this.table.getStoreManager();
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                FetchRequest.this.mappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highestFieldNumber]);
                FetchRequest.this.mappingStatementIndex.setFields(new StatementExpressionIndex[highestFieldNumber]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInFetchStatement()) {
                ((FetchRequest)FetchRequest.this).mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                FetchRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setMapping(m);
                int[] expressionsIndex = null;
                if (m.getNumberOfDatastoreFields() == 0 && (m instanceof PersistenceCapableMapping || m instanceof InterfaceMapping)) {
                    int relationType = fmd.getRelationType(this.clr);
                    if (relationType == 2) {
                        MetaDataManager mmgr = this.storeMgr.getOMFContext().getMetaDataManager();
                        if (fmd.getMappedBy() != null) {
                            Class fieldType = fmd.getType();
                            String[] clsNames = null;
                            if (fieldType.isInterface()) {
                                if (fmd.getFieldTypes() != null && fmd.getFieldTypes().length == 1) {
                                    Class fldTypeCls = this.clr.classForName(fmd.getFieldTypes()[0]);
                                    clsNames = fldTypeCls.isInterface() ? mmgr.getClassesImplementingInterface(fmd.getFieldTypes()[0], this.clr) : new String[]{fmd.getFieldTypes()[0]};
                                }
                                if (clsNames == null) {
                                    clsNames = mmgr.getClassesImplementingInterface(fieldType.getName(), this.clr);
                                }
                            } else {
                                clsNames = new String[]{fieldType.getName()};
                            }
                            DatastoreClass relatedTable = this.storeMgr.getDatastoreClass(clsNames[0], this.clr);
                            JavaTypeMapping referenceMapping = relatedTable.getFieldMapping(fmd.getMappedBy());
                            JavaTypeMapping selectMapping = relatedTable.getIDMapping();
                            JavaTypeMapping refDiscrimMapping = relatedTable.getDiscriminatorMapping(false);
                            Object[] discrimValues = null;
                            JavaTypeMapping refTypeMapping = null;
                            expressionsIndex = new int[referenceMapping.getNumberOfDatastoreFields()];
                            if (refDiscrimMapping != null) {
                                DiscriminatorStrategy strategy = relatedTable.getDiscriminatorMetaData().getStrategy();
                                if (strategy == DiscriminatorStrategy.CLASS_NAME) {
                                    int i;
                                    HashSet<String> allclasses = new HashSet<String>();
                                    if (clsNames != null) {
                                        for (i = 0; i < clsNames.length; ++i) {
                                            allclasses.add(clsNames[i]);
                                        }
                                    }
                                    for (i = 0; i < clsNames.length; ++i) {
                                        HashSet subclasses = this.storeMgr.getSubClassesForClass(clsNames[i], true, this.clr);
                                        if (subclasses == null || subclasses.size() <= 0) continue;
                                        allclasses.addAll(subclasses);
                                    }
                                    discrimValues = allclasses.toArray();
                                } else if (strategy == DiscriminatorStrategy.VALUE_MAP) {
                                    HashSet subclasses = this.storeMgr.getSubClassesForClass(fmd.getTypeName(), true, this.clr);
                                    if (subclasses != null && subclasses.size() > 0) {
                                        int valNo = 0;
                                        discrimValues = new Object[subclasses.size() + 1];
                                        discrimValues[valNo++] = fmd.getAbstractClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData().getValue();
                                        for (String subclass : subclasses) {
                                            AbstractClassMetaData subclassCmd = mmgr.getMetaDataForClass(subclass, this.clr);
                                            discrimValues[valNo++] = subclassCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
                                        }
                                    } else {
                                        discrimValues = new Object[]{mmgr.getMetaDataForClass(fmd.getType(), this.clr).getInheritanceMetaData().getDiscriminatorMetaData().getValue()};
                                    }
                                }
                            } else if (relatedTable != referenceMapping.getDataStoreMapping(0).getDatastoreField().getDatastoreContainerObject()) {
                                refTypeMapping = relatedTable.getIDMapping();
                            }
                            expressionsIndex = refTypeMapping == null ? this.fetchStmt.selectOuterJoin(referenceMapping, selectMapping, refDiscrimMapping, discrimValues, false) : this.fetchStmt.selectOuterJoin(referenceMapping, selectMapping, refTypeMapping);
                        }
                    } else if (relationType == 6) {
                        DatastoreContainerObject joinTable;
                        AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                        if ((fmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) && (joinTable = this.storeMgr.getDatastoreContainerObject(relatedMmds[0])) != null) {
                            JavaTypeMapping referenceMapping = null;
                            JavaTypeMapping selectMapping = null;
                            if (Collection.class.isAssignableFrom(relatedMmds[0].getType())) {
                                CollectionTable collTable = (CollectionTable)joinTable;
                                referenceMapping = collTable.getElementMapping();
                                selectMapping = collTable.getOwnerMapping();
                            }
                            expressionsIndex = this.fetchStmt.selectOuterJoin(referenceMapping, selectMapping, null, null, false);
                        }
                    }
                } else {
                    DatastoreContainerObject mappingTable = m.getDatastoreContainer();
                    if (fmd.getTable() != null && mappingTable instanceof SecondaryDatastoreClass) {
                        SecondaryDatastoreClass secTable = (SecondaryDatastoreClass)mappingTable;
                        if (secTable.getJoinMetaData().isOuter()) {
                            expressionsIndex = this.fetchStmt.selectOuterJoin(secTable.getIDMapping(), m, null, null, true);
                        } else {
                            expressionsIndex = new int[m.getNumberOfDatastoreFields()];
                            for (int i = 0; i < expressionsIndex.length; ++i) {
                                expressionsIndex[i] = this.fetchStmt.select(m.getDataStoreMapping(i).getDatastoreField());
                            }
                        }
                    } else {
                        expressionsIndex = new int[m.getNumberOfDatastoreFields()];
                        for (int i = 0; i < expressionsIndex.length; ++i) {
                            expressionsIndex[i] = this.fetchStmt.select(m.getDataStoreMapping(i).getDatastoreField());
                        }
                    }
                }
                FetchRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setExpressionIndex(expressionsIndex);
                Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                if (fmd.isPrimaryKey()) {
                    int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField(m.getDataStoreMapping(j).getDatastoreField()) + "=?");
                        if (!this.pkbp.contains(abs_field_num)) {
                            this.pkbp.add(abs_field_num);
                        }
                        ++this.paramIndex;
                    }
                    FetchRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setParameterIndex(parametersIndex);
                } else if (!this.fetchFields.contains(abs_field_num)) {
                    this.fetchFields.add(abs_field_num);
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mappingCallbacks.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                FetchRequest.this.mappingStatementIndex.getVersion().setMapping(m);
                int[] expressionsIndex = new int[m.getNumberOfDatastoreFields()];
                for (int j = 0; j < expressionsIndex.length; ++j) {
                    expressionsIndex[j] = this.fetchStmt.select(m.getDataStoreMapping(j).getDatastoreField());
                }
                FetchRequest.this.mappingStatementIndex.getVersion().setExpressionIndex(expressionsIndex);
            } else if (mappingType == 2) {
                this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField((DatastoreField)FetchRequest.this.key.getColumns().get(0)) + "=?");
                int[] nArray = new int[]{this.paramIndex++};
                FetchRequest.this.mappingStatementIndex.getDatastoreId().setParameterIndex(nArray);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
        }

        public List getMappingCallbacks() {
            return this.mappingCallbacks;
        }

        public int[] getNumbersOfFieldsToBeFetched() {
            int[] fieldsToBeFetched = new int[this.fetchFields.size()];
            for (int i = 0; i < this.fetchFields.size(); ++i) {
                fieldsToBeFetched[i] = (Integer)this.fetchFields.get(i);
            }
            return fieldsToBeFetched;
        }

        public int[] getPrimaryKeyFieldsToBeProvided() {
            int[] pkfieldsToBeProvided = new int[this.pkbp.size()];
            for (int i = 0; i < this.pkbp.size(); ++i) {
                pkfieldsToBeProvided[i] = (Integer)this.pkbp.get(i);
            }
            return pkfieldsToBeProvided;
        }
    }
}

