/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class JDBCUtils {
    private static Map supportedJdbcTypesById = new HashMap();
    private static Map unsupportedJdbcTypesById = new HashMap();

    public static boolean isValidJDBCType(String typeName) {
        if (typeName == null) {
            return false;
        }
        for (String name : supportedJdbcTypesById.values()) {
            if (!name.equalsIgnoreCase(typeName)) continue;
            return true;
        }
        return false;
    }

    public static final int[] getJDBCTypes() {
        int[] types = new int[supportedJdbcTypesById.size() + unsupportedJdbcTypesById.size()];
        int i = 0;
        Iterator suppIter = supportedJdbcTypesById.keySet().iterator();
        while (suppIter.hasNext()) {
            types[i++] = (Integer)suppIter.next();
        }
        Iterator unsuppIter = unsupportedJdbcTypesById.keySet().iterator();
        while (unsuppIter.hasNext()) {
            types[i++] = (Integer)unsuppIter.next();
        }
        return types;
    }

    public static String getNameForJDBCType(int jdbcType) {
        String typeName = (String)supportedJdbcTypesById.get(new Integer(jdbcType));
        if (typeName == null) {
            typeName = (String)unsupportedJdbcTypesById.get(new Integer(jdbcType));
        }
        return typeName;
    }

    public static int getJDBCTypeForName(String typeName) {
        if (typeName == null) {
            return 0;
        }
        Set entries = supportedJdbcTypesById.entrySet();
        for (Map.Entry entry : entries) {
            if (!typeName.equalsIgnoreCase((String)entry.getValue())) continue;
            return (Integer)entry.getKey();
        }
        return 0;
    }

    public static String getSubprotocolForURL(String url) {
        StringTokenizer tokeniser = new StringTokenizer(url, ":");
        tokeniser.nextToken();
        return tokeniser.nextToken();
    }

    static {
        supportedJdbcTypesById.put(new Integer(-5), "BIGINT");
        supportedJdbcTypesById.put(new Integer(-7), "BIT");
        supportedJdbcTypesById.put(new Integer(2004), "BLOB");
        supportedJdbcTypesById.put(new Integer(16), "BOOLEAN");
        supportedJdbcTypesById.put(new Integer(1), "CHAR");
        supportedJdbcTypesById.put(new Integer(2005), "CLOB");
        supportedJdbcTypesById.put(new Integer(70), "DATALINK");
        supportedJdbcTypesById.put(new Integer(91), "DATE");
        supportedJdbcTypesById.put(new Integer(3), "DECIMAL");
        supportedJdbcTypesById.put(new Integer(8), "DOUBLE");
        supportedJdbcTypesById.put(new Integer(6), "FLOAT");
        supportedJdbcTypesById.put(new Integer(4), "INTEGER");
        supportedJdbcTypesById.put(new Integer(-4), "LONGVARBINARY");
        supportedJdbcTypesById.put(new Integer(-1), "LONGVARCHAR");
        supportedJdbcTypesById.put(new Integer(2), "NUMERIC");
        supportedJdbcTypesById.put(new Integer(7), "REAL");
        supportedJdbcTypesById.put(new Integer(5), "SMALLINT");
        supportedJdbcTypesById.put(new Integer(92), "TIME");
        supportedJdbcTypesById.put(new Integer(93), "TIMESTAMP");
        supportedJdbcTypesById.put(new Integer(-6), "TINYINT");
        supportedJdbcTypesById.put(new Integer(-3), "VARBINARY");
        supportedJdbcTypesById.put(new Integer(12), "VARCHAR");
        supportedJdbcTypesById.put(new Integer(-9), "NVARCHAR");
        supportedJdbcTypesById.put(new Integer(-15), "NCHAR");
        supportedJdbcTypesById.put(new Integer(2011), "NCLOB");
        unsupportedJdbcTypesById.put(new Integer(2003), "ARRAY");
        unsupportedJdbcTypesById.put(new Integer(-2), "BINARY");
        unsupportedJdbcTypesById.put(new Integer(2001), "DISTINCT");
        unsupportedJdbcTypesById.put(new Integer(2000), "JAVA_OBJECT");
        unsupportedJdbcTypesById.put(new Integer(0), "NULL");
        unsupportedJdbcTypesById.put(new Integer(1111), "OTHER");
        unsupportedJdbcTypesById.put(new Integer(2006), "REF");
        unsupportedJdbcTypesById.put(new Integer(2002), "STRUCT");
    }
}

