/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.sql.SQLColumn;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLTableNamer;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SQLStatement {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    protected static Map<String, SQLTableNamer> tableNamerByName = new HashMap<String, SQLTableNamer>();
    protected SQLText sql = null;
    protected RDBMSManager rdbmsMgr;
    protected boolean distinct = false;
    protected HashMap<String, Object> extensions;
    protected SQLStatement parent = null;
    protected List<SQLStatement> unions = null;
    protected List<String> selects = new ArrayList<String>();
    protected SQLExpression[] updates = null;
    protected boolean aggregated = false;
    protected SQLTable primaryTable;
    protected List<SQLJoin> joins;
    protected HashMap<String, SQLTable> tables;
    protected BooleanExpression where;
    protected List<SQLExpression> groupingExpressions = null;
    protected BooleanExpression having;
    protected SQLExpression[] orderingExpressions = null;
    protected boolean[] orderingDirections = null;
    protected long rangeOffset = -1L;
    protected long rangeCount = -1L;
    private int[] orderingColumnIndexes;

    public SQLStatement(RDBMSManager rdbmsMgr, DatastoreContainerObject table, DatastoreIdentifier alias) {
        this.rdbmsMgr = rdbmsMgr;
        if (alias == null) {
            alias = rdbmsMgr.getIdentifierFactory().newDatastoreContainerIdentifier(this.generateTableAlias(table));
        }
        this.primaryTable = new SQLTable(table, alias);
    }

    public RDBMSManager getRDBMSManager() {
        return this.rdbmsMgr;
    }

    public SQLExpressionFactory getSQLExpressionFactory() {
        return this.rdbmsMgr.getSQLExpressionFactory();
    }

    public DatabaseAdapter getDatabaseAdapter() {
        return (DatabaseAdapter)this.rdbmsMgr.getDatastoreAdapter();
    }

    public void addExtension(String key, Object value) {
        this.invalidateStatement();
        if (this.extensions == null) {
            this.extensions = new HashMap();
        }
        this.extensions.put(key, value);
    }

    public Object getValueForExtension(String key) {
        if (this.extensions == null) {
            return this.extensions;
        }
        return this.extensions.get(key);
    }

    public void union(SQLStatement stmt) {
        this.invalidateStatement();
        if (this.unions == null) {
            this.unions = new ArrayList<SQLStatement>();
        }
        this.unions.add(stmt);
    }

    public void setParent(SQLStatement parentStmt) {
        HashMap<String, Object> parentExts;
        this.invalidateStatement();
        this.parent = parentStmt;
        if (parentStmt != null && (parentExts = parentStmt.extensions) != null) {
            Set<Map.Entry<String, Object>> entries = parentExts.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                this.addExtension(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setDistinct(boolean distinct) {
        this.invalidateStatement();
        this.distinct = distinct;
    }

    public int selectSQLExpression(SQLExpression expr, String alias) {
        if (expr == null) {
            throw new NucleusException("Expression to select is null");
        }
        this.invalidateStatement();
        String exprStr = expr.toSQL(1).toSQL(1);
        if (alias != null) {
            exprStr = exprStr + " AS " + alias;
        }
        return this.selectItem(exprStr);
    }

    public int[] select(SQLTable table, JavaTypeMapping mapping, String alias) {
        if (mapping == null) {
            throw new NucleusException("Mapping to select is null");
        }
        if (table == null) {
            table = this.primaryTable;
        }
        if (mapping.getDatastoreContainer() != table.getTable()) {
            throw new NucleusException("Table being selected from (\"" + table.getTable() + "\") is inconsistent with the column selected (\"" + mapping.getDatastoreContainer() + "\")");
        }
        this.invalidateStatement();
        DatastoreMapping[] mappings = mapping.getDataStoreMappings();
        int[] selected = new int[mappings.length];
        for (int i = 0; i < selected.length; ++i) {
            int position;
            DatastoreIdentifier colAlias = null;
            if (alias != null) {
                String name = alias;
                if (selected.length > 1) {
                    name = alias + "_" + i;
                }
                colAlias = this.rdbmsMgr.getIdentifierFactory().newDatastoreFieldIdentifier(name);
            }
            SQLColumn col = new SQLColumn(table, mappings[i].getDatastoreField(), colAlias);
            NucleusLogger.JDO.debug((Object)(">> SQLStatement.select field.col=" + col.toString() + " table=" + table));
            selected[i] = position = this.selectItem(col.toString());
        }
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.select(table, mapping, alias);
            }
        }
        return selected;
    }

    public int select(SQLTable table, DatastoreField column, String alias) {
        if (column == null) {
            throw new NucleusException("Column to select is null");
        }
        if (table == null) {
            table = this.primaryTable;
        }
        if (column.getDatastoreContainerObject() != table.getTable()) {
            throw new NucleusException("Table being selected from (\"" + table.getTable() + "\") is inconsistent with the column selected (\"" + column.getDatastoreContainerObject() + "\")");
        }
        this.invalidateStatement();
        DatastoreIdentifier colAlias = null;
        if (alias != null) {
            colAlias = this.rdbmsMgr.getIdentifierFactory().newDatastoreFieldIdentifier(alias);
        }
        SQLColumn col = new SQLColumn(table, column, colAlias);
        NucleusLogger.JDO.debug((Object)(">> SQLStatement.select col=" + col.toString() + " table=" + table));
        int position = this.selectItem(col.toString());
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.select(table, column, alias);
            }
        }
        return position;
    }

    private int selectItem(String item) {
        if (this.selects.contains(item)) {
            return this.selects.indexOf(item) + 1;
        }
        int numberSelected = this.selects.size();
        for (int i = 0; i < numberSelected; ++i) {
            String selectedItem = this.selects.get(i);
            if (selectedItem.startsWith(item + " ")) {
                return i + 1;
            }
            if (!item.startsWith(selectedItem + " ")) continue;
            this.selects.set(i, item);
            return i + 1;
        }
        this.selects.add(item);
        return this.selects.indexOf(item) + 1;
    }

    public void setUpdates(SQLExpression[] exprs) {
        this.invalidateStatement();
        this.updates = exprs;
    }

    public SQLTable getPrimaryTable() {
        return this.primaryTable;
    }

    public SQLTable getTable(String alias) {
        if (alias == this.primaryTable.alias.getIdentifier()) {
            return this.primaryTable;
        }
        if (this.tables != null) {
            return this.tables.get(alias);
        }
        return null;
    }

    public SQLTable getTable(DatastoreContainerObject table) {
        if (this.primaryTable.getTable() == table) {
            return this.primaryTable;
        }
        for (SQLTable tbl : this.tables.values()) {
            if (tbl.getTable() != table) continue;
            return tbl;
        }
        return null;
    }

    public int getNumberOfTables() {
        return this.tables != null ? this.tables.size() : -1;
    }

    public SQLTable innerJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, DatastoreContainerObject target, String targetAlias, JavaTypeMapping targetMapping, Object[] discrimValues) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap();
        }
        if (targetAlias == null) {
            targetAlias = this.generateTableAlias(target);
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newDatastoreContainerIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(target, targetId);
        this.join(1, sourceTable, sourceMapping, targetTbl, targetMapping, discrimValues);
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.innerJoin(sourceTable, sourceMapping, target, targetAlias, targetMapping, discrimValues);
            }
        }
        return targetTbl;
    }

    public SQLTable leftOuterJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, DatastoreContainerObject target, String targetAlias, JavaTypeMapping targetMapping, Object[] discrimValues) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap();
        }
        if (targetAlias == null) {
            targetAlias = this.generateTableAlias(target);
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newDatastoreContainerIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(target, targetId);
        this.join(2, sourceTable, sourceMapping, targetTbl, targetMapping, discrimValues);
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.leftOuterJoin(sourceTable, sourceMapping, target, targetAlias, targetMapping, discrimValues);
            }
        }
        return targetTbl;
    }

    public SQLTable rightOuterJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, DatastoreContainerObject target, String targetAlias, JavaTypeMapping targetMapping, Object[] discrimValues) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap();
        }
        if (targetAlias == null) {
            targetAlias = this.generateTableAlias(target);
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newDatastoreContainerIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(target, targetId);
        this.join(3, sourceTable, sourceMapping, targetTbl, targetMapping, discrimValues);
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.rightOuterJoin(sourceTable, sourceMapping, target, targetAlias, targetMapping, discrimValues);
            }
        }
        return targetTbl;
    }

    public SQLTable crossJoin(DatastoreContainerObject target, String targetAlias) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap();
        }
        if (targetAlias == null) {
            targetAlias = this.generateTableAlias(target);
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newDatastoreContainerIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(target, targetId);
        this.join(4, this.primaryTable, null, targetTbl, null, null);
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.crossJoin(target, targetAlias);
            }
        }
        return targetTbl;
    }

    protected void join(int joinType, SQLTable sourceTable, JavaTypeMapping sourceMapping, SQLTable targetTable, JavaTypeMapping targetMapping, Object[] discrimValues) {
        SQLJoin join;
        if (this.tables != null && this.tables.containsValue(targetTable)) {
            NucleusLogger.JDO.debug((Object)("Attempt to join to " + targetTable + " but join already exists"));
            return;
        }
        this.tables.put(targetTable.alias.getIdentifier(), targetTable);
        BooleanExpression joinCondition = null;
        if (sourceMapping != null && targetMapping != null) {
            if (sourceMapping.getNumberOfDatastoreFields() != targetMapping.getNumberOfDatastoreFields()) {
                throw new NucleusException("Cannot join from " + sourceMapping + " to " + targetMapping + " since they have different numbers of datastore columns!");
            }
            SQLExpressionFactory factory = this.rdbmsMgr.getSQLExpressionFactory();
            SQLExpression sourceExpr = factory.newExpression(this, sourceTable != null ? sourceTable : this.primaryTable, sourceMapping);
            SQLExpression targetExpr = factory.newExpression(this, targetTable, targetMapping);
            joinCondition = sourceExpr.eq(targetExpr);
            JavaTypeMapping discrimMapping = targetTable.getTable().getDiscriminatorMapping(false);
            if (discrimMapping != null && discrimValues != null) {
                SQLExpression discrimExpr = factory.newExpression(this, targetTable, discrimMapping);
                SQLExpression discrimCondition = null;
                for (int i = 0; i < discrimValues.length; ++i) {
                    SQLExpression discrimVal = factory.newLiteral(this, discrimMapping, discrimValues[i]);
                    BooleanExpression condition = discrimExpr.eq(discrimVal);
                    discrimCondition = discrimCondition == null ? condition : ((BooleanExpression)discrimCondition).ior(condition);
                }
                discrimCondition.encloseInParentheses();
                joinCondition = joinCondition.and(discrimCondition);
            }
        }
        if (this.rdbmsMgr.getDatastoreAdapter().supportsOption("ANSI_Join_Syntax")) {
            join = new SQLJoin(joinType, targetTable, joinCondition);
            if (this.joins == null) {
                this.joins = new ArrayList<SQLJoin>();
            }
            this.joins.add(join);
        } else {
            join = new SQLJoin(-1, targetTable, null);
            if (this.joins == null) {
                this.joins = new ArrayList<SQLJoin>();
            }
            this.joins.add(join);
            this.whereAnd(joinCondition, false);
        }
    }

    protected synchronized String generateTableAlias(DatastoreContainerObject tbl) {
        SQLTableNamer namer;
        String namingSchema = null;
        if (this.extensions != null) {
            namingSchema = (String)this.extensions.get("datanucleus.sqlTableNamingStrategy");
        }
        if (namingSchema == null) {
            namingSchema = "t-scheme";
        }
        if ((namer = tableNamerByName.get(namingSchema)) == null) {
            try {
                namer = (SQLTableNamer)this.rdbmsMgr.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_tablenamer", "name", namingSchema, "class", null, null);
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to find/instantiate SQL table namer " + namingSchema + " threw an exception", (Throwable)e);
            }
            tableNamerByName.put(namingSchema, namer);
        }
        return namer.getAliasForTable(this, tbl);
    }

    public void whereAnd(BooleanExpression expr, boolean applyToUnions) {
        this.invalidateStatement();
        this.where = this.where == null ? expr : this.where.and(expr);
        if (this.unions != null && applyToUnions) {
            for (SQLStatement stmt : this.unions) {
                stmt.whereAnd(expr, true);
            }
        }
    }

    public void whereOr(BooleanExpression expr, boolean applyToUnions) {
        this.invalidateStatement();
        this.where = this.where == null ? expr : this.where.ior(expr);
        if (this.unions != null && applyToUnions) {
            for (SQLStatement stmt : this.unions) {
                stmt.whereOr(expr, true);
            }
        }
    }

    public void addGroupingExpression(SQLExpression expr) {
        this.invalidateStatement();
        if (this.groupingExpressions == null) {
            this.groupingExpressions = new ArrayList<SQLExpression>();
        }
        this.groupingExpressions.add(expr);
        this.aggregated = true;
        if (this.unions != null) {
            Iterator<SQLStatement> i = this.unions.iterator();
            while (i.hasNext()) {
                i.next().addGroupingExpression(expr);
            }
        }
    }

    public void setHaving(BooleanExpression expr) {
        this.invalidateStatement();
        this.having = expr;
        this.aggregated = true;
    }

    public void setOrdering(SQLExpression[] exprs, boolean[] descending) {
        if (exprs.length != descending.length) {
            throw new NucleusException(LOCALISER.msg("052503", (Object)("" + exprs.length), (Object)("" + descending.length))).setFatal();
        }
        this.invalidateStatement();
        this.orderingExpressions = exprs;
        this.orderingDirections = descending;
    }

    public void setRange(long offset, long count) {
        this.invalidateStatement();
        this.rangeOffset = offset;
        this.rangeCount = count;
    }

    public SQLText getSelectStatement() {
        SQLText orderStmt;
        if (this.sql != null) {
            return this.sql;
        }
        DatabaseAdapter dba = this.getDatabaseAdapter();
        boolean lock = false;
        Boolean val = (Boolean)this.getValueForExtension("lock-for-update");
        if (val != null) {
            lock = val;
        }
        this.sql = new SQLText("SELECT ");
        if (this.distinct) {
            this.sql.append("DISTINCT ");
        }
        if (this.rangeOffset > -1L || this.rangeCount > -1L) {
            if (dba.getRangeByRowNumberColumn().length() > 0) {
                this.sql.append(dba.getRangeByRowNumberColumn() + " rn, ");
            } else {
                this.sql.append(dba.getRangeByLimitSelectClause(this.rangeOffset, this.rangeCount));
            }
        }
        this.addOrderingColumnsToSelect();
        Iterator<String> selectIter = this.selects.iterator();
        while (selectIter.hasNext()) {
            String selected = selectIter.next();
            this.sql.append(selected);
            if (!selectIter.hasNext()) continue;
            this.sql.append(',');
        }
        if ((this.rangeOffset > -1L || this.rangeCount > -1L) && dba.getRangeByRowNumberColumn().length() > 0) {
            this.sql.append(',').append(dba.getRangeByRowNumberColumn());
        }
        this.sql.append(" FROM ");
        this.sql.append(this.primaryTable.toString());
        if (this.joins != null) {
            for (SQLJoin join : this.joins) {
                if (dba.supportsOption("ANSI_Join_Syntax")) {
                    this.sql.append(" ");
                } else {
                    this.sql.append(",");
                }
                this.sql.append(join.toFromClause(dba, lock));
            }
        }
        if (this.where != null) {
            this.sql.append(" WHERE ").append(this.where.toSQL(0), 0);
        }
        if (this.groupingExpressions != null) {
            ArrayList<String> groupBy = new ArrayList<String>();
            for (SQLExpression expr : this.groupingExpressions) {
                String exprText = expr.toSQL(1).toSQL(1);
                if (groupBy.contains(exprText)) continue;
                groupBy.add(exprText);
            }
            if (groupBy.size() > 0 && this.aggregated) {
                this.sql.append(" GROUP BY ");
                for (int i = 0; i < groupBy.size(); ++i) {
                    if (i > 0) {
                        this.sql.append(',');
                    }
                    this.sql.append((String)groupBy.get(i));
                }
            }
        }
        if (this.having != null) {
            this.sql.append(" HAVING ").append(this.having.toSQL(1), 1);
        }
        if (this.unions != null) {
            if (!dba.supportsOption("Union_Syntax")) {
                throw new NucleusException(LOCALISER.msg("052504", (Object)"UNION")).setFatal();
            }
            if (dba.supportsOption("UseUnionAll")) {
                this.sql.append(" UNION ALL ");
            } else {
                this.sql.append(" UNION ");
            }
            for (SQLStatement stmt : this.unions) {
                SQLText unionSql = stmt.getSelectStatement();
                this.sql.append(unionSql, 0);
            }
        }
        if ((orderStmt = this.generateOrderingStatement()) != null) {
            this.sql.append(" ORDER BY ").append(orderStmt, 0);
        }
        if (this.rangeOffset > -1L || this.rangeCount > -1L) {
            this.sql.append(dba.getRangeByLimitWhereClause(this.rangeOffset, this.rangeCount));
        }
        if (lock && dba.supportsOption("LockWithSelectForUpdate")) {
            if (this.distinct && !dba.supportsOption("DistinctWithSelectForUpdate")) {
                NucleusLogger.QUERY.warn((Object)LOCALISER.msg("052502"));
            } else {
                this.sql.append(" FOR UPDATE");
            }
        }
        if ((this.rangeOffset > -1L || this.rangeCount > -1L) && dba.getRangeByRowNumberColumn().length() > 0) {
            SQLText innerQuery = this.sql;
            this.sql = new SQLText("SELECT ");
            selectIter = this.selects.iterator();
            while (selectIter.hasNext()) {
                String selectExpr = selectIter.next();
                this.sql.append("subq.");
                String selectedCol = selectExpr;
                int dotIndex = selectedCol.indexOf(".");
                if (dotIndex != -1) {
                    selectedCol = selectedCol.substring(dotIndex + 1);
                }
                this.sql.append(selectedCol);
                if (!selectIter.hasNext()) continue;
                this.sql.append(',');
            }
            this.sql.append(" FROM (");
            this.sql.append(innerQuery, 0);
            this.sql.append(") subq WHERE ");
            if (this.rangeOffset > -1L) {
                this.sql.append("subq.rn").append(">=").append("" + this.rangeOffset);
            }
            if (this.rangeCount > -1L) {
                if (this.rangeOffset > -1L) {
                    this.sql.append(" AND ");
                }
                this.sql.append("subq.rn").append("<").append("" + (this.rangeCount + this.rangeOffset));
            }
        }
        return this.sql;
    }

    protected SQLText generateOrderingStatement() {
        SQLText orderStmt;
        block8: {
            orderStmt = null;
            if (this.orderingExpressions == null || this.orderingExpressions.length <= 0) break block8;
            DatabaseAdapter dba = this.getDatabaseAdapter();
            if (dba.supportsOption("OrderByUsingSelectColumnIndex")) {
                orderStmt = new SQLText();
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    if (i > 0) {
                        orderStmt.append(',');
                    }
                    orderStmt.append(Integer.toString(this.orderingColumnIndexes[i]));
                    if (!this.orderingDirections[i]) continue;
                    orderStmt.append(" DESC");
                }
            } else {
                orderStmt = new SQLText();
                boolean needsSelect = dba.supportsOption("IncludeOrderByColumnsInSelect");
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    if (i > 0) {
                        orderStmt.append(',');
                    }
                    if (needsSelect && !this.aggregated) {
                        String orderExpr = "NUCORDER" + i;
                        orderStmt.append(orderExpr);
                    } else {
                        orderStmt.append(this.orderingExpressions[i].toSQL(1).toSQL(1));
                    }
                    if (!this.orderingDirections[i]) continue;
                    orderStmt.append(" DESC");
                }
            }
        }
        return orderStmt;
    }

    protected void addOrderingColumnsToSelect() {
        block6: {
            DatabaseAdapter dba;
            block7: {
                if (this.orderingExpressions == null) break block6;
                dba = this.getDatabaseAdapter();
                if (!dba.supportsOption("OrderByUsingSelectColumnIndex")) break block7;
                this.orderingColumnIndexes = new int[this.orderingExpressions.length];
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    this.selects.add(this.orderingExpressions[i].toSQL(1).toString());
                    this.orderingColumnIndexes[i] = this.selects.size();
                    Iterator<SQLStatement> iterator = this.unions.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().selectSQLExpression(this.orderingExpressions[i], null);
                    }
                }
                break block6;
            }
            if (!dba.supportsOption("IncludeOrderByColumnsInSelect")) break block6;
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                String orderExpr = "NUCORDER" + i;
                for (SQLStatement stmt : this.unions) {
                    if (this.aggregated) {
                        stmt.selectSQLExpression(this.orderingExpressions[i], null);
                        continue;
                    }
                    stmt.selectSQLExpression(this.orderingExpressions[i], orderExpr);
                }
                if (this.aggregated) {
                    this.selectSQLExpression(this.orderingExpressions[i], null);
                    continue;
                }
                this.selectSQLExpression(this.orderingExpressions[i], orderExpr);
            }
        }
    }

    protected void invalidateStatement() {
        this.sql = null;
    }
}

