/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.DiscriminatorIteratorStatement;
import org.datanucleus.store.rdbms.query.UnionIteratorStatement;
import org.datanucleus.store.rdbms.scostore.AbstractSetStore;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.util.ClassUtils;

public class MapValueSetStore
extends AbstractSetStore {
    private final MapStore mapStore;
    private final JavaTypeMapping keyMapping;
    private final String findKeyStmt;
    private DatastoreIdentifier valueIdentifier;

    public MapValueSetStore(MapTable mapTable, MapStore mapStore, ClassLoaderResolver clr) {
        super((StoreManager)mapTable.getStoreManager(), clr);
        this.containerTable = mapTable;
        this.mapStore = mapStore;
        this.setName = "values";
        this.ownerMapping = mapTable.getOwnerMapping();
        this.keyMapping = mapTable.getKeyMapping();
        this.elementMapping = mapTable.getValueMapping();
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        this.initialize(clr);
        this.findKeyStmt = this.getFindKeyStmt();
    }

    public MapValueSetStore(DatastoreClass valueTable, JavaTypeMapping ownerMapping, JavaTypeMapping valueMapping, MapStore mapStore, ClassLoaderResolver clr, AbstractMemberMetaData fmd) {
        super((StoreManager)valueTable.getStoreManager(), clr);
        this.containerTable = valueTable;
        this.setName = "values";
        this.ownerMemberMetaData = fmd;
        this.ownerMapping = ownerMapping;
        this.keyMapping = null;
        this.elementMapping = valueMapping;
        this.mapStore = mapStore;
        this.initialize(clr);
        this.clearStmt = null;
        this.findKeyStmt = null;
    }

    private void initialize(ClassLoaderResolver clr) {
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        Class element_class = clr.classForName(this.elementType);
        this.emd = ClassUtils.isReferenceType((Class)element_class) ? this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr) : this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        if (this.emd != null) {
            this.elementType = this.emd.getFullClassName();
            this.elementInfo = this.getElementInformationForClass();
        }
        this.valueIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(0, "VALUE");
    }

    private String getFindKeyStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ");
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        Class elementCls = clr.classForName(this.elementType);
        QueryExpression stmt = null;
        if (this.emd != null && this.emd.getDiscriminatorStrategy() != null && this.emd.getDiscriminatorStrategy() != DiscriminatorStrategy.NONE && this.containerTable instanceof DatastoreClass) {
            if (ClassUtils.isReferenceType((Class)clr.classForName(this.elementType))) {
                String[] clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int j = 0; j < clsNames.length; ++j) {
                    cls[j] = clr.classForName(clsNames[j]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, (StoreManager)this.storeMgr, true).getQueryStatement(null);
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{elementCls}, true, (StoreManager)this.storeMgr, true).getQueryStatement(null);
            }
            this.iterateUsingDiscriminator = true;
            DatastoreClass sourceTable = this.storeMgr.getDatastoreClass(this.elementType, clr);
            ScalarExpression sourceExpr = sourceTable.getIDMapping().newScalarExpression(stmt, stmt.getMainTableExpression());
            LogicSetExpression teTargetElement = stmt.newTableExpression(this.containerTable, this.valueIdentifier);
            ScalarExpression targetExpr = this.elementMapping.newScalarExpression(stmt, teTargetElement);
            stmt.innerJoin(sourceExpr, targetExpr, teTargetElement, true);
        } else {
            stmt = new UnionIteratorStatement(clr, elementCls, true, (StoreManager)this.storeMgr, elementCls, this.elementMapping, this.containerTable, false, null, true, false).getQueryStatement(null);
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        return stmt;
    }

    public boolean add(StateManager sm, Object element, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its value set");
    }

    public boolean addAll(StateManager sm, Collection elements, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its value set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(StateManager sm, Object element, int size, boolean allowDependentField) {
        if (this.findKeyStmt == null) {
            throw new UnsupportedOperationException("Cannot remove from an inverse map through its value set");
        }
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        Object key = null;
        boolean keyExists = false;
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, this.findKeyStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, this.findKeyStmt, ps);
                    try {
                        if (rs.next()) {
                            key = this.keyMapping.getObject(om, rs, Mappings.getParametersIndex(1, this.keyMapping));
                            keyExists = true;
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Request failed to check if set contains an element: " + this.findKeyStmt, (Throwable)e);
        }
        if (keyExists) {
            this.mapStore.remove(sm, key);
            return true;
        }
        return false;
    }

    public boolean removeAll(StateManager sm, Collection elements, int size) {
        throw new NucleusUserException("Cannot remove elements from a map through its value set");
    }

    public void clear(StateManager sm) {
        if (this.clearStmt == null) {
            throw new NucleusUserException("Cannot clear an inverse map through its value set");
        }
        super.clear(sm);
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass, DatastoreIdentifier candidateAlias) {
        throw new NucleusUserException("Cannot query sets obtained by Map.values()");
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier setRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar, boolean existsQuery) {
        throw new NucleusUserException("Cannot query sets obtained by Map.values()");
    }
}

