/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.SetStore;

public class MapEntrySetStore
extends BaseContainerStore
implements SetStore {
    protected DatastoreContainerObject setTable;
    protected MapStore mapStore;
    protected JavaTypeMapping keyMapping;
    protected JavaTypeMapping valueMapping;
    protected String keyType;
    protected String valueType;
    protected AbstractClassMetaData kmd;
    protected AbstractClassMetaData vmd;
    protected String iteratorStmt;
    protected String sizeStmt;
    protected ClassLoaderResolver clr;
    ResultObjectFactory rof = null;

    public MapEntrySetStore(MapTable mapTable, MapStore mapStore, ClassLoaderResolver clr) {
        super((StoreManager)mapTable.getStoreManager());
        this.setTable = mapTable;
        this.mapStore = mapStore;
        this.keyType = mapStore.getKeyType();
        this.valueType = mapStore.getValueType();
        this.ownerMapping = mapTable.getOwnerMapping();
        this.ownerMemberMetaData = mapTable.getOwnerFieldMetaData();
        this.keyMapping = mapTable.getKeyMapping();
        this.valueMapping = mapTable.getValueMapping();
        this.kmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.keyType, clr);
        this.vmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.valueType, clr);
        this.clr = clr;
    }

    public MapEntrySetStore(DatastoreContainerObject valueTable, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, JavaTypeMapping valueMapping, MapStore mapStore) {
        super((StoreManager)valueTable.getStoreManager());
        this.setTable = valueTable;
        this.mapStore = mapStore;
        this.keyType = mapStore.getKeyType();
        this.valueType = mapStore.getValueType();
        this.ownerMapping = ownerMapping;
        this.keyMapping = keyMapping;
        this.valueMapping = valueMapping;
    }

    public boolean hasOrderMapping() {
        return false;
    }

    public boolean updateEmbeddedElement(StateManager sm, Object element, int fieldNumber, Object value) {
        return false;
    }

    private String getSizeStmt() {
        if (this.sizeStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT COUNT(*) FROM ");
            stmt.append(this.setTable.toString());
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.keyMapping != null) {
                for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" IS NOT NULL");
                }
            }
            this.sizeStmt = stmt.toString();
        }
        return this.sizeStmt;
    }

    private String getIteratorStmt() {
        if (this.iteratorStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT ");
            if (this.keyMapping != null) {
                for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                    if (i > 0) {
                        stmt.append(",");
                    }
                    stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                }
            }
            if (this.valueMapping != null) {
                for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                }
            }
            stmt.append(" FROM ");
            stmt.append(this.setTable.toString());
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.keyMapping != null) {
                for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" IS NOT NULL");
                }
            }
            this.iteratorStmt = stmt.toString();
        }
        return this.iteratorStmt;
    }

    public String getElementType() {
        return EntryImpl.class.getName();
    }

    public JavaTypeMapping getOwnerMapping() {
        return this.ownerMapping;
    }

    protected boolean validateElementType(Object element) {
        return element instanceof Map.Entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator(StateManager sm) {
        SetIterator iter;
        String stmt = null;
        if (this.keyMapping != null && this.valueMapping != null) {
            stmt = this.getIteratorStmt();
        } else {
            QueryExpression expr = this.dba.newQueryStatement(this.setTable, null, this.clr);
            ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(expr, expr.getMainTableExpression());
            ScalarExpression ownerVal = this.ownerMapping.newLiteral(expr, sm.getObject());
            expr.andCondition(ownerExpr.eq(ownerVal), true);
            this.rof = this.newResultObjectFactory(sm, expr, true);
            stmt = expr.toStatementText(false).toString();
        }
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    if (this.keyMapping != null && this.valueMapping != null) {
                        int jdbcPosition = 1;
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        iter = new SetIterator(sm, rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Iteration request failed: " + stmt, (Throwable)e);
        }
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(StateManager sm) {
        int numRows;
        String stmt = this.getSizeStmt();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new NucleusDataStoreException("Size request returned no result row: " + stmt);
                        }
                        numRows = rs.getInt(1);
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Size request failed: " + stmt, (Throwable)e);
        }
        return numRows;
    }

    public void update(StateManager sm, Collection coll) {
        this.clear(sm);
        this.addAll(sm, coll, 0);
    }

    public boolean contains(StateManager sm, Object element) {
        if (!this.validateElementType(element)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)element;
        return this.mapStore.containsKey(sm, entry.getKey());
    }

    public boolean add(StateManager sm, Object element, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its entry set");
    }

    public boolean addAll(StateManager sm, Collection elements, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its entry set");
    }

    public boolean remove(StateManager sm, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementType(element)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)element;
        Object removed = this.mapStore.remove(sm, entry.getKey());
        return removed == null ? entry.getValue() == null : removed.equals(entry.getValue());
    }

    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        Iterator iter = elements.iterator();
        boolean modified = false;
        while (iter.hasNext()) {
            Object element = iter.next();
            Map.Entry entry = (Map.Entry)element;
            Object removed = this.mapStore.remove(sm, entry.getKey());
            modified = removed == null ? entry.getValue() == null : removed.equals(entry.getValue());
        }
        return modified;
    }

    public void clear(StateManager sm) {
        this.mapStore.clear(sm);
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression expr, boolean useFetchPlan) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass, DatastoreIdentifier candidateAlias) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression stmt, boolean ignoreCache, boolean useFetchPlan) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    public QueryExpression getExistsSubquery(QueryExpression stmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionTableAlias) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    public QueryExpression getSizeSubquery(QueryExpression stmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionTableAlias) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionTableAlias, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    private class EntryImpl
    implements Map.Entry {
        private final StateManager sm;
        private final Object key;
        private final Object value;

        public EntryImpl(StateManager sm, Object key, Object value) {
            this.sm = sm;
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return MapEntrySetStore.this.mapStore.put(this.sm, this.key, value);
        }
    }

    private class SetIterator
    implements Iterator {
        private final StateManager sm;
        private final ObjectManager om;
        private final Iterator delegate;
        private Map.Entry lastElement = null;

        public SetIterator(StateManager sm, ResultSet rs) throws SQLException {
            this.sm = sm;
            this.om = sm.getObjectManager();
            ArrayList<EntryImpl> results = new ArrayList<EntryImpl>();
            while (rs.next()) {
                int jdbcPosition = 1;
                Object key = null;
                Object value = null;
                int ownerFieldNum = -1;
                if (MapEntrySetStore.this.setTable instanceof JoinTable) {
                    ownerFieldNum = ((JoinTable)MapEntrySetStore.this.setTable).getOwnerFieldMetaData().getAbsoluteFieldNumber();
                }
                key = MapEntrySetStore.this.keyMapping instanceof EmbeddedKeyPCMapping || MapEntrySetStore.this.keyMapping instanceof SerialisedPCMapping || MapEntrySetStore.this.keyMapping instanceof SerialisedReferenceMapping ? MapEntrySetStore.this.keyMapping.getObject(this.om, rs, Mappings.getParametersIndex(jdbcPosition, MapEntrySetStore.this.keyMapping), sm, ownerFieldNum) : MapEntrySetStore.this.keyMapping.getObject(this.om, rs, Mappings.getParametersIndex(jdbcPosition, MapEntrySetStore.this.keyMapping));
                value = MapEntrySetStore.this.valueMapping instanceof EmbeddedValuePCMapping || MapEntrySetStore.this.valueMapping instanceof SerialisedPCMapping || MapEntrySetStore.this.valueMapping instanceof SerialisedReferenceMapping ? MapEntrySetStore.this.valueMapping.getObject(this.om, rs, Mappings.getParametersIndex(jdbcPosition, MapEntrySetStore.this.valueMapping), sm, ownerFieldNum) : MapEntrySetStore.this.valueMapping.getObject(this.om, rs, Mappings.getParametersIndex(jdbcPosition += MapEntrySetStore.this.keyMapping.getNumberOfDatastoreFields(), MapEntrySetStore.this.valueMapping));
                results.add(new EntryImpl(sm, key, value));
            }
            this.delegate = results.iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastElement = (Map.Entry)this.delegate.next();
            return this.lastElement;
        }

        public synchronized void remove() {
            if (this.lastElement == null) {
                throw new IllegalStateException("No entry to remove");
            }
            MapEntrySetStore.this.mapStore.remove(this.sm, this.lastElement.getKey());
            this.delegate.remove();
            this.lastElement = null;
        }
    }
}

