/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.sco.SCOMtoN;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.UnboundVariable;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.DiscriminatorIteratorStatement;
import org.datanucleus.store.rdbms.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.rdbms.query.UnionIteratorStatement;
import org.datanucleus.store.rdbms.scostore.AbstractSetStore;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JoinSetStore
extends AbstractSetStore {
    protected String locateStmt;
    protected String maxOrderColumnIdStmt;
    protected final boolean m2n;

    public JoinSetStore(AbstractMemberMetaData fmd, CollectionTable joinTable, ClassLoaderResolver clr) {
        super((StoreManager)joinTable.getStoreManager(), clr);
        this.containerTable = joinTable;
        this.setOwnerMemberMetaData(fmd);
        this.setName = "set";
        int relationType = this.ownerMemberMetaData.getRelationType(clr);
        this.m2n = relationType == 5;
        this.ownerMapping = joinTable.getOwnerMapping();
        this.elementMapping = joinTable.getElementMapping();
        this.orderMapping = joinTable.getOrderMapping();
        this.relationDiscriminatorMapping = joinTable.getRelationDiscriminatorMapping();
        this.relationDiscriminatorValue = joinTable.getRelationDiscriminatorValue();
        this.elementType = fmd.getCollection().getElementType();
        this.elementsAreEmbedded = joinTable.isEmbeddedElement();
        this.elementsAreSerialised = joinTable.isSerialisedElement();
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (ClassUtils.isReferenceType((Class)element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, 3, clr);
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
                this.elementInfo = this.emd != null ? (!this.elementsAreEmbedded ? this.getElementInformationForClass() : null) : null;
            }
        }
    }

    private String getMaxOrderColumnIdStmt() {
        if (this.maxOrderColumnIdStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT MAX(" + ((Object)this.orderMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() + ")");
            stmt.append(" FROM ");
            stmt.append(this.containerTable.toString());
            stmt.append(" WHERE ");
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(0)).getUpdateInputParameter());
            for (i = 1; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 1; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.maxOrderColumnIdStmt = stmt.toString();
        }
        return this.maxOrderColumnIdStmt;
    }

    private String getLocateStmt() {
        if (this.locateStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT 1 FROM ");
            stmt.append(this.containerTable.toString());
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append("=");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getInsertionInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                if (this.elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append("=");
                }
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getInsertionInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append("=");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getInsertionInputParameter());
                }
            }
            this.locateStmt = stmt.toString();
        }
        return this.locateStmt;
    }

    protected String getRemoveStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        stmt.append(((Object)this.ownerMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString());
        stmt.append(" = ");
        stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(0)).getUpdateInputParameter());
        for (i = 1; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            if (this.elementsAreSerialised) {
                stmt.append(" LIKE ");
            } else {
                stmt.append(" = ");
            }
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    protected String getRemoveAllStmt(StateManager ownerSm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        Iterator elementsIter = elements.iterator();
        boolean first = true;
        while (elementsIter.hasNext()) {
            int i;
            elementsIter.next();
            if (first) {
                stmt.append("(");
            } else {
                stmt.append(" OR (");
            }
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                if (this.elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append(" = ");
                }
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(")");
            first = false;
        }
        return stmt.toString();
    }

    public void update(StateManager sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        if (this.ownerMemberMetaData.getCollection().isSerializedElement() || this.ownerMemberMetaData.getCollection().isEmbeddedElement()) {
            this.clear(sm);
            this.addAll(sm, coll, 0);
            return;
        }
        Iterator elemIter = this.iterator(sm);
        HashSet existing = new HashSet();
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.size() != coll.size()) {
            for (Object elem : coll) {
                if (existing.contains(elem)) continue;
                this.add(sm, elem, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        String removeAllStmt = this.getRemoveAllStmt(sm, elements);
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, removeAllStmt, false);
                try {
                    int jdbcPosition = 1;
                    for (Object element : elements) {
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                        jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                        if (this.relationDiscriminatorMapping == null) continue;
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    int[] number = sqlControl.executeStatementUpdate(mconn, removeAllStmt, ps, true);
                    if (number[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new NucleusDataStoreException(LOCALISER.msg("056012", (Object)removeAllStmt), (Throwable)e);
        }
        if (this.ownerMemberMetaData.getCollection().isDependentElement()) {
            sm.getObjectManager().deleteObjects(elements.toArray());
        }
        return modified;
    }

    private boolean elementAlreadyContainsOwnerInMtoN(StateManager ownerSM, Object element) {
        AbstractMemberMetaData[] relatedMmds;
        ObjectManager om = ownerSM.getObjectManager();
        StateManager elementSM = om.findStateManager(element);
        Object elementSCO = elementSM.provideField((relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(om.getClassLoaderResolver()))[0].getAbsoluteFieldNumber());
        if (elementSCO instanceof SCOMtoN) {
            if (this.contains(ownerSM, element)) {
                NucleusLogger.DATASTORE.info((Object)LOCALISER.msg("056040", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
                return true;
            }
        } else if (this.locate(ownerSM, element)) {
            NucleusLogger.DATASTORE.info((Object)LOCALISER.msg("056040", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean locate(StateManager sm, Object element) {
        boolean exists = true;
        String stmt = this.getLocateStmt();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        if (!rs.next()) {
                            exists = false;
                        }
                    }
                    catch (SQLException sqle) {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new NucleusDataStoreException(LOCALISER.msg("RDBMS.SCO.LocateRequestFailed", (Object)stmt), (Throwable)e);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(StateManager sm, Object element, int size) {
        StateManager elementSM;
        this.validateElementForWriting(sm, element, null);
        if (this.ownerMemberMetaData.getRelationType(this.clr) == 4 && sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") && (elementSM = sm.getObjectManager().findStateManager(element)) != null) {
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.JDO.info((Object)LOCALISER.msg("056037", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), false);
            } else if (elementOwner != sm.getObject() && sm.getReferencedPC() == null) {
                throw new NucleusUserException(LOCALISER.msg("056038", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject()), (Object)StringUtils.toJVMIDString((Object)elementOwner)));
            }
        }
        boolean modified = false;
        boolean toBeInserted = true;
        if (this.m2n) {
            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
        }
        if (toBeInserted) {
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                try {
                    int[] returnCode;
                    int orderID = -1;
                    if (this.orderMapping != null) {
                        orderID = this.getNextIDForOrderColumn(sm);
                    }
                    if ((returnCode = this.internalAdd(sm, element, mconn, false, orderID, true))[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                NucleusLogger.DATASTORE.error((Object)e);
                String msg = LOCALISER.msg("056009", (Object)this.getAddStmt());
                NucleusLogger.DATASTORE.error((Object)msg);
                throw new NucleusDataStoreException(msg, (Throwable)e);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
        boolean batched = elements.size() > 1;
        for (Object element : elements) {
            StateManager elementSM;
            this.validateElementForWriting(sm, element, null);
            if (this.ownerMemberMetaData.getRelationType(this.clr) != 4 || !sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") || (elementSM = sm.getObjectManager().findStateManager(element)) == null) continue;
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.JDO.info((Object)LOCALISER.msg("056037", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), false);
                continue;
            }
            if (elementOwner == sm.getObject() || sm.getReferencedPC() != null) continue;
            throw new NucleusUserException(LOCALISER.msg("056038", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject()), (Object)StringUtils.toJVMIDString((Object)elementOwner)));
        }
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            sqlControl.processStatementsForConnection(mconn);
            try {
                int nextOrderID = 0;
                if (this.orderMapping != null) {
                    nextOrderID = this.getNextIDForOrderColumn(sm);
                }
                Iterator iter = elements.iterator();
                Object element = null;
                while (iter.hasNext()) {
                    element = iter.next();
                    try {
                        int[] rc = this.internalAdd(sm, element, mconn, batched, nextOrderID, !batched || batched && !iter.hasNext());
                        if (rc != null) {
                            for (int i = 0; i < rc.length; ++i) {
                                if (rc[i] <= 0) continue;
                                modified = true;
                            }
                        }
                        ++nextOrderID;
                    }
                    catch (SQLException sqe) {
                        sqe.printStackTrace();
                        exceptions.add(sqe);
                        NucleusLogger.DATASTORE.error((Object)sqe);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            exceptions.add(e);
            NucleusLogger.DATASTORE.error((Object)e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("056009", (Object)this.getAddStmt());
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), sm.getObject());
        }
        return modified;
    }

    private int[] internalAdd(StateManager sm, Object element, ManagedConnection conn, boolean batched, int orderId, boolean executeNow) throws SQLException {
        boolean toBeInserted = true;
        if (this.m2n) {
            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
        }
        if (toBeInserted) {
            String addStmt = this.getAddStmt();
            boolean notYetFlushedError = false;
            ObjectManager om = sm.getObjectManager();
            SQLController sqlControl = this.storeMgr.getSQLController();
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, batched);
            try {
                int jdbcPosition = 1;
                jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                if (this.orderMapping != null) {
                    jdbcPosition = this.populateOrderInStatement(om, ps, orderId, jdbcPosition);
                }
                if (this.relationDiscriminatorMapping != null) {
                    jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                }
                int[] nArray = sqlControl.executeStatementUpdate(conn, addStmt, ps, executeNow);
                return nArray;
            }
            catch (NotYetFlushedException nfe) {
                notYetFlushedError = true;
                throw nfe;
            }
            finally {
                if (notYetFlushedError) {
                    sqlControl.abortStatementForConnection(conn, ps);
                } else {
                    sqlControl.closeStatement(conn, ps);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextIDForOrderColumn(StateManager sm) {
        int nextID;
        ObjectManager om = sm.getObjectManager();
        String stmt = this.getMaxOrderColumnIdStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        nextID = !rs.next() ? 1 : rs.getInt(1) + 1;
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056020", (Object)stmt), (Throwable)e);
        }
        return nextID;
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        QueryExpression stmt = null;
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            stmt = this.dba.newQueryStatement(this.containerTable, null, clr);
            stmt = this.dba.newQueryStatement(this.containerTable, null, clr);
            stmt.select(this.elementMapping);
        } else if (this.elementMapping instanceof ReferenceMapping) {
            stmt = this.dba.newQueryStatement(this.containerTable, null, clr);
        } else if (this.elementInfo != null) {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                int elementNo = i;
                Class elementCls = clr.classForName(this.elementInfo[elementNo].getClassName());
                QueryExpression elementStmt = null;
                if (this.elementInfo[elementNo].getDiscriminatorStrategy() != null && this.elementInfo[elementNo].getDiscriminatorStrategy() != DiscriminatorStrategy.NONE) {
                    if (ClassUtils.isReferenceType((Class)clr.classForName(this.ownerMemberMetaData.getCollection().getElementType()))) {
                        String[] clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.ownerMemberMetaData.getCollection().getElementType(), clr);
                        Class[] cls = new Class[clsNames.length];
                        for (int j = 0; j < clsNames.length; ++j) {
                            cls[j] = clr.classForName(clsNames[j]);
                        }
                        elementStmt = new DiscriminatorIteratorStatement(clr, cls, true, (StoreManager)this.storeMgr, true, this.allowsNull, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement(null);
                    } else {
                        elementStmt = new DiscriminatorIteratorStatement(clr, new Class[]{elementCls}, true, (StoreManager)this.storeMgr, true, this.allowsNull, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement(null);
                    }
                    this.iterateUsingDiscriminator = true;
                } else {
                    elementStmt = new UnionIteratorStatement(clr, elementCls, true, (StoreManager)this.storeMgr, elementCls, this.elementMapping, this.containerTable, false, Boolean.TRUE, true, this.allowsNull).getQueryStatement(null);
                }
                if (stmt == null) {
                    stmt = elementStmt;
                    continue;
                }
                stmt.union(elementStmt);
            }
        } else {
            throw new NucleusUserException("Attempt to get iterator for Set when insufficient information is available to perform the operation.");
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        if (this.orderMapping != null) {
            ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
            boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
            exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression()).getExpressionList().toArray();
            stmt.setOrdering(exprIndex, descendingOrder);
        }
        return stmt;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass, DatastoreIdentifier candidateAlias) {
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            throw new NucleusUserException(LOCALISER.msg("056021"));
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreIdentifier setTableAlias = this.storeMgr.getIdentifierFactory().newIdentifier(0, this.setName);
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, setTableAlias, clr);
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(setTableAlias));
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (!clr.isAssignableFrom(this.elementType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, candidateClass);
        }
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(candidateClass)) {
            stmt.select(setTableAlias, this.elementMapping);
        } else {
            DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, clr);
            DatastoreIdentifier elementTblAlias = this.storeMgr.getIdentifierFactory().newIdentifier(0, "SET_ELEMENTS");
            LogicSetExpression elementTblExpr = stmt.newTableExpression(candidateTable, elementTblAlias);
            JavaTypeMapping elementTableID = candidateTable.getIDMapping();
            ScalarExpression elmSetExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setTableAlias));
            ScalarExpression elmExpr = elementTableID.newScalarExpression(stmt, elementTblExpr);
            stmt.innerJoin(elmExpr, elmSetExpr, elementTblExpr, true, true);
            stmt.selectScalarExpression(elementTableID.newScalarExpression(stmt, elementTblExpr));
        }
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTblExpr, DatastoreIdentifier setTableAlias, Class filteredElementType, ScalarExpression elementExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        if (!existsQuery) {
            LogicSetExpression ownTblExpr = stmt.newTableExpression(this.containerTable, setTableAlias);
            if (!parentStmt.hasCrossJoin(ownTblExpr) && !stmt.getMainTableExpression().equals(ownTblExpr)) {
                stmt.crossJoin(ownTblExpr, true);
            }
            ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTblExpr);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(setTableAlias));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        }
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredElementType.getName())) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setTableAlias));
        }
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setTableAlias));
        }
        DatastoreClass elementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), clr);
        DatastoreClass joiningClass = elementExpr.getLogicSetExpression() == null ? elementTable : (DatastoreClass)elementExpr.getLogicSetExpression().getMainTable();
        JavaTypeMapping elementTableID = joiningClass.getIDMapping();
        LogicSetExpression elmTblExpr = stmt.getTableExpression(elementTableAlias);
        if (elmTblExpr == null) {
            if (!(elementExpr instanceof UnboundVariable) && parentStmt != stmt) {
                elmTblExpr = parentStmt.getTableExpression(elementTableAlias);
            }
            if (elmTblExpr == null) {
                elmTblExpr = stmt.newTableExpression(elementTable, elementTableAlias);
            }
        }
        if (!parentStmt.getMainTableExpression().equals(elmTblExpr) && !parentStmt.hasCrossJoin(elmTblExpr)) {
            stmt.crossJoin(elmTblExpr, true);
        }
        ScalarExpression elmSetExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setTableAlias));
        if (elementExpr.getLogicSetExpression() != null && !elementTable.equals(elementExpr.getLogicSetExpression().getMainTable())) {
            if (existsQuery) {
                stmt.andCondition(elmSetExpr.eq(elementExpr), true);
                return elmSetExpr;
            }
            return elmSetExpr;
        }
        if (existsQuery) {
            ScalarExpression elementIdExpr = elementTableID.newScalarExpression(stmt, elmTblExpr);
            stmt.andCondition(elmSetExpr.eq(elementIdExpr), true);
            return elementIdExpr;
        }
        return elmSetExpr;
    }
}

