/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.util.Localiser;

abstract class BaseContainerStore {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    protected RDBMSManager storeMgr;
    protected DatastoreAdapter dba;
    protected JavaTypeMapping ownerMapping;
    protected AbstractMemberMetaData ownerMemberMetaData;
    protected boolean allowsNull = false;

    protected BaseContainerStore(StoreManager storeMgr) {
        this.storeMgr = (RDBMSManager)storeMgr;
        this.dba = this.storeMgr.getDatastoreAdapter();
    }

    protected void setOwnerMemberMetaData(AbstractMemberMetaData mmd) {
        this.ownerMemberMetaData = mmd;
        if (this.ownerMemberMetaData.hasExtension("allow-nulls") && this.ownerMemberMetaData.getValueForExtension("allow-nulls").equalsIgnoreCase("true")) {
            this.allowsNull = true;
        }
    }

    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    public JavaTypeMapping getOwnerMapping() {
        return this.ownerMapping;
    }

    protected boolean isEmbeddedMapping(JavaTypeMapping mapping) {
        return !InterfaceMapping.class.isAssignableFrom(mapping.getClass()) && !OIDMapping.class.isAssignableFrom(mapping.getClass());
    }

    protected int populateOwnerInStatement(StateManager sm, ObjectManager om, PreparedStatement ps, int jdbcPosition) {
        if (!((RDBMSMapping)this.ownerMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        if (this.ownerMemberMetaData != null) {
            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), sm.getObject(), sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
        } else {
            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), sm.getObject());
        }
        return jdbcPosition + this.ownerMapping.getNumberOfDatastoreFields();
    }

    protected StateManager getStateManagerForEmbeddedPCObject(StateManager sm, Object obj, JoinTable table) {
        ObjectManager om = sm.getObjectManager();
        StateManager objSM = om.findStateManager(obj);
        if (objSM == null) {
            objSM = StateManagerFactory.newStateManagerForEmbedded((ObjectManager)om, (Object)obj, (boolean)false);
            AbstractMemberMetaData ownerFmd = table.getOwnerFieldMetaData();
            objSM.addEmbeddedOwner(sm, ownerFmd.getAbsoluteFieldNumber());
        }
        return objSM;
    }

    protected boolean allowsBatching() {
        return ((RDBMSAdapter)this.dba).supportsOption("StatementBatching") && this.storeMgr.getOMFContext().getPersistenceConfiguration().getIntProperty("datanucleus.rdbms.statementBatchLimit") != 0;
    }
}

