/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.ArrayStoreQueryable;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.scostore.ArrayStore;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractArrayStore
extends ElementContainerStore
implements ArrayStore,
ArrayStoreQueryable {
    protected AbstractArrayStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    public List getArray(StateManager ownerSM) {
        Iterator iter = this.iterator(ownerSM);
        ArrayList elements = new ArrayList();
        while (iter.hasNext()) {
            Object obj = iter.next();
            elements.add(obj);
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        HashSet dependentElements = null;
        if (this.ownerMemberMetaData.getArray().isDependentElement()) {
            dependentElements = new HashSet();
            Iterator iter = this.iterator(ownerSM);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        String clearStmt = this.getClearStmt();
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    sqlControl.executeStatementUpdate(mconn, clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)clearStmt), (Throwable)e);
        }
        if (dependentElements != null && dependentElements.size() > 0) {
            ownerSM.getObjectManager().deleteObjects(dependentElements.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(StateManager ownerSM, Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return true;
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.validateElementForWriting(ownerSM, obj, null);
        }
        boolean modified = false;
        ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
        boolean batched = this.allowsBatching() && length > 1;
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            sqlControl.processStatementsForConnection(mconn);
            try {
                Object element = null;
                for (int i = 0; i < length; ++i) {
                    element = Array.get(array, i);
                    try {
                        int[] rc = this.internalAdd(ownerSM, element, mconn, batched, i, i == length - 1);
                        if (rc == null) continue;
                        for (int j = 0; j < rc.length; ++j) {
                            if (rc[j] <= 0) continue;
                            modified = true;
                        }
                        continue;
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                        exceptions.add(sqle);
                        NucleusLogger.DATASTORE.error((Object)sqle);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            exceptions.add(e);
            NucleusLogger.DATASTORE.error((Object)e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("056009", (Object)this.getAddStmt());
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), ownerSM.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(StateManager sm, Object element, int position) {
        this.validateElementForWriting(sm, element, null);
        boolean modified = false;
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                int[] returnCode = this.internalAdd(sm, element, mconn, false, position, true);
                if (returnCode[0] > 0) {
                    modified = true;
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)this.getAddStmt()), (Throwable)e);
        }
        return modified;
    }

    protected int[] internalAdd(StateManager sm, Object element, ManagedConnection conn, boolean batched, int orderId, boolean executeNow) throws SQLException {
        ObjectManager om = sm.getObjectManager();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String addStmt = this.getAddStmt();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, false);
        boolean notYetFlushedError = false;
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
            jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
            jdbcPosition = this.populateOrderInStatement(om, ps, orderId, jdbcPosition);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
            }
            int[] nArray = sqlControl.executeStatementUpdate(conn, addStmt, ps, executeNow);
            return nArray;
        }
        catch (NotYetFlushedException nfe) {
            notYetFlushedError = true;
            throw nfe;
        }
        finally {
            if (notYetFlushedError) {
                sqlControl.abortStatementForConnection(conn, ps);
            } else {
                sqlControl.closeStatement(conn, ps);
            }
        }
    }

    protected abstract QueryExpression getIteratorStatement(StateManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator(StateManager ownerSM) {
        ArrayStoreIterator iter;
        QueryExpression stmt = this.getIteratorStatement(ownerSM);
        if (stmt == null) {
            throw new NucleusException(LOCALISER.msg("056005")).setFatal();
        }
        ResultObjectFactory rof = this.newResultObjectFactory(ownerSM, stmt, false, true);
        ObjectManager om = ownerSM.getObjectManager();
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        String statement = this.storeMgr.getStatementTextForQuery(stmt, useUpdateLock);
        if (statement == null) {
            throw new NucleusException(LOCALISER.msg("056005")).setFatal();
        }
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = this.storeMgr.getStatementForQuery(stmt, om, mconn, useUpdateLock, null, null);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                    try {
                        iter = new ArrayStoreIterator(ownerSM, rs, rof);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056006", (Object)statement), (Throwable)e);
        }
        return iter;
    }

    public QueryExpression getExistsSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier arrayTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, arrayTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(arrayTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        stmt.select(arrayTableAlias, this.elementMapping);
        return stmt;
    }

    public QueryExpression getSizeSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier arrayTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, arrayTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(arrayTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        JavaTypeMapping m = this.dba.getMapping(String.class, this.storeMgr);
        StringLiteral lit = (StringLiteral)m.newLiteral(stmt, "COUNT(*)");
        lit.generateStatementWithoutQuotes();
        stmt.selectScalarExpression(lit);
        return stmt;
    }

    private class ArrayStoreIterator
    implements Iterator {
        private final ObjectManager om;
        private final Iterator delegate;
        private Object lastElement = null;

        public ArrayStoreIterator(StateManager sm, ResultSet rs, ResultObjectFactory rof) throws SQLException {
            this.om = sm.getObjectManager();
            ArrayList<Object> results = new ArrayList<Object>();
            if (rs != null) {
                while (rs.next()) {
                    Object nextElement;
                    int i;
                    int[] param;
                    if (AbstractArrayStore.this.elementsAreEmbedded || AbstractArrayStore.this.elementsAreSerialised) {
                        param = new int[AbstractArrayStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        if (AbstractArrayStore.this.elementMapping instanceof SerialisedPCMapping || AbstractArrayStore.this.elementMapping instanceof SerialisedReferenceMapping || AbstractArrayStore.this.elementMapping instanceof EmbeddedElementPCMapping) {
                            int ownerFieldNumber = -1;
                            if (AbstractArrayStore.this.containerTable != null) {
                                ownerFieldNumber = ((JoinTable)AbstractArrayStore.this.containerTable).getOwnerFieldMetaData().getAbsoluteFieldNumber();
                            }
                            nextElement = AbstractArrayStore.this.elementMapping.getObject(this.om, rs, param, sm, ownerFieldNumber);
                        } else {
                            nextElement = AbstractArrayStore.this.elementMapping.getObject(this.om, rs, param);
                        }
                    } else if (AbstractArrayStore.this.elementMapping instanceof ReferenceMapping) {
                        param = new int[AbstractArrayStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        nextElement = AbstractArrayStore.this.elementMapping.getObject(this.om, rs, param);
                    } else {
                        nextElement = rof.getObject(this.om, (Object)rs);
                    }
                    results.add(nextElement);
                }
            }
            this.delegate = results.iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastElement = this.delegate.next();
            return this.lastElement;
        }

        public synchronized void remove() {
        }
    }
}

