/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.schema.ForeignKeyInfo;
import org.datanucleus.store.rdbms.schema.IndexInfo;
import org.datanucleus.store.rdbms.schema.JDBCTypeInfo;
import org.datanucleus.store.rdbms.schema.PrimaryKeyInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.RDBMSSchemaInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTableFKInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTableIndexInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTableInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTablePKInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTypesInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sqlidentifier.SQLIdentifier;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaData;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSSchemaHandler
implements StoreSchemaHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    protected final long COLUMN_INFO_EXPIRATION_MS = 300000L;
    protected final RDBMSManager storeMgr;
    protected Map<String, StoreSchemaData> schemaDataByName = new HashMap<String, StoreSchemaData>();

    public RDBMSSchemaHandler(RDBMSManager storeMgr) {
        this.storeMgr = storeMgr;
    }

    public void clear() {
        this.schemaDataByName.clear();
    }

    public void createSchema(Object connection, String schemaName) {
        throw new NucleusUserException("DataNucleus doesnt currently support creation of schemas for RDBMS");
    }

    public void deleteSchema(Object connection, String schemaName) {
        throw new NucleusUserException("DataNucleus doesnt currently support deletion of schemas for RDBMS");
    }

    public StoreSchemaData getSchemaData(Object connection, String name, Object[] values) {
        if (values == null) {
            if (name.equalsIgnoreCase("types")) {
                Object info = this.schemaDataByName.get("types");
                if (info == null) {
                    info = this.getRDBMSTypesInfo((Connection)connection);
                }
                return info;
            }
            if (name.equalsIgnoreCase("tables")) {
                StoreSchemaData info = this.schemaDataByName.get("tables");
                if (info == null) {
                    // empty if block
                }
                return info;
            }
            throw new NucleusException("Attempt to get schema information for component " + name + " but this is not supported by RDBMSSchemaHandler");
        }
        if (values.length == 1) {
            if (name.equalsIgnoreCase("foreign-keys") && values[0] instanceof Table) {
                return this.getRDBMSTableFKInfoForTable((Connection)connection, (Table)values[0]);
            }
            if (name.equalsIgnoreCase("primary-keys") && values[0] instanceof Table) {
                return this.getRDBMSTablePKInfoForTable((Connection)connection, (Table)values[0]);
            }
            if (name.equalsIgnoreCase("indices") && values[0] instanceof Table) {
                return this.getRDBMSTableIndexInfoForTable((Connection)connection, (Table)values[0]);
            }
            if (name.equalsIgnoreCase("columns") && values[0] instanceof Table) {
                return this.getRDBMSTableInfoForTable((Connection)connection, (Table)values[0]);
            }
            return this.getSchemaData(connection, name, null);
        }
        if (values.length == 2) {
            if (name.equalsIgnoreCase("tables")) {
                return this.getRDBMSSchemaInfoForCatalogSchema((Connection)connection, (String)values[0], (String)values[1]);
            }
            if (name.equalsIgnoreCase("column") && values[0] instanceof Table && values[1] instanceof String) {
                return this.getRDBMSColumnInfoForColumn((Connection)connection, (Table)values[0], (String)values[1]);
            }
            return this.getSchemaData(connection, name, null);
        }
        if (values.length == 3) {
            if (name.equalsIgnoreCase("columns") && values[0] instanceof String && values[1] instanceof String && values[2] instanceof String) {
                return this.getRDBMSTableInfoForTable((Connection)connection, (String)values[0], (String)values[1], (String)values[2]);
            }
            if (name.equalsIgnoreCase("indices") && values[0] instanceof String && values[1] instanceof String && values[2] instanceof String) {
                return this.getRDBMSTableIndexInfoForTable((Connection)connection, (String)values[0], (String)values[1], (String)values[2]);
            }
            if (name.equalsIgnoreCase("primary-keys") && values[0] instanceof String && values[1] instanceof String && values[2] instanceof String) {
                return this.getRDBMSTablePKInfoForTable((Connection)connection, (String)values[0], (String)values[1], (String)values[2]);
            }
            if (name.equalsIgnoreCase("foreign-keys") && values[0] instanceof String && values[1] instanceof String && values[2] instanceof String) {
                return this.getRDBMSTableFKInfoForTable((Connection)connection, (String)values[0], (String)values[1], (String)values[2]);
            }
        }
        throw new NucleusException("Attempt to get schema information for component " + name + " but this is not supported by RDBMSSchemaHandler");
    }

    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTableType(Connection conn, Table table) throws SQLException {
        String tableType = null;
        RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
        String[] c = RDBMSSchemaHandler.splitTableIdentifierName(dba.getCatalogSeparator(), table.getIdentifier().getIdentifier());
        String catalogName = table.getCatalogName();
        String schemaName = table.getSchemaName();
        String tableName = table.getIdentifier().getIdentifier();
        if (c[0] != null) {
            catalogName = c[0];
        }
        if (c[1] != null) {
            schemaName = c[1];
        }
        if (c[2] != null) {
            tableName = c[2];
        }
        catalogName = this.getIdentifierForUseWithDatabaseMetaData(catalogName);
        schemaName = this.getIdentifierForUseWithDatabaseMetaData(schemaName);
        tableName = this.getIdentifierForUseWithDatabaseMetaData(tableName);
        try {
            ResultSet rs = conn.getMetaData().getTables(catalogName, schemaName, tableName, null);
            try {
                boolean insensitive = this.identifiersCaseInsensitive();
                while (rs.next()) {
                    if ((!insensitive || !tableName.equalsIgnoreCase(rs.getString(3))) && (insensitive || !tableName.equals(rs.getString(3)))) continue;
                    tableType = rs.getString(4).toUpperCase();
                    break;
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException("Exception thrown finding table type using DatabaseMetaData.getTables()", (Throwable)sqle);
        }
        return tableType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RDBMSTypesInfo getRDBMSTypesInfo(Connection conn) {
        RDBMSTypesInfo info = new RDBMSTypesInfo();
        try {
            if (conn == null) {
                return null;
            }
            DatabaseMetaData dmd = conn.getMetaData();
            ResultSet rs = dmd.getTypeInfo();
            try {
                DatabaseAdapter dba = (DatabaseAdapter)this.storeMgr.getDatastoreAdapter();
                while (rs.next()) {
                    SQLTypeInfo sqlType = dba.newSQLTypeInfo(rs);
                    if (sqlType == null) continue;
                    String key = "" + sqlType.getDataType();
                    JDBCTypeInfo jdbcType = (JDBCTypeInfo)info.getChild(key);
                    if (jdbcType == null) {
                        jdbcType = new JDBCTypeInfo(sqlType.getDataType());
                        jdbcType.addChild(sqlType);
                        info.addChild((StoreSchemaData)jdbcType);
                        continue;
                    }
                    jdbcType.addChild(sqlType);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException("Exception thrown retrieving type information from datastore", (Throwable)sqle);
        }
        this.schemaDataByName.put("types", (StoreSchemaData)info);
        return info;
    }

    protected RDBMSTableFKInfo getRDBMSTableFKInfoForTable(Connection conn, Table table) {
        RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
        String[] c = RDBMSSchemaHandler.splitTableIdentifierName(dba.getCatalogSeparator(), table.getIdentifier().getIdentifier());
        String catalogName = table.getCatalogName();
        String schemaName = table.getSchemaName();
        String tableName = table.getIdentifier().getIdentifier();
        if (c[0] != null) {
            catalogName = c[0];
        }
        if (c[1] != null) {
            schemaName = c[1];
        }
        if (c[2] != null) {
            tableName = c[2];
        }
        catalogName = this.getIdentifierForUseWithDatabaseMetaData(catalogName);
        schemaName = this.getIdentifierForUseWithDatabaseMetaData(schemaName);
        tableName = this.getIdentifierForUseWithDatabaseMetaData(tableName);
        return this.getRDBMSTableFKInfoForTable(conn, catalogName, schemaName, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RDBMSTableFKInfo getRDBMSTableFKInfoForTable(Connection conn, String catalogName, String schemaName, String tableName) {
        RDBMSTableFKInfo info = new RDBMSTableFKInfo(catalogName, schemaName, tableName);
        RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
        try {
            ResultSet rs = conn.getMetaData().getImportedKeys(catalogName, schemaName, tableName);
            try {
                while (rs.next()) {
                    ForeignKeyInfo fki = dba.newFKInfo(rs);
                    if (info.getChildren().contains(fki)) continue;
                    info.addChild(fki);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException("Exception thrown while querying foreign keys for table=" + tableName, (Throwable)sqle);
        }
        return info;
    }

    protected RDBMSTablePKInfo getRDBMSTablePKInfoForTable(Connection conn, Table table) {
        RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
        String[] c = RDBMSSchemaHandler.splitTableIdentifierName(dba.getCatalogSeparator(), table.getIdentifier().getIdentifier());
        String catalogName = table.getCatalogName();
        String schemaName = table.getSchemaName();
        String tableName = table.getIdentifier().getIdentifier();
        if (c[0] != null) {
            catalogName = c[0];
        }
        if (c[1] != null) {
            schemaName = c[1];
        }
        if (c[2] != null) {
            tableName = c[2];
        }
        catalogName = this.getIdentifierForUseWithDatabaseMetaData(catalogName);
        schemaName = this.getIdentifierForUseWithDatabaseMetaData(schemaName);
        tableName = this.getIdentifierForUseWithDatabaseMetaData(tableName);
        return this.getRDBMSTablePKInfoForTable(conn, catalogName, schemaName, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RDBMSTablePKInfo getRDBMSTablePKInfoForTable(Connection conn, String catalogName, String schemaName, String tableName) {
        RDBMSTablePKInfo info = new RDBMSTablePKInfo(catalogName, schemaName, tableName);
        try {
            ResultSet rs = conn.getMetaData().getPrimaryKeys(catalogName, schemaName, tableName);
            try {
                while (rs.next()) {
                    PrimaryKeyInfo pki = new PrimaryKeyInfo(rs);
                    if (info.getChildren().contains(pki)) continue;
                    info.addChild(pki);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException("Exception thrown while querying primary keys for table=" + tableName, (Throwable)sqle);
        }
        return info;
    }

    protected RDBMSTableIndexInfo getRDBMSTableIndexInfoForTable(Connection conn, Table table) {
        RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
        String[] c = RDBMSSchemaHandler.splitTableIdentifierName(dba.getCatalogSeparator(), table.getIdentifier().getIdentifier());
        String catalogName = table.getCatalogName();
        String schemaName = table.getSchemaName();
        String tableName = table.getIdentifier().getIdentifier();
        if (c[0] != null) {
            catalogName = c[0];
        }
        if (c[1] != null) {
            schemaName = c[1];
        }
        if (c[2] != null) {
            tableName = c[2];
        }
        catalogName = this.getIdentifierForUseWithDatabaseMetaData(catalogName);
        schemaName = this.getIdentifierForUseWithDatabaseMetaData(schemaName);
        tableName = this.getIdentifierForUseWithDatabaseMetaData(tableName);
        return this.getRDBMSTableIndexInfoForTable(conn, catalogName, schemaName, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RDBMSTableIndexInfo getRDBMSTableIndexInfoForTable(Connection conn, String catalogName, String schemaName, String tableName) {
        RDBMSTableIndexInfo info = new RDBMSTableIndexInfo(catalogName, schemaName, tableName);
        RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
        try {
            ResultSet rs;
            String schemaNameTmp = schemaName;
            if (schemaName == null && this.storeMgr.getSchemaName() != null) {
                schemaNameTmp = this.storeMgr.getSchemaName();
                schemaNameTmp = this.getIdentifierForUseWithDatabaseMetaData(schemaNameTmp);
            }
            if ((rs = dba.getExistingIndexes(conn, catalogName, schemaNameTmp, tableName)) == null) {
                rs = conn.getMetaData().getIndexInfo(catalogName, schemaName, tableName, false, true);
            }
            try {
                while (rs.next()) {
                    IndexInfo idxInfo = new IndexInfo(rs);
                    if (info.getChildren().contains(idxInfo)) continue;
                    info.addChild(idxInfo);
                }
            }
            finally {
                if (rs != null) {
                    Statement st = rs.getStatement();
                    rs.close();
                    if (st != null) {
                        st.close();
                    }
                }
            }
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException("Exception thrown while querying indices for table=" + tableName, (Throwable)sqle);
        }
        return info;
    }

    protected RDBMSSchemaInfo getRDBMSSchemaInfoForCatalogSchema(Connection conn, String catalog, String schema) {
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.rdbms.omitDatabaseMetaDataGetColumns")) {
            return null;
        }
        RDBMSSchemaInfo schemaInfo = new RDBMSSchemaInfo(catalog, schema);
        ResultSet rs = null;
        try {
            String catalogName = this.getIdentifierForUseWithDatabaseMetaData(catalog);
            String schemaName = this.getIdentifierForUseWithDatabaseMetaData(schema);
            rs = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getColumns(conn, catalogName, schemaName, null, null);
            while (rs.next()) {
                String tableKey;
                RDBMSTableInfo table;
                String colCatalogName = rs.getString(1);
                String colSchemaName = rs.getString(2);
                String colTableName = rs.getString(3);
                if (StringUtils.isWhitespace((String)colTableName)) {
                    throw new NucleusDataStoreException("Invalid 'null' table name identifier returned by database. Check with your JDBC driver vendor (ref:DatabaseMetaData.getColumns).");
                }
                if (rs.wasNull() || colCatalogName != null && colCatalogName.length() < 1) {
                    colCatalogName = null;
                }
                if (rs.wasNull() || colSchemaName != null && colSchemaName.length() < 1) {
                    colSchemaName = null;
                }
                if ((table = (RDBMSTableInfo)schemaInfo.getChild(tableKey = this.getTableKeyInRDBMSSchemaInfo(catalog, schema, colTableName))) == null) {
                    table = new RDBMSTableInfo(colCatalogName, colSchemaName, colTableName);
                    table.addProperty("table_key", tableKey);
                    schemaInfo.addChild((StoreSchemaData)table);
                }
                RDBMSColumnInfo col = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).newRDBMSColumnInfo(rs);
                table.addChild((StoreSchemaData)col);
            }
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException("Exception thrown obtaining schema column information from datastore", (Throwable)sqle);
        }
        finally {
            try {
                if (rs != null) {
                    Statement stmt = rs.getStatement();
                    rs.close();
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException("Exception thrown closing results of DatabaseMetaData.getColumns()", (Throwable)sqle);
            }
        }
        return schemaInfo;
    }

    protected RDBMSTableInfo getRDBMSTableInfoForTable(Connection conn, Table table) {
        String[] c = RDBMSSchemaHandler.splitTableIdentifierName(((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getCatalogSeparator(), table.getIdentifier().getIdentifier());
        String catalogName = table.getCatalogName();
        String schemaName = table.getSchemaName();
        String tableName = table.getIdentifier().getIdentifier();
        if (c[0] != null) {
            catalogName = c[0];
        }
        if (c[1] != null) {
            schemaName = c[1];
        }
        if (c[2] != null) {
            tableName = c[2];
        }
        catalogName = this.getIdentifierForUseWithDatabaseMetaData(catalogName);
        schemaName = this.getIdentifierForUseWithDatabaseMetaData(schemaName);
        tableName = this.getIdentifierForUseWithDatabaseMetaData(tableName);
        return this.getRDBMSTableInfoForTable(conn, catalogName, schemaName, tableName);
    }

    protected RDBMSTableInfo getRDBMSTableInfoForTable(Connection conn, String catalogName, String schemaName, String tableName) {
        String tableKey;
        RDBMSTableInfo tableInfo;
        RDBMSSchemaInfo info = (RDBMSSchemaInfo)this.getSchemaData(conn, "tables", null);
        if (info == null) {
            info = new RDBMSSchemaInfo(this.storeMgr.getCatalogName(), this.storeMgr.getSchemaName());
            this.schemaDataByName.put("tables", (StoreSchemaData)info);
        }
        if ((tableInfo = (RDBMSTableInfo)info.getChild(tableKey = this.getTableKeyInRDBMSSchemaInfo(catalogName, schemaName, tableName))) != null) {
            long time = (Long)tableInfo.getProperty("time");
            long now = System.currentTimeMillis();
            if (now < time + 300000L) {
                return tableInfo;
            }
        }
        boolean insensitiveIdentifiers = this.identifiersCaseInsensitive();
        HashSet<String> tableNames = new HashSet<String>();
        Collection tables = this.storeMgr.getManagedTables(catalogName, schemaName);
        if (tables.size() > 0) {
            for (Table tbl : tables) {
                tableNames.add(insensitiveIdentifiers ? tbl.getIdentifier().getIdentifier().toLowerCase() : tbl.getIdentifier().getIdentifier());
            }
        }
        tableNames.add(insensitiveIdentifiers ? tableName.toLowerCase() : tableName);
        this.refreshTableData(conn, catalogName, schemaName, tableNames);
        tableInfo = (RDBMSTableInfo)info.getChild(tableKey);
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            if (tableInfo == null || tableInfo.getNumberOfChildren() == 0) {
                NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER.msg("050030", (Object)tableName));
            } else {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("050032", (Object)tableName, (Object)("" + tableInfo.getNumberOfChildren())));
            }
        }
        return tableInfo;
    }

    protected RDBMSColumnInfo getRDBMSColumnInfoForColumn(Connection conn, Table table, String columnName) {
        RDBMSColumnInfo colInfo = null;
        RDBMSTableInfo tableInfo = this.getRDBMSTableInfoForTable(conn, table);
        if (tableInfo == null || (colInfo = (RDBMSColumnInfo)tableInfo.getChild(columnName)) == null) {
            // empty if block
        }
        return colInfo;
    }

    private void refreshTableData(Object connection, String catalog, String schema, Collection tableNames) {
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.rdbms.omitDatabaseMetaDataGetColumns")) {
            return;
        }
        if (tableNames == null || tableNames.size() == 0) {
            return;
        }
        RDBMSSchemaInfo info = (RDBMSSchemaInfo)this.getSchemaData(connection, "tables", null);
        if (info == null) {
            info = new RDBMSSchemaInfo(this.storeMgr.getCatalogName(), this.storeMgr.getSchemaName());
            this.schemaDataByName.put("tables", (StoreSchemaData)info);
        }
        Long now = new Long(System.currentTimeMillis());
        ResultSet rs = null;
        HashSet<String> tablesProcessed = new HashSet<String>();
        try {
            Connection conn = (Connection)connection;
            String catalogName = this.getIdentifierForUseWithDatabaseMetaData(catalog);
            String schemaName = this.getIdentifierForUseWithDatabaseMetaData(schema);
            if (tableNames.size() == 1) {
                String tableName = this.getIdentifierForUseWithDatabaseMetaData((String)tableNames.iterator().next());
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("050028", (Object)tableName, (Object)catalogName, (Object)schemaName));
                }
                rs = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getColumns(conn, catalogName, schemaName, tableName, null);
            } else {
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("050028", (Object)StringUtils.collectionToString((Collection)tableNames), (Object)catalogName, (Object)schemaName));
                }
                rs = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getColumns(conn, catalogName, schemaName, null, null);
            }
            boolean insensitiveIdentifiers = this.identifiersCaseInsensitive();
            while (rs.next()) {
                String colCatalogName = rs.getString(1);
                String colSchemaName = rs.getString(2);
                String colTableName = rs.getString(3);
                if (StringUtils.isWhitespace((String)colTableName)) {
                    throw new NucleusDataStoreException("Invalid 'null' table name identifier returned by database. Check with your JDBC driver vendor (ref:DatabaseMetaData.getColumns).");
                }
                if (rs.wasNull() || colCatalogName != null && colCatalogName.length() < 1) {
                    colCatalogName = null;
                }
                if (rs.wasNull() || colSchemaName != null && colSchemaName.length() < 1) {
                    colSchemaName = null;
                }
                String colTableNameToCheck = colTableName;
                if (insensitiveIdentifiers) {
                    colTableNameToCheck = colTableName.toLowerCase();
                }
                if (!tableNames.contains(colTableNameToCheck)) continue;
                String tableKey = this.getTableKeyInRDBMSSchemaInfo(catalog, schema, colTableName);
                RDBMSTableInfo table = (RDBMSTableInfo)info.getChild(tableKey);
                if (tablesProcessed.add(tableKey)) {
                    if (table == null) {
                        table = new RDBMSTableInfo(colCatalogName, colSchemaName, colTableName);
                        table.addProperty("table_key", tableKey);
                        info.addChild((StoreSchemaData)table);
                    } else {
                        table.clearChildren();
                    }
                    table.addProperty("time", now);
                }
                RDBMSColumnInfo col = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).newRDBMSColumnInfo(rs);
                table.addChild((StoreSchemaData)col);
            }
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException("Exception thrown obtaining schema column information from datastore", (Throwable)sqle);
        }
        finally {
            try {
                if (rs != null) {
                    Statement stmt = rs.getStatement();
                    rs.close();
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException("Exception thrown closing results of DatabaseMetaData.getColumns()", (Throwable)sqle);
            }
        }
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("050029", (Object)catalog, (Object)schema, (Object)("" + tablesProcessed.size()), (Object)("" + (System.currentTimeMillis() - now))));
        }
    }

    private String getTableKeyInRDBMSSchemaInfo(String catalog, String schema, String table) {
        SQLIdentifier fullyQualifiedTableName = (SQLIdentifier)this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(table);
        fullyQualifiedTableName.setCatalogName(catalog);
        fullyQualifiedTableName.setSchemaName(schema);
        return fullyQualifiedTableName.getFullyQualifiedName(true);
    }

    private static String[] splitTableIdentifierName(String separator, String name) {
        String[] result = new String[3];
        int p = name.indexOf(separator);
        if (p < 0) {
            result[2] = name;
        } else {
            int p1 = name.indexOf(separator, p + separator.length());
            if (p1 < 0) {
                result[1] = name.substring(0, p);
                result[2] = name.substring(p + separator.length());
            } else {
                result[0] = name.substring(0, p);
                result[1] = name.substring(p + separator.length(), p1);
                result[2] = name.substring(p1 + separator.length());
            }
        }
        if (result[1] != null && result[1].length() < 1) {
            result[1] = null;
        }
        if (result[0] != null && result[0].length() < 1) {
            result[0] = null;
        }
        return result;
    }

    private String getIdentifierForUseWithDatabaseMetaData(String identifier) {
        return StringUtils.replaceAll((String)identifier, (String)this.storeMgr.getDatastoreAdapter().getIdentifierQuoteString(), (String)"");
    }

    private boolean identifiersCaseInsensitive() {
        DatastoreAdapter dba = this.storeMgr.getDatastoreAdapter();
        return !dba.supportsOption("MixedCaseSensitiveIdentifiers") && !dba.supportsOption("MixedCaseQuotedSensitiveIdentifiers");
    }
}

