/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.mapping.ColumnMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class DateRDBMSMapping
extends ColumnMapping {
    protected DateRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public DateRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    public SQLTypeInfo getTypeInfo() {
        return ((RDBMSManager)this.storeMgr).getSQLTypeInfoForJDBCType(91);
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
            } else if (value instanceof Date) {
                ((PreparedStatement)ps).setDate(param, new java.sql.Date(((Date)value).getTime()));
            } else {
                ((PreparedStatement)ps).setDate(param, (java.sql.Date)value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"java.sql.Date", (Object)("" + value)), (Throwable)e);
        }
    }

    protected java.sql.Date getDate(Object rs, int param) {
        java.sql.Date value;
        try {
            value = ((ResultSet)rs).getDate(param);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"java.sql.Date", (Object)("" + param)), (Throwable)e);
        }
        return value;
    }

    public Object getObject(Object rs, int param) {
        java.sql.Date value = this.getDate(rs, param);
        if (value == null) {
            return null;
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
            return new Date(value.getTime());
        }
        return value;
    }
}

