/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.extent;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.extent.AbstractRDBMSExtent;
import org.datanucleus.store.rdbms.query.DiscriminatorIteratorStatement;
import org.datanucleus.store.rdbms.query.PersistentIDROF;
import org.datanucleus.store.rdbms.query.ResultClassROF;
import org.datanucleus.store.rdbms.query.UnionIteratorStatement;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public class ClassTableExtent
extends AbstractRDBMSExtent
implements Queryable {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    private final DatastoreClass[] tables;
    private final boolean multipleTableCase;
    private final DatastoreIdentifier elmIdentifier;

    public ClassTableExtent(ObjectManager om, DatastoreClass table, Class cls, boolean subclasses, AbstractClassMetaData cmd) {
        super(om, cls, subclasses, cmd);
        this.tables = new DatastoreClass[1];
        this.tables[0] = table;
        this.multipleTableCase = false;
        this.elmIdentifier = ((MappedStoreManager)this.storeMgr).getIdentifierFactory().newIdentifier(0, "ELEMENT");
    }

    public ClassTableExtent(ObjectManager om, DatastoreClass[] tables, Class cls, boolean subclasses, AbstractClassMetaData cmd) {
        super(om, cls, subclasses, cmd);
        this.tables = tables;
        this.multipleTableCase = true;
        this.elmIdentifier = ((MappedStoreManager)this.storeMgr).getIdentifierFactory().newIdentifier(0, "ELEMENT");
    }

    public QueryExpression newQueryStatement() {
        return this.newQueryStatement(this.getCandidateClass(), null);
    }

    public QueryExpression newQueryStatement(Class candidateClass, DatastoreIdentifier candidateAlias) {
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        QueryExpression query = null;
        if (this.tables == null) {
            return null;
        }
        for (int i = 0; i < this.tables.length; ++i) {
            int tableNo = i;
            Class cls = null;
            try {
                cls = clr.classForName(this.tables[tableNo].getType(), this.candidateClass.getClassLoader());
            }
            catch (ClassNotResolvedException cnfe) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("053002", (Object)candidateClass.getName(), (Object)this.tables[tableNo].getType())).setFatal();
            }
            if (this.queryUsingDiscriminator()) {
                Class[] candidates = null;
                if (ClassUtils.isReferenceType((Class)candidateClass)) {
                    String[] clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(candidateClass.getName(), clr);
                    candidates = new Class[clsNames.length];
                    for (int j = 0; j < clsNames.length; ++j) {
                        candidates[j] = clr.classForName(clsNames[j]);
                    }
                } else {
                    candidates = new Class[]{candidateClass};
                }
                query = new DiscriminatorIteratorStatement(clr, candidates, this.subclasses, this.storeMgr, true).getQueryStatement(candidateAlias);
                continue;
            }
            boolean completeTableInheritance = this.cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE;
            boolean useSubclassesInStatement = this.subclasses;
            if (completeTableInheritance) {
                useSubclassesInStatement = false;
            }
            QueryExpression query_table = new UnionIteratorStatement(clr, this.multipleTableCase ? cls : candidateClass, useSubclassesInStatement, this.storeMgr, clr.classForName(this.tables[tableNo].getType()), this.tables[tableNo].getIDMapping(), this.tables[tableNo], false, Boolean.TRUE, !completeTableInheritance, false).getQueryStatement(candidateAlias);
            if (query != null) {
                query.union(query_table);
                continue;
            }
            query = query_table;
        }
        return query;
    }

    public ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        JavaTypeMapping versionMapping;
        int[] prefetchFieldNumbers = null;
        StatementExpressionIndex[] statementExpressionIndex = null;
        int[] datastoreIndex = null;
        int[] versionIndex = null;
        if (this.tables[0].getIdentityType() == IdentityType.DATASTORE) {
            datastoreIndex = this.multipleTableCase ? stmt.selectDatastoreIdentity("DATASTORE_ID", true) : (stmt.getTableExpression(this.elmIdentifier) != null ? stmt.select(this.elmIdentifier, this.tables[0].getDataStoreObjectIdMapping(), true) : stmt.select(stmt.getMainTableAlias(), this.tables[0].getDataStoreObjectIdMapping(), true));
        }
        if ((versionMapping = this.tables[0].getVersionMapping(true)) != null) {
            versionIndex = this.multipleTableCase ? stmt.selectVersion("VERSION", true) : (stmt.getTableExpression(this.elmIdentifier) != null ? stmt.select(this.elmIdentifier, versionMapping, true) : stmt.select(stmt.getMainTableAlias(), versionMapping, true));
        }
        if (this.multipleTableCase) {
            AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.getCandidateClass(), stmt.getClassLoaderResolver());
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                prefetchFieldNumbers = new int[cmd.getPKMemberPositions().length];
                int fieldCount = cmd.getNoOfInheritedManagedMembers() + cmd.getNoOfManagedMembers();
                statementExpressionIndex = new StatementExpressionIndex[fieldCount];
                for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
                    prefetchFieldNumbers[i] = cmd.getPKMemberPositions()[i];
                    String fieldName = cmd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i]).getName();
                    JavaTypeMapping m = this.tables[0].getFieldMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i]));
                    if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                    statementExpressionIndex[prefetchFieldNumbers[i]] = new StatementExpressionIndex();
                    statementExpressionIndex[prefetchFieldNumbers[i]].setMapping(m);
                    statementExpressionIndex[prefetchFieldNumbers[i]].setExpressionIndex(stmt.selectField(fieldName, "APP_ID", true));
                }
            }
        } else if (useFetchPlan) {
            AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.getCandidateClass(), stmt.getClassLoaderResolver());
            this.getFetchPlan().manageFetchPlanForClass(cmd);
            FetchPlan.FetchPlanForClass fpc = this.getFetchPlan().getFetchPlanForClass(cmd);
            int[] fieldNumbers = fpc.getFieldsInActualFetchPlan();
            int prefetchFieldCount = 0;
            int fieldCount = cmd.getNoOfInheritedManagedMembers() + cmd.getNoOfManagedMembers();
            int[] fn = new int[fieldNumbers.length];
            statementExpressionIndex = new StatementExpressionIndex[fieldCount];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                JavaTypeMapping m = this.tables[0].getFieldMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]));
                if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                statementExpressionIndex[fieldNumbers[i]] = new StatementExpressionIndex();
                statementExpressionIndex[fieldNumbers[i]].setMapping(m);
                fn[prefetchFieldCount++] = fieldNumbers[i];
            }
            prefetchFieldNumbers = new int[prefetchFieldCount];
            System.arraycopy(fn, 0, prefetchFieldNumbers, 0, prefetchFieldCount);
            if (stmt.getTableExpression(this.elmIdentifier) != null) {
                Mappings.selectMapping(stmt, this.elmIdentifier, statementExpressionIndex);
            } else {
                Mappings.selectMapping(stmt, statementExpressionIndex);
            }
        } else {
            AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.getCandidateClass(), stmt.getClassLoaderResolver());
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                prefetchFieldNumbers = new int[cmd.getPKMemberPositions().length];
                int fieldCount = cmd.getNoOfInheritedManagedMembers() + cmd.getNoOfManagedMembers();
                statementExpressionIndex = new StatementExpressionIndex[fieldCount];
                for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
                    prefetchFieldNumbers[i] = cmd.getPKMemberPositions()[i];
                    JavaTypeMapping m = this.tables[0].getFieldMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i]));
                    if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                    statementExpressionIndex[prefetchFieldNumbers[i]] = new StatementExpressionIndex();
                    statementExpressionIndex[prefetchFieldNumbers[i]].setMapping(m);
                }
                if (stmt.getTableExpression(this.elmIdentifier) != null) {
                    Mappings.selectMapping(stmt, this.elmIdentifier, statementExpressionIndex);
                } else {
                    Mappings.selectMapping(stmt, statementExpressionIndex);
                }
            }
        }
        if (resultClass == null) {
            return new PersistentIDROF(this.tables[0], prefetchFieldNumbers, this.cmd, statementExpressionIndex, datastoreIndex, versionIndex, ignoreCache, this.queryUsingDiscriminator(), stmt.hasMetaDataExpression(), this.getFetchPlan(), this.query.getCandidateClass());
        }
        return new ResultClassROF(resultClass, statementExpressionIndex);
    }

    private boolean queryUsingDiscriminator() {
        boolean usingDiscriminator = true;
        if (this.tables.length == 1) {
            if (this.tables[0].getDiscriminatorMetaData() == null || this.tables[0].getDiscriminatorMapping(false) == null) {
                return false;
            }
            return usingDiscriminator;
        }
        return false;
    }

    public boolean isEmpty() {
        return false;
    }
}

