/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.Localiser;

public final class MappingFactory {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());

    private MappingFactory() {
    }

    public static JavaTypeMapping createMapping(Class mappingClass, DatastoreAdapter dba, String type) {
        JavaTypeMapping mapping = null;
        try {
            mapping = (JavaTypeMapping)mappingClass.newInstance();
        }
        catch (Exception e) {
            throw new NucleusException(LOCALISER.msg("041009", (Object)mappingClass.getName(), (Object)e), (Throwable)e).setFatal();
        }
        mapping.initialize(dba, type);
        return mapping;
    }

    public static JavaTypeMapping createMapping(Class mappingClass, DatastoreAdapter dba, AbstractMemberMetaData fmd, int roleForField, DatastoreContainerObject datastoreContainer, ClassLoaderResolver clr) {
        JavaTypeMapping mapping = null;
        try {
            mapping = (JavaTypeMapping)mappingClass.newInstance();
        }
        catch (Exception e) {
            throw new NucleusException(LOCALISER.msg("041009", (Object)mappingClass.getName(), (Object)e), (Throwable)e).setFatal();
        }
        if (roleForField >= 0) {
            mapping.setRoleForField(roleForField);
        }
        mapping.initialize(dba, fmd, datastoreContainer, clr);
        return mapping;
    }
}

