/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.ArrayMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingFactory;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.ObjectMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.SerialisedElementPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedValuePCMapping;
import org.datanucleus.store.mapped.mapping.SimpleDatastoreRepresentation;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractMappingManager
implements MappingManager {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());

    public abstract void loadDatastoreMapping(PluginManager var1, ClassLoaderResolver var2, String var3);

    public JavaTypeMapping getMapping(Class c, boolean serialised, boolean embedded, MappedStoreManager storeMgr, String fieldName) {
        Class mc = this.getMappingClass(c, serialised, embedded, fieldName, storeMgr);
        JavaTypeMapping m = MappingFactory.createMapping(mc = this.getOverrideMappingClass(mc, null, -1), storeMgr.getDatastoreAdapter(), c.getName());
        if (m == null) {
            String name = mc.getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            throw new NucleusUserException(LOCALISER.msg("041012", (Object)name));
        }
        return m;
    }

    public JavaTypeMapping getMapping(Class c, boolean serialised, boolean embedded, MappedStoreManager storeMgr, ClassLoaderResolver clr) {
        JavaTypeMapping m;
        block3: {
            try {
                DatastoreClass datastoreClass = storeMgr.getDatastoreClass(c.getName(), clr);
                m = datastoreClass.getIDMapping();
            }
            catch (NoTableManagedException ex) {
                Class mc = this.getMappingClass(c, serialised, embedded, null, storeMgr);
                mc = this.getOverrideMappingClass(mc, null, -1);
                m = MappingFactory.createMapping(mc, storeMgr.getDatastoreAdapter(), c.getName());
                if (m == null) {
                    String name = mc.getName();
                    name = name.substring(name.lastIndexOf(46) + 1);
                    throw new NucleusUserException(LOCALISER.msg("041012", (Object)name));
                }
                if (!(m instanceof SimpleDatastoreRepresentation)) break block3;
                this.createDatastoreMapping(m, storeMgr, null, m.getJavaTypeForDatastoreMapping(0));
            }
        }
        return m;
    }

    public JavaTypeMapping getMapping(DatastoreContainerObject datastoreContainer, AbstractMemberMetaData fmd, DatastoreAdapter dba, ClassLoaderResolver clr, int roleForField) {
        Class mc = null;
        String userMappingClassName = fmd.getValueForExtension("mapping-class");
        if (userMappingClassName != null && roleForField != 2 && roleForField != 1 && roleForField != 3 && roleForField != 4) {
            try {
                mc = clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(LOCALISER.msg("041014", (Object)fmd.getFullFieldName(), (Object)userMappingClassName)).setFatal();
            }
        } else if (roleForField == 1 || roleForField == 2) {
            mc = this.getElementMappingClass(datastoreContainer, fmd, dba, clr);
        } else if (roleForField == 3) {
            mc = this.getKeyMappingClass(datastoreContainer, fmd, dba, clr);
        } else if (roleForField == 4) {
            mc = this.getValueMappingClass(datastoreContainer, fmd, dba, clr);
        } else {
            Object acmd = null;
            MappedStoreManager storeMgr = datastoreContainer.getStoreManager();
            acmd = fmd.getType().isInterface() ? storeMgr.getOMFContext().getMetaDataManager().getMetaDataForInterface(fmd.getType(), clr) : storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getType(), clr);
            mc = fmd.isSerialized() ? this.getMappingClass(fmd.getType(), true, false, fmd.getFullFieldName(), storeMgr) : (fmd.getEmbeddedMetaData() != null ? this.getMappingClass(fmd.getType(), false, true, fmd.getFullFieldName(), storeMgr) : (acmd != null && acmd.isEmbeddedOnly() ? this.getMappingClass(fmd.getType(), false, true, fmd.getFullFieldName(), storeMgr) : (fmd.isEmbedded() ? this.getMappingClass(fmd.getType(), true, false, fmd.getFullFieldName(), storeMgr) : this.getMappingClass(fmd.getType(), false, false, fmd.getFullFieldName(), storeMgr))));
        }
        mc = this.getOverrideMappingClass(mc, fmd, roleForField);
        JavaTypeMapping m = MappingFactory.createMapping(mc, dba, fmd, roleForField, datastoreContainer, clr);
        if (m == null) {
            throw new NucleusException(LOCALISER.msg("041011", (Object)mc.getName())).setFatal();
        }
        return m;
    }

    protected Class getOverrideMappingClass(Class mappingClass, AbstractMemberMetaData fmd, int roleForField) {
        return mappingClass;
    }

    protected Class getMappingClass(Class c, boolean serialised, boolean embedded, String fieldName, MappedStoreManager storeMgr) {
        Class superClass;
        Class mappingClass;
        ApiAdapter api = storeMgr.getApiAdapter();
        if (api.isPersistable(c)) {
            if (serialised) {
                return SerialisedPCMapping.class;
            }
            if (embedded) {
                return EmbeddedPCMapping.class;
            }
            return PersistenceCapableMapping.class;
        }
        if (c.isInterface() && !storeMgr.getMappedTypeManager().isSupportedMappedType(c.getName())) {
            if (serialised) {
                return SerialisedReferenceMapping.class;
            }
            if (embedded) {
                return EmbeddedPCMapping.class;
            }
            return InterfaceMapping.class;
        }
        if (c == Object.class) {
            if (serialised) {
                return SerialisedReferenceMapping.class;
            }
            if (embedded) {
                throw new NucleusUserException(LOCALISER.msg("041042", (Object)fieldName)).setFatal();
            }
            return ObjectMapping.class;
        }
        if (c.isArray()) {
            if (api.isPersistable(c.getComponentType())) {
                return ArrayMapping.class;
            }
            if (c.getComponentType().isInterface() && !storeMgr.getMappedTypeManager().isSupportedMappedType(c.getComponentType().getName())) {
                return ArrayMapping.class;
            }
            if (c.getComponentType() == Object.class) {
                return ArrayMapping.class;
            }
        }
        if ((mappingClass = this.getDefaultJavaTypeMapping(storeMgr, c)) == null) {
            for (superClass = c.getSuperclass(); superClass != null && !superClass.getName().equals(ClassNameConstants.Object) && mappingClass == null; superClass = superClass.getSuperclass()) {
                mappingClass = this.getDefaultJavaTypeMapping(storeMgr, superClass);
            }
        }
        if (mappingClass == null) {
            if (storeMgr.getMappedTypeManager().isSupportedMappedType(c.getName())) {
                throw new NucleusUserException(LOCALISER.msg("041001", (Object)fieldName, (Object)c.getName()));
            }
            for (superClass = c; superClass != null && !superClass.getName().equals(ClassNameConstants.Object) && mappingClass == null; superClass = superClass.getSuperclass()) {
                Class<?>[] interfaces = superClass.getInterfaces();
                for (int i = 0; i < interfaces.length && mappingClass == null; ++i) {
                    mappingClass = this.getDefaultJavaTypeMapping(storeMgr, interfaces[i]);
                }
            }
            if (mappingClass == null) {
                mappingClass = SerialisedMapping.class;
            }
        }
        return mappingClass;
    }

    protected Class getElementMappingClass(DatastoreContainerObject container, AbstractMemberMetaData fmd, DatastoreAdapter dba, ClassLoaderResolver clr) {
        if (!fmd.hasCollection() && !fmd.hasArray()) {
            throw new NucleusException("Attempt to get element mapping for field " + fmd.getFullFieldName() + " that has no collection/array!").setFatal();
        }
        if (fmd.getJoinMetaData() == null) {
            throw new NucleusException("Attempt to get element mapping for field " + fmd.getFullFieldName() + " that has no join table defined for the collection/array").setFatal();
        }
        String userMappingClassName = null;
        if (fmd.getElementMetaData() != null) {
            userMappingClassName = fmd.getElementMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                return clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(LOCALISER.msg("041014", (Object)userMappingClassName)).setFatal();
            }
        }
        boolean serialised = fmd.hasCollection() && fmd.getCollection().isSerializedElement() || fmd.hasArray() && fmd.getArray().isSerializedElement();
        boolean embeddedPC = fmd.getElementMetaData() != null && fmd.getElementMetaData().getEmbeddedMetaData() != null;
        boolean elementPC = fmd.hasCollection() && fmd.getCollection().getElementClassMetaData() != null || fmd.hasArray() && fmd.getArray().getElementClassMetaData() != null;
        boolean embedded = true;
        if (fmd.hasCollection()) {
            embedded = fmd.getCollection().isEmbeddedElement();
        } else if (fmd.hasArray()) {
            embedded = fmd.getArray().isEmbeddedElement();
        }
        Class elementCls = null;
        if (fmd.hasCollection()) {
            elementCls = clr.classForName(fmd.getCollection().getElementType());
        } else if (fmd.hasArray()) {
            elementCls = clr.classForName(fmd.getArray().getElementType());
        }
        boolean elementReference = ClassUtils.isReferenceType(elementCls);
        Class mc = null;
        if (serialised) {
            mc = elementPC ? SerialisedElementPCMapping.class : (elementReference ? SerialisedReferenceMapping.class : SerialisedMapping.class);
        } else if (embedded) {
            mc = embeddedPC ? EmbeddedElementPCMapping.class : (elementPC ? PersistenceCapableMapping.class : this.getMappingClass(elementCls, serialised, embedded, fmd.getFullFieldName(), container.getStoreManager()));
        } else {
            throw new NucleusException("Attempt to get element mapping for field " + fmd.getFullFieldName() + " when not embedded or serialised - please report this to JPOX developers").setFatal();
        }
        return mc;
    }

    protected Class getKeyMappingClass(DatastoreContainerObject container, AbstractMemberMetaData fmd, DatastoreAdapter dba, ClassLoaderResolver clr) {
        if (fmd.getMap() == null) {
            throw new NucleusException("Attempt to get key mapping for field that has no map!").setFatal();
        }
        String userMappingClassName = null;
        if (fmd.getKeyMetaData() != null) {
            userMappingClassName = fmd.getKeyMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                return clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(LOCALISER.msg("041014", (Object)userMappingClassName)).setFatal();
            }
        }
        boolean serialised = fmd.hasMap() && fmd.getMap().isSerializedKey();
        boolean embedded = fmd.hasMap() && fmd.getMap().isEmbeddedKey();
        boolean embeddedPC = fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getEmbeddedMetaData() != null;
        boolean keyPC = fmd.hasMap() && fmd.getMap().getKeyClassMetaData() != null;
        Class keyCls = clr.classForName(fmd.getMap().getKeyType());
        boolean keyReference = ClassUtils.isReferenceType((Class)keyCls);
        Class mc = null;
        if (serialised) {
            mc = keyPC ? SerialisedKeyPCMapping.class : (keyReference ? SerialisedReferenceMapping.class : SerialisedMapping.class);
        } else if (embedded) {
            mc = embeddedPC ? EmbeddedKeyPCMapping.class : (keyPC ? PersistenceCapableMapping.class : this.getMappingClass(keyCls, serialised, embedded, fmd.getFullFieldName(), container.getStoreManager()));
        } else {
            throw new NucleusException("Attempt to get key mapping for field " + fmd.getFullFieldName() + " when not embedded or serialised - please report this to JPOX developers").setFatal();
        }
        return mc;
    }

    protected Class getValueMappingClass(DatastoreContainerObject container, AbstractMemberMetaData fmd, DatastoreAdapter dba, ClassLoaderResolver clr) {
        if (fmd.getMap() == null) {
            throw new NucleusException("Attempt to get value mapping for field that has no map!").setFatal();
        }
        String userMappingClassName = null;
        if (fmd.getValueMetaData() != null) {
            userMappingClassName = fmd.getValueMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                return clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(LOCALISER.msg("041014", (Object)userMappingClassName)).setFatal();
            }
        }
        boolean serialised = fmd.hasMap() && fmd.getMap().isSerializedValue();
        boolean embedded = fmd.hasMap() && fmd.getMap().isEmbeddedValue();
        boolean embeddedPC = fmd.getValueMetaData() != null && fmd.getValueMetaData().getEmbeddedMetaData() != null;
        boolean valuePC = fmd.hasMap() && fmd.getMap().getValueClassMetaData() != null;
        Class valueCls = clr.classForName(fmd.getMap().getValueType());
        boolean valueReference = ClassUtils.isReferenceType((Class)valueCls);
        Class mc = null;
        if (serialised) {
            mc = valuePC ? SerialisedValuePCMapping.class : (valueReference ? SerialisedReferenceMapping.class : SerialisedMapping.class);
        } else if (embedded) {
            mc = embeddedPC ? EmbeddedValuePCMapping.class : (valuePC ? PersistenceCapableMapping.class : this.getMappingClass(valueCls, serialised, embedded, fmd.getFullFieldName(), container.getStoreManager()));
        } else {
            throw new NucleusException("Attempt to get value mapping for field " + fmd.getFullFieldName() + " when not embedded or serialised - please report this to JPOX developers").setFatal();
        }
        return mc;
    }

    protected Class getDefaultJavaTypeMapping(MappedStoreManager storeMgr, Class javaType) {
        Class cls = storeMgr.getMappedTypeManager().getMappingType(javaType.getName());
        if (cls == null) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("041000", (Object)javaType.getName()));
            return null;
        }
        return cls;
    }

    public abstract void registerDatastoreMapping(String var1, Class var2, String var3, String var4, boolean var5);

    protected class TypeMapping {
        Class javaMappingType;
        boolean isDefault;

        public TypeMapping(Class javaMappingType, boolean isDefault) {
            this.javaMappingType = javaMappingType;
            this.isDefault = isDefault;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public Class getMappingType() {
            return this.javaMappingType;
        }
    }
}

