/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.datanucleus.store.rdbms.sqlidentifier.SQLIdentifier;
import org.datanucleus.store.rdbms.valuegenerator.AbstractRDBMSGenerator;
import org.datanucleus.store.valuegenerator.AbstractGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.util.NucleusLogger;

public final class SequenceGenerator
extends AbstractRDBMSGenerator {
    protected String sequenceName = null;

    public SequenceGenerator(String name, Properties props) {
        super(name, props);
        ((AbstractGenerator)this).allocationSize = 1;
        if (((AbstractGenerator)this).properties != null && ((Hashtable)((AbstractGenerator)this).properties).get("key-cache-size") != null) {
            try {
                ((AbstractGenerator)this).allocationSize = Integer.parseInt((String)((Hashtable)((AbstractGenerator)this).properties).get("key-cache-size"));
            }
            catch (Exception e) {
                throw new ValueGenerationException(AbstractGenerator.LOCALISER.msg("040006", ((Hashtable)((AbstractGenerator)this).properties).get("key-cache-size")));
            }
        }
        if (((AbstractGenerator)this).properties != null && ((Hashtable)((AbstractGenerator)this).properties).get("sequence-name") == null) {
            throw new ValueGenerationException(AbstractGenerator.LOCALISER.msg("040007", ((Hashtable)((AbstractGenerator)this).properties).get("sequence-name")));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized ValueGenerationBlock reserveBlock(long size) {
        ValueGenerationBlock valueGenerationBlock;
        if (size < 1L) {
            return null;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Long> oid = new ArrayList<Long>();
        RDBMSManager srm = (RDBMSManager)this.storeMgr;
        SQLController sqlControl = srm.getSQLController();
        try {
            RDBMSAdapter dba = (RDBMSAdapter)srm.getDatastoreAdapter();
            String stmt = dba.getSequenceNextStmt(this.getSequenceName());
            ps = sqlControl.getStatementForQuery(this.connection, stmt);
            rs = sqlControl.executeStatementQuery(this.connection, stmt, ps);
            Long nextId = new Long(0L);
            if (rs.next()) {
                nextId = new Long(rs.getLong(1));
                oid.add(nextId);
            }
            int i = 1;
            while ((long)i < size) {
                nextId = new Long(nextId + 1L);
                oid.add(nextId);
                ++i;
            }
            if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                NucleusLogger.VALUEGENERATION.debug((Object)AbstractGenerator.LOCALISER.msg("040004", (Object)("" + size)));
            }
            valueGenerationBlock = new ValueGenerationBlock(oid);
        }
        catch (SQLException e) {
            try {
                throw new ValueGenerationException(AbstractRDBMSGenerator.LOCALISER_RDBMS.msg("061001", (Object)e.getMessage()));
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps == null) throw throwable;
                    sqlControl.closeStatement(this.connection, ps);
                    throw throwable;
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps == null) return valueGenerationBlock;
            sqlControl.closeStatement(this.connection, ps);
            return valueGenerationBlock;
        }
        catch (SQLException e) {
            // empty catch block
        }
        return valueGenerationBlock;
    }

    protected String getSequenceName() {
        if (this.sequenceName == null) {
            String sequenceSchemaName;
            String sequenceCatalogName = ((AbstractGenerator)this).properties.getProperty("sequence-catalog-name");
            if (sequenceCatalogName == null) {
                sequenceCatalogName = ((AbstractGenerator)this).properties.getProperty("catalog-name");
            }
            if ((sequenceSchemaName = ((AbstractGenerator)this).properties.getProperty("sequence-schema-name")) == null) {
                sequenceSchemaName = ((AbstractGenerator)this).properties.getProperty("schema-name");
            }
            String sequenceName = ((AbstractGenerator)this).properties.getProperty("sequence-name");
            RDBMSManager srm = (RDBMSManager)this.storeMgr;
            RDBMSAdapter dba = (RDBMSAdapter)srm.getDatastoreAdapter();
            RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)srm.getIdentifierFactory();
            SQLIdentifier identifier = (SQLIdentifier)idFactory.newSequenceIdentifier(sequenceName);
            if (dba.supportsOption("CatalogInTableDefinition") && sequenceCatalogName != null) {
                identifier.setCatalogName(sequenceCatalogName);
            }
            if (dba.supportsOption("SchemaInTableDefinition") && sequenceSchemaName != null) {
                identifier.setSchemaName(sequenceSchemaName);
            }
            this.sequenceName = identifier.getFullyQualifiedName(true);
        }
        return this.sequenceName;
    }

    protected boolean requiresRepository() {
        return true;
    }

    protected boolean repositoryExists() {
        return super.repositoryExists();
    }

    protected boolean createRepository() {
        PreparedStatement ps = null;
        RDBMSManager srm = (RDBMSManager)this.storeMgr;
        RDBMSAdapter dba = (RDBMSAdapter)srm.getDatastoreAdapter();
        SQLController sqlControl = srm.getSQLController();
        String stmt = dba.getSequenceCreateStmt(this.getSequenceName(), (String)((Hashtable)((AbstractGenerator)this).properties).get("key-min-value"), (String)((Hashtable)((AbstractGenerator)this).properties).get("key-max-value"), (String)((Hashtable)((AbstractGenerator)this).properties).get("key-start-with"), (String)((Hashtable)((AbstractGenerator)this).properties).get("key-increment-by"), (String)((Hashtable)((AbstractGenerator)this).properties).get("key-database-cache-size"));
        try {
            ps = sqlControl.getStatementForUpdate(this.connection, stmt, false);
            sqlControl.executeStatementUpdate(this.connection, stmt, ps, true);
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new ValueGenerationException(AbstractRDBMSGenerator.LOCALISER_RDBMS.msg("061000", (Object)e.getMessage()) + stmt);
        }
        finally {
            try {
                if (ps != null) {
                    sqlControl.closeStatement(this.connection, ps);
                }
            }
            catch (SQLException e) {}
        }
        return true;
    }
}

