/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.sco.SCO;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.exceptions.NoDatastoreMappingException;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;

public abstract class AbstractContainerMapping
extends SingleFieldMapping {
    protected String fieldName;
    protected MappedStoreManager storeMgr;
    static /* synthetic */ Class class$java$util$List;

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.fieldName = fmd.getName();
        this.storeMgr = this.datastoreContainer.getStoreManager();
        ContainerMetaData conmd = fmd.getContainer();
        if (conmd == null) {
            throw new NucleusUserException(JavaTypeMapping.LOCALISER.msg("041023", (Object)fmd.getFullFieldName()));
        }
        if (!this.containerIsStoredInSingleColumn()) {
            this.storeMgr.newJoinDatastoreContainerObject(fmd, clr);
        }
    }

    protected void prepareDatastoreMapping() {
        if (this.containerIsStoredInSingleColumn()) {
            super.prepareDatastoreMapping();
        }
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            return ClassNameConstants.JAVA_IO_SERIALIZABLE;
        }
        return super.getJavaTypeForDatastoreMapping(index);
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        if (this.fmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new NucleusException(this.failureMessage("setObject")).setFatal();
        }
        StateManager[] sms = null;
        ApiAdapter api = om.getApiAdapter();
        if (value != null) {
            HashSet<StateManager> smsColl = null;
            if (value instanceof Collection) {
                Iterator elementsIter = ((Collection)value).iterator();
                while (elementsIter.hasNext()) {
                    StateManager sm;
                    Object elem = elementsIter.next();
                    if (!api.isPersistable(elem) || (sm = om.findStateManager(elem)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet<StateManager>();
                    }
                    smsColl.add(sm);
                }
            } else if (value instanceof Map) {
                Iterator entriesIter = ((Map)value).entrySet().iterator();
                while (entriesIter.hasNext()) {
                    StateManager sm;
                    Map.Entry entry = entriesIter.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (api.isPersistable(key) && (sm = om.findStateManager(key)) != null) {
                        if (smsColl == null) {
                            smsColl = new HashSet();
                        }
                        smsColl.add(sm);
                    }
                    if (!api.isPersistable(val) || (sm = om.findStateManager(val)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet();
                    }
                    smsColl.add(sm);
                }
            }
            if (smsColl != null) {
                sms = smsColl.toArray(new StateManager[smsColl.size()]);
            }
        }
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].setStoringPC();
            }
        }
        this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], value);
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].unsetStoringPC();
            }
        }
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        if (this.fmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new NucleusException(this.failureMessage("getObject")).setFatal();
        }
        return this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]);
    }

    public DatastoreContainerObject getDatastoreContainer() {
        if (this.containerIsStoredInSingleColumn()) {
            return this.datastoreContainer;
        }
        return null;
    }

    public int getNumberOfDatastoreFields() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getNumberOfDatastoreFields();
        }
        return 0;
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDataStoreMapping(index);
        }
        throw new NoDatastoreMappingException(this.fieldName);
    }

    public DatastoreMapping[] getDataStoreMappings() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDataStoreMappings();
        }
        throw new NoDatastoreMappingException(this.fieldName);
    }

    protected boolean containerIsStoredInSingleColumn() {
        return this.fmd != null && this.fmd.isSerialized();
    }

    public boolean includeInFetchStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public boolean includeInUpdateStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public boolean includeInInsertStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public int hashCode() {
        return this.fmd == null || this.storeMgr == null ? super.hashCode() : this.fmd.hashCode() ^ ((Object)((Object)this.storeMgr)).hashCode();
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return null;
    }

    protected SCO replaceFieldWithWrapper(StateManager ownerSM, Object value, boolean forInsert, boolean forUpdate) {
        Class type = this.fmd.getType();
        if (value != null) {
            type = value.getClass();
        } else if (this.fmd.getOrderMetaData() != null && type.isAssignableFrom(class$java$util$List == null ? (class$java$util$List = AbstractContainerMapping.class$("java.util.List")) : class$java$util$List)) {
            type = class$java$util$List == null ? (class$java$util$List = AbstractContainerMapping.class$("java.util.List")) : class$java$util$List;
        }
        SCO sco = SCOUtils.newSCOInstance((StateManager)ownerSM, (AbstractMemberMetaData)this.fmd, (Class)this.fmd.getType(), (Class)type, (Object)value, (boolean)forInsert, (boolean)forUpdate, (boolean)true);
        return sco;
    }

    public void postFetch(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        this.replaceFieldWithWrapper(sm, null, false, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

