/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.math.BigDecimal;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.CharacterExpression;
import org.datanucleus.store.mapped.expression.CharacterLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.StringUtils;

public class FloatingPointLiteral
extends NumericExpression
implements Literal {
    private final BigDecimal value;
    Object rawValue;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$datanucleus$store$mapped$expression$NumericExpression;

    public FloatingPointLiteral(QueryExpression qs, JavaTypeMapping mapping, Float value) {
        super(qs);
        this.mapping = mapping;
        this.value = new BigDecimal(value.toString());
        DatastoreAdapter dba = qs.getStoreManager().getDatastoreAdapter();
        this.st.appendParameter(dba.getMapping(class$java$lang$Float == null ? (class$java$lang$Float = FloatingPointLiteral.class$("java.lang.Float")) : class$java$lang$Float, qs.getStoreManager(), qs.getClassLoaderResolver()), value);
    }

    public Object getValue() {
        return this.value;
    }

    public FloatingPointLiteral(QueryExpression qs, JavaTypeMapping mapping, Double value) {
        super(qs);
        this.mapping = mapping;
        this.value = new BigDecimal(value.toString());
        DatastoreAdapter dba = qs.getStoreManager().getDatastoreAdapter();
        this.st.appendParameter(dba.getMapping(class$java$lang$Double == null ? (class$java$lang$Double = FloatingPointLiteral.class$("java.lang.Double")) : class$java$lang$Double, qs.getStoreManager(), qs.getClassLoaderResolver()), value);
    }

    public FloatingPointLiteral(QueryExpression qs, BigDecimal value) {
        super(qs);
        this.value = value;
        this.st.append(StringUtils.exponentialFormatBigDecimal((BigDecimal)value));
    }

    public BooleanExpression eq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, class$org$datanucleus$store$mapped$expression$NumericExpression == null ? (class$org$datanucleus$store$mapped$expression$NumericExpression = FloatingPointLiteral.class$("org.datanucleus.store.mapped.expression.NumericExpression")) : class$org$datanucleus$store$mapped$expression$NumericExpression);
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) == 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, ScalarExpression.OP_EQ, literal);
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, class$org$datanucleus$store$mapped$expression$NumericExpression == null ? (class$org$datanucleus$store$mapped$expression$NumericExpression = FloatingPointLiteral.class$("org.datanucleus.store.mapped.expression.NumericExpression")) : class$org$datanucleus$store$mapped$expression$NumericExpression);
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) != 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, ScalarExpression.OP_NOTEQ, literal);
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) < 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, ScalarExpression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) <= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, ScalarExpression.OP_LTEQ, expr);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) > 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, ScalarExpression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) >= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, ScalarExpression.OP_GTEQ, expr);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.add(((FloatingPointLiteral)expr).value));
        }
        return super.add(expr);
    }

    public ScalarExpression sub(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.subtract(((FloatingPointLiteral)expr).value));
        }
        return super.sub(expr);
    }

    public ScalarExpression mul(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.multiply(((FloatingPointLiteral)expr).value));
        }
        return super.mul(expr);
    }

    public ScalarExpression div(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.divide(((FloatingPointLiteral)expr).value, 1));
        }
        return super.mul(expr);
    }

    public ScalarExpression neg() {
        return new FloatingPointLiteral(this.qs, this.value.negate());
    }

    public void setRawValue(Object val) {
        this.rawValue = val;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

