/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.valuegenerator.AbstractRDBMSGenerator;
import org.datanucleus.store.valuegenerator.AbstractGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.util.Localiser;

public final class DatastoreUUIDHexGenerator
extends AbstractRDBMSGenerator {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)(class$org$datanucleus$store$rdbms$RDBMSManager == null ? (class$org$datanucleus$store$rdbms$RDBMSManager = DatastoreUUIDHexGenerator.class$("org.datanucleus.store.rdbms.RDBMSManager")) : class$org$datanucleus$store$rdbms$RDBMSManager).getClassLoader());
    static /* synthetic */ Class class$org$datanucleus$store$rdbms$RDBMSManager;
    static /* synthetic */ Class class$java$lang$String;

    public DatastoreUUIDHexGenerator(String name, Properties props) {
        super(name, props);
        ((AbstractGenerator)this).allocationSize = 10;
        if (((AbstractGenerator)this).properties != null && ((Hashtable)((AbstractGenerator)this).properties).get("key-cache-size") != null) {
            try {
                ((AbstractGenerator)this).allocationSize = Integer.parseInt((String)((Hashtable)((AbstractGenerator)this).properties).get("key-cache-size"));
            }
            catch (Exception e) {
                throw new ValueGenerationException(AbstractGenerator.LOCALISER.msg("040006", ((Hashtable)((AbstractGenerator)this).properties).get("key-cache-size")));
            }
        }
    }

    public static Class getStorageClass() {
        return class$java$lang$String == null ? (class$java$lang$String = DatastoreUUIDHexGenerator.class$("java.lang.String")) : class$java$lang$String;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized ValueGenerationBlock reserveBlock(long size) {
        ValueGenerationBlock valueGenerationBlock;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> oid = new ArrayList<String>();
        RDBMSManager srm = (RDBMSManager)this.storeMgr;
        SQLController sqlControl = srm.getSQLController();
        try {
            RDBMSAdapter dba = (RDBMSAdapter)srm.getDatastoreAdapter();
            String stmt = dba.getSelectNewUUIDStmt();
            ps = sqlControl.getStatementForQuery(this.connection, stmt);
            int i = 1;
            while ((long)i < size) {
                rs = sqlControl.executeStatementQuery(this.connection, stmt, ps);
                if (rs.next()) {
                    String nextId = rs.getString(1);
                    oid.add(nextId);
                }
                ++i;
            }
            valueGenerationBlock = new ValueGenerationBlock(oid);
        }
        catch (SQLException e) {
            try {
                throw new ValueGenerationException(AbstractGenerator.LOCALISER.msg("040008", (Object)e.getMessage()));
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps == null) throw throwable;
                    sqlControl.closeStatement(this.connection, ps);
                    throw throwable;
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps == null) return valueGenerationBlock;
            sqlControl.closeStatement(this.connection, ps);
            return valueGenerationBlock;
        }
        catch (SQLException e) {
            // empty catch block
        }
        return valueGenerationBlock;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

