/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerHelper;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.PersistentIDROF;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.util.ClassUtils;

public abstract class ElementContainerStore
extends BaseContainerStore {
    protected boolean iterateUsingDiscriminator = false;
    protected ElementInfo[] elementInfo;
    protected AbstractClassMetaData emd;
    protected DatastoreContainerObject containerTable;
    protected JavaTypeMapping elementMapping;
    protected String elementType;
    protected boolean elementsAreEmbedded;
    protected boolean elementsAreSerialised;
    protected boolean elementIsPersistentInterface = false;
    protected JavaTypeMapping orderMapping;
    protected JavaTypeMapping relationDiscriminatorMapping;
    protected String relationDiscriminatorValue;
    protected final DatastoreIdentifier elmIdentifier;
    protected ClassLoaderResolver clr;
    private String sizeStmt;
    protected String clearStmt;
    protected String addStmt;
    protected String removeStmt;
    protected boolean usingDiscriminatorInSizeStmt = false;

    protected ElementContainerStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr);
        this.clr = clr;
        this.elmIdentifier = ((MappedStoreManager)storeMgr).getIdentifierFactory().newIdentifier(0, "ELEMENT");
    }

    protected ElementInfo[] getElementInformationForClass() {
        String[] clsNames;
        DatastoreClass tbl;
        ElementInfo[] info = null;
        if (!this.clr.classForName(this.elementType).isInterface()) {
            tbl = this.storeMgr.getDatastoreClass(this.elementType, this.clr);
            clsNames = new String[]{this.elementType};
        } else {
            clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.elementType, this.clr);
            tbl = this.storeMgr.getDatastoreClass(clsNames[0], this.clr);
        }
        if (tbl == null) {
            AbstractClassMetaData[] subclassCmds = this.storeMgr.getClassesManagingTableForClass(this.emd, this.clr);
            info = new ElementInfo[subclassCmds.length];
            for (int i = 0; i < subclassCmds.length; ++i) {
                DatastoreClass table = this.storeMgr.getDatastoreClass(subclassCmds[i].getFullClassName(), this.clr);
                info[i] = new ElementInfo(subclassCmds[i], table);
            }
        } else {
            info = new ElementInfo[clsNames.length];
            for (int i = 0; i < clsNames.length; ++i) {
                AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(clsNames[i], this.clr);
                DatastoreClass table = this.storeMgr.getDatastoreClass(cmd.getFullClassName(), this.clr);
                info[i] = new ElementInfo(cmd, table);
            }
        }
        return info;
    }

    public boolean hasOrderMapping() {
        return this.orderMapping != null;
    }

    public String getElementType() {
        return this.elementType;
    }

    protected boolean validateElementType(ClassLoaderResolver clr, Object element) {
        if (element == null) {
            return true;
        }
        Class primitiveElementClass = ClassUtils.getPrimitiveTypeForType(element.getClass());
        if (primitiveElementClass != null) {
            String elementTypeWrapper = this.elementType;
            Class elementTypeClass = clr.classForName(this.elementType);
            if (elementTypeClass.isPrimitive()) {
                elementTypeWrapper = ClassUtils.getWrapperTypeForPrimitiveType((Class)elementTypeClass).getName();
            }
            return clr.isAssignableFrom(elementTypeWrapper, element.getClass());
        }
        return clr.isAssignableFrom(this.elementType, element.getClass());
    }

    protected boolean validateElementForReading(StateManager sm, Object element) {
        ObjectManager om;
        if (!this.validateElementType(sm.getObjectManager().getClassLoaderResolver(), element)) {
            return false;
        }
        return element == null || this.elementsAreEmbedded || this.elementsAreSerialised || (om = sm.getObjectManager()).getApiAdapter().isPersistent(element) && om == ObjectManagerHelper.getObjectManager((Object)element) || om.getApiAdapter().isDetached(element);
    }

    protected boolean validateElementForWriting(StateManager sm, Object element, FieldValues fieldValues) {
        if (!this.elementIsPersistentInterface && !this.validateElementType(sm.getObjectManager().getClassLoaderResolver(), element)) {
            throw new ClassCastException(BaseContainerStore.LOCALISER.msg("056033", (Object)element.getClass().getName(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)this.elementType));
        }
        boolean persisted = false;
        if (!this.elementsAreEmbedded && !this.elementsAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            StateManager elementSM = om.findStateManager(element);
            if (elementSM != null && elementSM.isEmbedded()) {
                throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056028", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
            }
            persisted = SCOUtils.validateObjectForWriting((ObjectManager)om, (Object)element, (FieldValues)fieldValues);
        }
        return persisted;
    }

    protected int populateElementInStatement(ObjectManager om, PreparedStatement ps, Object element, int jdbcPosition) {
        if (!((RDBMSMapping)this.elementMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        this.elementMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.elementMapping), element);
        return jdbcPosition + this.elementMapping.getNumberOfDatastoreFields();
    }

    protected int populateOrderInStatement(ObjectManager om, PreparedStatement ps, int idx, int jdbcPosition) {
        this.orderMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.orderMapping), new Integer(idx));
        return jdbcPosition + this.orderMapping.getNumberOfDatastoreFields();
    }

    protected int populateRelationDiscriminatorInStatement(ObjectManager om, PreparedStatement ps, int jdbcPosition) {
        this.relationDiscriminatorMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.relationDiscriminatorMapping), this.relationDiscriminatorValue);
        return jdbcPosition + this.relationDiscriminatorMapping.getNumberOfDatastoreFields();
    }

    protected int populateElementDiscriminatorInStatement(ObjectManager om, PreparedStatement ps, int jdbcPosition, boolean includeSubclasses, ElementInfo info) {
        HashSet subclasses;
        DiscriminatorStrategy strategy = info.getDiscriminatorStrategy();
        JavaTypeMapping discrimMapping = info.getDiscriminatorMapping();
        if (strategy == DiscriminatorStrategy.CLASS_NAME) {
            discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), info.getClassName());
            jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
        } else if (strategy == DiscriminatorStrategy.VALUE_MAP) {
            discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), info.getAbstractClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData().getValue());
            jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
        }
        if (includeSubclasses && (subclasses = this.storeMgr.getSubClassesForClass(info.getClassName(), true, this.clr)) != null && subclasses.size() > 0) {
            Iterator iter = subclasses.iterator();
            while (iter.hasNext()) {
                String subclass = (String)iter.next();
                if (strategy == DiscriminatorStrategy.CLASS_NAME) {
                    discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), subclass);
                    jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
                    continue;
                }
                if (strategy != DiscriminatorStrategy.VALUE_MAP) continue;
                AbstractClassMetaData subclassCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(subclass, this.clr);
                discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), subclassCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue());
                jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
            }
        }
        return jdbcPosition;
    }

    protected int populateEmbeddedElementFieldsInStatement(StateManager sm, Object element, PreparedStatement ps, int jdbcPosition, JoinTable joinTable) {
        EmbeddedElementPCMapping embeddedMapping = (EmbeddedElementPCMapping)this.elementMapping;
        StatementExpressionIndex[] statementExpressionIndex = new StatementExpressionIndex[this.emd.getNoOfManagedMembers() + this.emd.getNoOfInheritedManagedMembers()];
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = this.emd.getAbsolutePositionOfMember(fieldMapping.getFieldMetaData().getName());
            if (fieldMapping == null) continue;
            statementExpressionIndex[absFieldNum] = new StatementExpressionIndex();
            statementExpressionIndex[absFieldNum].setMapping(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            statementExpressionIndex[absFieldNum].setParameterIndex(jdbcParamPositions);
        }
        StateManager elementSM = this.getStateManagerForEmbeddedPCObject(sm, element, joinTable);
        elementSM.setPcObjectType(2);
        elementSM.provideFields(elementFieldNumbers, (FieldManager)new ParameterSetter(elementSM, ps, statementExpressionIndex, true));
        return jdbcPosition;
    }

    protected String getClearStmt() {
        if (this.clearStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("DELETE FROM ");
            stmt.append(this.containerTable.toString());
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.clearStmt = stmt.toString();
        }
        return this.clearStmt;
    }

    public abstract Iterator iterator(StateManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        HashSet dependentElements = null;
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (collmd.isDependentElement() && !collmd.isEmbeddedElement() && !collmd.isSerializedElement()) {
            dependentElements = new HashSet();
            Iterator iter = this.iterator(ownerSM);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        String clearStmt = this.getClearStmt();
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    sqlControl.executeStatementUpdate(mconn, clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(BaseContainerStore.LOCALISER.msg("056013", (Object)clearStmt), (Throwable)e);
        }
        if (dependentElements != null && dependentElements.size() > 0) {
            Iterator iter = dependentElements.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (ownerSM.getObjectManager().getApiAdapter().isDeleted(obj)) continue;
                ownerSM.getObjectManager().deleteObjectInternal(obj);
            }
        }
    }

    protected String getSizeStmt() {
        int i;
        int i2;
        if (this.sizeStmt != null && !this.usingDiscriminatorInSizeStmt) {
            return this.sizeStmt;
        }
        boolean allowNulls = false;
        if (this.ownerMemberMetaData != null && this.ownerMemberMetaData.hasExtension("allow-nulls") && this.ownerMemberMetaData.getValueForExtension("allow-nulls").equalsIgnoreCase("true")) {
            allowNulls = true;
        }
        StringBuffer stmt = new StringBuffer();
        String containerAlias = "THIS";
        String joinedElementAlias = "ELEM";
        stmt.append("SELECT COUNT(*) FROM ");
        stmt.append(this.containerTable.toString()).append(" ").append(containerAlias);
        boolean joinedDiscrim = false;
        if (this.elementInfo != null && this.elementInfo.length == 1 && this.elementInfo[0].getDatastoreClass() != this.containerTable && this.elementInfo[0].getDiscriminatorMapping() != null) {
            joinedDiscrim = true;
            JavaTypeMapping elemIdMapping = this.elementInfo[0].getDatastoreClass().getIDMapping();
            if (allowNulls) {
                stmt.append(" LEFT OUTER JOIN ");
            } else {
                stmt.append(" INNER JOIN ");
            }
            stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString()).append(" ").append(joinedElementAlias).append(" ON ");
            for (i2 = 0; i2 < this.elementMapping.getNumberOfDatastoreFields(); ++i2) {
                if (i2 > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(containerAlias).append(".").append(this.elementMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier());
                stmt.append("=");
                stmt.append(joinedElementAlias).append(".").append(elemIdMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier());
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(containerAlias).append(".").append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append("=");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.orderMapping != null) {
            for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(">=0");
            }
        }
        if (this.elementInfo != null && this.elementInfo.length == 1) {
            StringBuffer discrStmt = new StringBuffer();
            for (i2 = 0; i2 < this.elementInfo.length; ++i2) {
                if (this.elementInfo[i2].getDiscriminatorMapping() == null) continue;
                this.usingDiscriminatorInSizeStmt = true;
                if (discrStmt.length() > 0) {
                    discrStmt.append(" OR ");
                }
                JavaTypeMapping discrimMapping = this.elementInfo[i2].getDiscriminatorMapping();
                for (int j = 0; j < discrimMapping.getNumberOfDatastoreFields(); ++j) {
                    if (joinedDiscrim) {
                        discrStmt.append(joinedElementAlias);
                    } else {
                        discrStmt.append(containerAlias);
                    }
                    discrStmt.append(".");
                    discrStmt.append(((Object)discrimMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                    discrStmt.append("=");
                    discrStmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(j)).getUpdateInputParameter());
                }
                HashSet subclasses = this.storeMgr.getSubClassesForClass(this.elementInfo[i2].getClassName(), true, this.clr);
                if (subclasses == null || subclasses.size() <= 0) continue;
                for (int j = 0; j < subclasses.size(); ++j) {
                    for (int k = 0; k < discrimMapping.getNumberOfDatastoreFields(); ++k) {
                        discrStmt.append(" OR ");
                        if (joinedDiscrim) {
                            discrStmt.append(joinedElementAlias);
                        } else {
                            discrStmt.append(containerAlias);
                        }
                        discrStmt.append(".");
                        discrStmt.append(((Object)discrimMapping.getDataStoreMapping(k).getDatastoreField().getIdentifier()).toString());
                        discrStmt.append("=");
                        discrStmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(k)).getUpdateInputParameter());
                    }
                }
            }
            if (discrStmt.length() > 0) {
                stmt.append(" AND (");
                stmt.append(discrStmt);
                if (allowNulls) {
                    stmt.append(" OR ");
                    stmt.append(((Object)this.elementInfo[0].getDiscriminatorMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" IS NULL");
                }
                stmt.append(")");
            }
        }
        if (this.relationDiscriminatorMapping != null) {
            for (int i3 = 0; i3 < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i3) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i3).getDatastoreField().getIdentifier()).toString());
                stmt.append("=");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i3)).getUpdateInputParameter());
            }
        }
        this.sizeStmt = stmt.toString();
        return this.sizeStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(StateManager sm) {
        int numRows;
        String sizeStmt = this.getSizeStmt();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, sizeStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    if (this.elementInfo != null && this.elementInfo.length == 1) {
                        for (int i = 0; i < this.elementInfo.length; ++i) {
                            if (this.elementInfo[i].getDiscriminatorMapping() == null) continue;
                            jdbcPosition = this.populateElementDiscriminatorInStatement(om, ps, jdbcPosition, true, this.elementInfo[i]);
                        }
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, sizeStmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new NucleusDataStoreException(BaseContainerStore.LOCALISER.msg("056007", (Object)sizeStmt));
                        }
                        numRows = rs.getInt(1);
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(BaseContainerStore.LOCALISER.msg("056007", (Object)sizeStmt), (Throwable)e);
        }
        return numRows;
    }

    protected String getAddStmt() {
        if (this.addStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("INSERT INTO ");
            stmt.append(this.containerTable.toString());
            stmt.append(" (");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                }
            }
            stmt.append(") VALUES (");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getInsertionInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(0)).getInsertionInputParameter());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(0)).getInsertionInputParameter());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(0)).getInsertionInputParameter());
                }
            }
            stmt.append(") ");
            this.addStmt = stmt.toString();
        }
        return this.addStmt;
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression stmt, boolean ignoreCache, boolean useFetchPlan) {
        JavaTypeMapping verMapping;
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return new PersistentIDROF(null, null, this.emd, null, null, null, ignoreCache, false, stmt.hasMetaDataExpression(), null, clr.classForName(this.elementType));
        }
        if (this.elementMapping instanceof ReferenceMapping) {
            JavaTypeMapping[] implMappings = ((ReferenceMapping)this.elementMapping).getJavaTypeMapping();
            for (int i = 0; i < implMappings.length; ++i) {
                stmt.select(implMappings[i]);
            }
            return new PersistentIDROF(this.elementInfo != null ? this.elementInfo[0].getDatastoreClass() : null, null, this.emd, null, null, null, ignoreCache, false, stmt.hasMetaDataExpression(), null, clr.classForName(this.elementType));
        }
        int[] datastoreIndex = null;
        int[] versionIndex = null;
        if (stmt.getTableExpression(this.elmIdentifier) != null) {
            if (this.elementInfo[0].getDatastoreClass().getIdentityType() == IdentityType.DATASTORE) {
                datastoreIndex = stmt.select(this.elmIdentifier, this.elementInfo[0].getDatastoreClass().getDataStoreObjectIdMapping(), true);
            }
            if ((verMapping = this.elementInfo[0].getDatastoreClass().getVersionMapping(true)) != null) {
                versionIndex = stmt.select(this.elmIdentifier, verMapping, true);
            }
        } else {
            if (this.elementInfo[0].getDatastoreClass().getIdentityType() == IdentityType.DATASTORE) {
                datastoreIndex = stmt.select(stmt.getMainTableAlias(), this.elementInfo[0].getDatastoreClass().getDataStoreObjectIdMapping(), true);
            }
            if ((verMapping = this.elementInfo[0].getDatastoreClass().getVersionMapping(true)) != null) {
                versionIndex = stmt.select(stmt.getMainTableAlias(), verMapping, true);
            }
        }
        StatementExpressionIndex[] statementExpressionIndex = null;
        int[] prefetchFieldNumbers = null;
        int[] pkFieldNumbers = null;
        if (this.emd.getIdentityType() == IdentityType.APPLICATION) {
            pkFieldNumbers = new int[this.emd.getPKMemberPositions().length];
            for (int i = 0; i < pkFieldNumbers.length; ++i) {
                pkFieldNumbers[i] = this.emd.getPKMemberPositions()[i];
            }
        }
        if (useFetchPlan) {
            FetchPlan fp = sm.getObjectManager().getFetchPlan();
            fp.manageFetchPlanForClass(this.emd);
            FetchPlan.FetchPlanForClass fpc = fp.getFetchPlanForClass(this.emd);
            int[] fpFieldNumbers = fpc.getFieldsInActualFetchPlan();
            if (pkFieldNumbers != null) {
                int i;
                int totalFieldCount = pkFieldNumbers.length + fpFieldNumbers.length;
                for (int i2 = 0; i2 < pkFieldNumbers.length; ++i2) {
                    if (Arrays.binarySearch(fpFieldNumbers, pkFieldNumbers[i2]) < 0) continue;
                    --totalFieldCount;
                }
                int prefetchNum = 0;
                prefetchFieldNumbers = new int[totalFieldCount];
                for (i = 0; i < pkFieldNumbers.length; ++i) {
                    prefetchFieldNumbers[prefetchNum++] = pkFieldNumbers[i];
                }
                for (i = 0; i < fpFieldNumbers.length; ++i) {
                    if (Arrays.binarySearch(pkFieldNumbers, fpFieldNumbers[i]) >= 0) continue;
                    prefetchFieldNumbers[prefetchNum++] = fpFieldNumbers[i];
                }
            } else {
                prefetchFieldNumbers = fpFieldNumbers;
            }
        } else {
            prefetchFieldNumbers = pkFieldNumbers != null ? pkFieldNumbers : new int[]{};
        }
        int[] fn = new int[prefetchFieldNumbers.length];
        int prefetchFieldCount = 0;
        statementExpressionIndex = new StatementExpressionIndex[this.emd.getNoOfInheritedManagedMembers() + this.emd.getNoOfManagedMembers()];
        for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
            JavaTypeMapping m;
            AbstractMemberMetaData fmd = this.emd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i]);
            if (fmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT || (m = this.elementInfo[0].getDatastoreClass().getFieldMapping(fmd)) == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
            statementExpressionIndex[prefetchFieldNumbers[i]] = new StatementExpressionIndex();
            statementExpressionIndex[prefetchFieldNumbers[i]].setMapping(m);
            fn[prefetchFieldCount++] = prefetchFieldNumbers[i];
        }
        int[] fieldNumbers = new int[prefetchFieldCount];
        System.arraycopy(fn, 0, fieldNumbers, 0, prefetchFieldCount);
        if (stmt.getTableExpression(this.elmIdentifier) != null) {
            Mappings.selectMapping(stmt, this.elmIdentifier, statementExpressionIndex);
        } else {
            Mappings.selectMapping(stmt, statementExpressionIndex);
        }
        return new PersistentIDROF(this.elementInfo != null ? this.elementInfo[0].getDatastoreClass() : null, fieldNumbers, this.emd, statementExpressionIndex, datastoreIndex, versionIndex, ignoreCache, this.iterateUsingDiscriminator, stmt.hasMetaDataExpression(), null, clr.classForName(this.elementType));
    }

    public class ElementInfo {
        AbstractClassMetaData cmd;
        DatastoreClass table;

        public ElementInfo(AbstractClassMetaData cmd, DatastoreClass table) {
            this.cmd = cmd;
            this.table = table;
        }

        public String getClassName() {
            return this.cmd.getFullClassName();
        }

        public AbstractClassMetaData getAbstractClassMetaData() {
            return this.cmd;
        }

        public DatastoreClass getDatastoreClass() {
            return this.table;
        }

        public DiscriminatorStrategy getDiscriminatorStrategy() {
            return this.cmd.getDiscriminatorStrategy();
        }

        public JavaTypeMapping getDiscriminatorMapping() {
            return this.table.getDiscriminatorMapping(false);
        }
    }
}

