/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import javax.imageio.ImageIO;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.datatype.BlobImpl;
import org.datanucleus.store.rdbms.mapping.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.TypeConversionHelper;

public abstract class AbstractLargeBinaryRDBMSMapping
extends ColumnMapping {
    static /* synthetic */ Class array$Ljava$math$BigDecimal;
    static /* synthetic */ Class array$Ljava$math$BigInteger;
    static /* synthetic */ Class class$java$util$BitSet;
    static /* synthetic */ Class class$java$awt$image$BufferedImage;

    protected AbstractLargeBinaryRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public AbstractLargeBinaryRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    protected void initialize() {
        this.initTypeInfo();
    }

    public void setObject(Object ps, int param, Object value) {
        if (value == null) {
            try {
                ((PreparedStatement)ps).setBytes(param, null);
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException(RDBMSMapping.LOCALISER.msg("055001", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)sqle.getMessage()), (Throwable)sqle);
            }
        }
        try {
            if (this.getJavaTypeMapping().isSerialised()) {
                if (!(value instanceof Serializable)) {
                    throw new NucleusDataStoreException(RDBMSMapping.LOCALISER.msg("055005", (Object)value.getClass().getName()));
                }
                BlobImpl b = new BlobImpl(value);
                ((PreparedStatement)ps).setBytes(param, b.getBytes(0L, (int)b.length()));
            } else if (value instanceof boolean[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromBooleanArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof char[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromCharArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof double[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromDoubleArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof float[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromFloatArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof int[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromIntArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof long[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromLongArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof short[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromShortArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Boolean[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromBooleanObjectArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Byte[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromByteObjectArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Character[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromCharObjectArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Double[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromDoubleObjectArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Float[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromFloatObjectArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Integer[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromIntObjectArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Long[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromLongObjectArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Short[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromShortObjectArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof BigDecimal[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromBigDecimalArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof BigInteger[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromBigIntegerArray((Object)value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof byte[]) {
                ((PreparedStatement)ps).setBytes(param, (byte[])value);
            } else if (value instanceof BitSet) {
                byte[] data = TypeConversionHelper.getByteArrayFromBooleanArray((Object)TypeConversionHelper.getBooleanArrayFromBitSet((BitSet)((BitSet)value)));
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof BufferedImage) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                ImageIO.write((RenderedImage)((BufferedImage)value), "jpg", baos);
                byte[] buffer = baos.toByteArray();
                baos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                ((PreparedStatement)ps).setBytes(param, buffer);
                bais.close();
            } else {
                if (!(value instanceof Serializable)) {
                    throw new NucleusDataStoreException(RDBMSMapping.LOCALISER.msg("055005", (Object)value.getClass().getName()));
                }
                BlobImpl b = new BlobImpl(value);
                ((PreparedStatement)ps).setBytes(param, b.getBytes(0L, (int)b.length()));
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(RDBMSMapping.LOCALISER.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public Object getObject(Object rs, int param) {
        byte[] bytes = null;
        try {
            bytes = ((ResultSet)rs).getBytes(param);
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException(RDBMSMapping.LOCALISER.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)sqle.getMessage()), (Throwable)sqle);
        }
        if (bytes == null) {
            return null;
        }
        if (this.getJavaTypeMapping().isSerialised()) {
            try {
                BlobImpl blob = new BlobImpl(bytes);
                return blob.getObject();
            }
            catch (SQLException sqle) {
                return null;
            }
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.BOOLEAN_ARRAY)) {
            return TypeConversionHelper.getBooleanArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.BYTE_ARRAY)) {
            return bytes;
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.CHAR_ARRAY)) {
            return TypeConversionHelper.getCharArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.DOUBLE_ARRAY)) {
            return TypeConversionHelper.getDoubleArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.FLOAT_ARRAY)) {
            return TypeConversionHelper.getFloatArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.INT_ARRAY)) {
            return TypeConversionHelper.getIntArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.LONG_ARRAY)) {
            return TypeConversionHelper.getLongArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.SHORT_ARRAY)) {
            return TypeConversionHelper.getShortArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_BOOLEAN_ARRAY)) {
            return TypeConversionHelper.getBooleanObjectArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_BYTE_ARRAY)) {
            return TypeConversionHelper.getByteObjectArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_CHARACTER_ARRAY)) {
            return TypeConversionHelper.getCharObjectArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_DOUBLE_ARRAY)) {
            return TypeConversionHelper.getDoubleObjectArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_FLOAT_ARRAY)) {
            return TypeConversionHelper.getFloatObjectArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_INTEGER_ARRAY)) {
            return TypeConversionHelper.getIntObjectArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_LONG_ARRAY)) {
            return TypeConversionHelper.getLongObjectArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_SHORT_ARRAY)) {
            return TypeConversionHelper.getShortObjectArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals((array$Ljava$math$BigDecimal == null ? (array$Ljava$math$BigDecimal = AbstractLargeBinaryRDBMSMapping.class$("[Ljava.math.BigDecimal;")) : array$Ljava$math$BigDecimal).getName())) {
            return TypeConversionHelper.getBigDecimalArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getType().equals((array$Ljava$math$BigInteger == null ? (array$Ljava$math$BigInteger = AbstractLargeBinaryRDBMSMapping.class$("[Ljava.math.BigInteger;")) : array$Ljava$math$BigInteger).getName())) {
            return TypeConversionHelper.getBigIntegerArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getJavaType() != null && this.getJavaTypeMapping().getJavaType().getName().equals((class$java$util$BitSet == null ? (class$java$util$BitSet = AbstractLargeBinaryRDBMSMapping.class$("java.util.BitSet")) : class$java$util$BitSet).getName())) {
            return TypeConversionHelper.getBitSetFromBooleanArray((boolean[])((boolean[])TypeConversionHelper.getBooleanArrayFromByteArray((byte[])bytes)));
        }
        if (this.getJavaTypeMapping().getJavaType() != null && this.getJavaTypeMapping().getJavaType().getName().equals((class$java$awt$image$BufferedImage == null ? (class$java$awt$image$BufferedImage = AbstractLargeBinaryRDBMSMapping.class$("java.awt.image.BufferedImage")) : class$java$awt$image$BufferedImage).getName())) {
            try {
                return ImageIO.read(new ByteArrayInputStream(bytes));
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(RDBMSMapping.LOCALISER.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
        try {
            BlobImpl blob = new BlobImpl(bytes);
            return blob.getObject();
        }
        catch (SQLException sqle) {
            return null;
        }
    }

    public void setString(Object preparedStatement, int exprIndex, String value) {
        this.setObject(preparedStatement, exprIndex, value);
    }

    public String getString(Object resultSet, int exprIndex) {
        Object obj = this.getObject(resultSet, exprIndex);
        return (String)obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

