/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class RDBMSAdapterFactory {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)(class$org$datanucleus$store$rdbms$RDBMSManager == null ? (class$org$datanucleus$store$rdbms$RDBMSManager = RDBMSAdapterFactory.class$("org.datanucleus.store.rdbms.RDBMSManager")) : class$org$datanucleus$store$rdbms$RDBMSManager).getClassLoader());
    static /* synthetic */ Class class$org$datanucleus$store$rdbms$RDBMSManager;
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;

    public static RDBMSAdapterFactory getInstance() {
        return new RDBMSAdapterFactory();
    }

    protected RDBMSAdapterFactory() {
    }

    public DatastoreAdapter getDatastoreAdapter(ClassLoaderResolver clr, Connection conn, String adapterClassName, PluginManager pluginMgr) throws SQLException {
        DatastoreAdapter adapter = null;
        DatabaseMetaData metadata = conn.getMetaData();
        adapter = this.getNewDatastoreAdapter(clr, metadata, adapterClassName, pluginMgr);
        if (adapter == null) {
            NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("051000"));
            adapter = new DatabaseAdapter(metadata);
        }
        return adapter;
    }

    protected DatastoreAdapter getNewDatastoreAdapter(ClassLoaderResolver clr, DatabaseMetaData metadata, String adapterClassName, PluginManager pluginMgr) {
        Object adapter_obj;
        if (metadata == null) {
            return null;
        }
        String productName = null;
        if (adapterClassName == null) {
            try {
                productName = metadata.getDatabaseProductName();
                if (productName == null) {
                    NucleusLogger.DATASTORE.error((Object)LOCALISER.msg("051024"));
                    return null;
                }
            }
            catch (SQLException sqe) {
                NucleusLogger.DATASTORE.error((Object)LOCALISER.msg("051025", (Object)sqe));
                return null;
            }
        }
        try {
            Class adapterClass = this.getAdapterClass(pluginMgr, adapterClassName, productName, clr);
            Object[] ctr_args = new Object[]{metadata};
            Class[] ctr_args_classes = new Class[]{class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = RDBMSAdapterFactory.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData};
            Constructor ctr = adapterClass.getConstructor(ctr_args_classes);
            try {
                adapter_obj = ctr.newInstance(ctr_args);
            }
            catch (InvocationTargetException ite) {
                if (ite.getTargetException() != null && ite.getTargetException() instanceof NucleusDataStoreException) {
                    throw (NucleusDataStoreException)ite.getTargetException();
                }
                return null;
            }
            catch (Exception e) {
                NucleusLogger.DATASTORE.error((Object)LOCALISER.msg("051026", (Object)adapterClassName, (Object)e));
                return null;
            }
        }
        catch (ClassNotResolvedException ex) {
            NucleusLogger.DATASTORE.error((Object)LOCALISER.msg("051026", (Object)adapterClassName, (Object)ex));
            return null;
        }
        catch (NoSuchMethodException nsme) {
            NucleusLogger.DATASTORE.error((Object)LOCALISER.msg("051026", (Object)adapterClassName, (Object)nsme));
            return null;
        }
        return (DatastoreAdapter)adapter_obj;
    }

    protected Class getAdapterClass(PluginManager pluginMgr, String adapterClassName, String productName, ClassLoaderResolver clr) {
        ConfigurationElement highestMatchingAdapter = null;
        int highestPriority = Integer.MIN_VALUE;
        Extension[] ex = pluginMgr.getExtensionPoint("org.datanucleus.store_datastoreadapter").getExtensions();
        for (int i = 0; i < ex.length; ++i) {
            ConfigurationElement[] confElm = ex[i].getConfigurationElements();
            for (int c = 0; c < confElm.length; ++c) {
                int priority;
                if (adapterClassName != null) {
                    if (!confElm[c].getAttribute("class-name").equals(adapterClassName)) continue;
                    return pluginMgr.loadClass(confElm[c].getExtension().getPlugin().getSymbolicName(), confElm[c].getAttribute("class-name"));
                }
                String vendorId = confElm[c].getAttribute("vendor-id");
                if (productName.toLowerCase().indexOf(vendorId.toLowerCase()) < 0 || (priority = Integer.parseInt(confElm[c].getAttribute("priority"))) < highestPriority) continue;
                if (priority > highestPriority && highestMatchingAdapter != null) {
                    NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("051002", (Object)highestMatchingAdapter.getAttribute("class-name"), (Object)highestMatchingAdapter.getAttribute("vendor-id"), (Object)String.valueOf(priority), (Object)confElm[c].getAttribute("class-name")));
                }
                highestMatchingAdapter = confElm[c];
                highestPriority = priority;
            }
        }
        if (adapterClassName != null) {
            return clr.classForName(adapterClassName, false);
        }
        if (highestMatchingAdapter != null) {
            return pluginMgr.loadClass(highestMatchingAdapter.getExtension().getPlugin().getSymbolicName(), highestMatchingAdapter.getAttribute("class-name"));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

