/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.FetchStatement;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.TableMismatchException;

public class TableExprAsSubquery
extends LogicSetExpression {
    protected final ArrayList columns = new ArrayList();
    protected boolean multipleTablesReferenced = false;

    public TableExprAsSubquery(QueryExpression qs, DatastoreContainerObject mainTable, DatastoreIdentifier alias) {
        super(qs, mainTable, alias);
    }

    public String referenceColumn(DatastoreField col) {
        this.assertNotFrozen();
        DatastoreContainerObject table = col.getDatastoreContainerObject();
        if (!table.equals(this.mainTable)) {
            if (!(this.mainTable instanceof DatastoreClass) || !(table instanceof DatastoreClass)) {
                throw new TableMismatchException(col, this.mainTable);
            }
            this.multipleTablesReferenced = true;
        }
        if (!this.columns.contains(col)) {
            this.columns.add(col);
        }
        if (((Object)this.mainAlias).toString().length() > 0) {
            return col.applySelectFunction(this.mainAlias + "." + col.getIdentifier());
        }
        return col.applySelectFunction(((Object)col.getIdentifier()).toString());
    }

    public String toString() {
        if (this.sqlText == null) {
            StringBuffer sb = new StringBuffer();
            DatastoreIdentifier mainTableName = this.mainTable.getIdentifier();
            if (!this.multipleTablesReferenced) {
                sb.append(this.mainTable.toString());
                if (!this.mainAlias.equals(mainTableName)) {
                    sb.append(' ').append(this.mainAlias);
                }
            } else {
                FetchStatement subQuery = this.mainTable.getStoreManager().getFetchStatement(this.mainTable);
                Iterator i = ((AbstractList)this.columns).iterator();
                while (i.hasNext()) {
                    subQuery.select((DatastoreField)i.next());
                }
                sb.append('(').append(subQuery.toString(false)).append(") ").append(this.mainAlias);
            }
            this.sqlText = sb.toString();
        }
        return this.sqlText;
    }
}

